/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.InfoReliability;
import org.jetbrains.idea.svn.branchConfig.InfoStorage;
import org.jetbrains.idea.svn.branchConfig.NewRootBunch;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.branchConfig.SvnBranchItem;
import org.jetbrains.idea.svn.browse.DirectoryEntryConsumer;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

public class DefaultBranchConfigInitializer
implements Runnable {
    private static final Logger LOG = Logger.getInstance(DefaultBranchConfigInitializer.class);
    @NonNls
    private static final String DEFAULT_TRUNK_NAME = "trunk";
    @NonNls
    private static final String DEFAULT_BRANCHES_NAME = "branches";
    @NonNls
    private static final String DEFAULT_TAGS_NAME = "tags";
    @NotNull
    private final Project myProject;
    @NotNull
    private final NewRootBunch myBunch;
    @NotNull
    private final VirtualFile myRoot;

    public DefaultBranchConfigInitializer(@NotNull Project project, @NotNull NewRootBunch bunch, @NotNull VirtualFile root) {
        this.myProject = project;
        this.myRoot = root;
        this.myBunch = bunch;
    }

    @Override
    public void run() {
        SvnBranchConfigurationNew configuration = this.getDefaultConfiguration();
        if (configuration != null) {
            for (Url url : configuration.getBranchLocations()) {
                this.myBunch.reloadBranchesAsync(this.myRoot, url, InfoReliability.defaultValues);
            }
            this.myBunch.updateForRoot(this.myRoot, new InfoStorage<SvnBranchConfigurationNew>(configuration, InfoReliability.defaultValues), false);
        }
    }

    @Nullable
    public SvnBranchConfigurationNew getDefaultConfiguration() {
        SvnBranchConfigurationNew result = null;
        SvnVcs vcs = SvnVcs.getInstance(this.myProject);
        Url rootUrl = SvnUtil.getUrl(vcs, VfsUtilCore.virtualToIoFile((VirtualFile)this.myRoot));
        if (rootUrl != null) {
            try {
                result = DefaultBranchConfigInitializer.getDefaultConfiguration(vcs, rootUrl);
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
            }
        } else {
            LOG.info("Directory is not a working copy: " + this.myRoot.getPresentableUrl());
        }
        return result;
    }

    @NotNull
    private static SvnBranchConfigurationNew getDefaultConfiguration(@NotNull SvnVcs vcs, @NotNull Url url) throws VcsException {
        SvnBranchConfigurationNew result = new SvnBranchConfigurationNew();
        result.setTrunk(url);
        Url branchLocationsParent = DefaultBranchConfigInitializer.getBranchLocationsParent(url);
        if (branchLocationsParent != null) {
            Target target = Target.on(branchLocationsParent);
            vcs.getFactory(target).createBrowseClient().list(target, Revision.HEAD, Depth.IMMEDIATES, DefaultBranchConfigInitializer.createHandler(result, target.getUrl()));
        }
        return result;
    }

    @Nullable
    private static Url getBranchLocationsParent(@NotNull Url url) throws SvnBindException {
        while (!DefaultBranchConfigInitializer.hasEmptyName(url) && !DefaultBranchConfigInitializer.hasDefaultName(url)) {
            url = SvnUtil.removePathTail(url);
        }
        return DefaultBranchConfigInitializer.hasDefaultName(url) ? SvnUtil.removePathTail(url) : null;
    }

    private static boolean hasEmptyName(@NotNull Url url) {
        return StringUtil.isEmpty((String)url.getTail());
    }

    private static boolean hasDefaultName(@NotNull Url url) {
        String name = url.getTail();
        return name.equalsIgnoreCase(DEFAULT_TRUNK_NAME) || name.equalsIgnoreCase(DEFAULT_BRANCHES_NAME) || name.equalsIgnoreCase(DEFAULT_TAGS_NAME);
    }

    @NotNull
    private static DirectoryEntryConsumer createHandler(@NotNull SvnBranchConfigurationNew result, @NotNull Url rootPath) {
        return entry -> {
            if (entry.isDirectory()) {
                Url childUrl = SvnUtil.append(rootPath, entry.getName());
                if (StringUtil.endsWithIgnoreCase((String)entry.getName(), (String)DEFAULT_TRUNK_NAME)) {
                    result.setTrunk(childUrl);
                } else {
                    result.addBranches(childUrl, new InfoStorage<List<SvnBranchItem>>(new ArrayList(0), InfoReliability.defaultValues));
                }
            }
        };
    }
}

