/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.properties.PropertyClient;
import org.jetbrains.idea.svn.properties.PropertyValue;

public class SvnMergeProvider
implements MergeProvider {
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance(SvnMergeProvider.class);

    public SvnMergeProvider(Project project) {
        this.myProject = project;
    }

    @NotNull
    public MergeData loadRevisions(@NotNull VirtualFile file) throws VcsException {
        ByteArrayOutputStream contents;
        MergeData data = new MergeData();
        File oldFile = null;
        File newFile = null;
        File workingFile = null;
        boolean mergeCase = false;
        SvnVcs vcs = SvnVcs.getInstance(this.myProject);
        Info info2 = vcs.getInfo(file);
        if (info2 != null) {
            oldFile = info2.getConflictOldFile();
            newFile = info2.getConflictNewFile();
            workingFile = info2.getConflictWrkFile();
            boolean bl = mergeCase = workingFile == null || workingFile.getName().contains("working");
            if (workingFile == null) {
                LOG.info("Null working file when merging text conflict for " + file.getPath() + " old file: " + oldFile + " new file: " + newFile);
            }
            if (mergeCase) {
                oldFile = info2.getConflictNewFile();
                newFile = info2.getConflictOldFile();
                workingFile = info2.getConflictWrkFile();
            }
        } else {
            throw new VcsException("Could not get info for " + file.getPath());
        }
        data.LAST_REVISION_NUMBER = new SvnRevisionNumber(info2.getRevision());
        if (oldFile == null || newFile == null || workingFile == null) {
            ByteArrayOutputStream bos = this.getBaseRevisionContents(vcs, file);
            data.ORIGINAL = bos.toByteArray();
            data.LAST = bos.toByteArray();
            data.CURRENT = SvnMergeProvider.readFile(VfsUtilCore.virtualToIoFile((VirtualFile)file));
        } else {
            data.ORIGINAL = SvnMergeProvider.readFile(oldFile);
            data.LAST = SvnMergeProvider.readFile(newFile);
            data.CURRENT = SvnMergeProvider.readFile(workingFile);
        }
        if (mergeCase && !Arrays.equals((contents = this.getBaseRevisionContents(vcs, file)).toByteArray(), data.ORIGINAL)) {
            byte[] original = data.ORIGINAL;
            data.ORIGINAL = data.LAST;
            data.LAST = original;
        }
        return data;
    }

    private ByteArrayOutputStream getBaseRevisionContents(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            byte[] contents = SvnUtil.getFileContents(vcs, Target.on(VfsUtilCore.virtualToIoFile((VirtualFile)file)), Revision.BASE, Revision.UNDEFINED);
            bos.write(contents);
        }
        catch (VcsException | IOException e) {
            LOG.warn(e);
        }
        return bos;
    }

    private static byte[] readFile(File workingFile) throws VcsException {
        try {
            return FileUtil.loadFileBytes((File)workingFile);
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
    }

    public void conflictResolvedForFile(@NotNull VirtualFile file) {
        SvnVcs vcs = SvnVcs.getInstance(this.myProject);
        File path = VfsUtilCore.virtualToIoFile((VirtualFile)file);
        try {
            vcs.getFactory(path).createConflictClient().resolve(path, Depth.EMPTY, false, true, true);
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
        }
        VirtualFile parent = file.getParent();
        if (parent != null) {
            parent.refresh(true, false);
        }
    }

    public boolean isBinary(@NotNull VirtualFile file) {
        SvnVcs vcs = SvnVcs.getInstance(this.myProject);
        try {
            File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
            PropertyClient client = vcs.getFactory(ioFile).createPropertyClient();
            PropertyValue value = client.getProperty(Target.on(ioFile), "svn:mime-type", false, Revision.WORKING);
            if (value != null && SvnMergeProvider.isBinaryMimeType(value.toString())) {
                return true;
            }
        }
        catch (SvnBindException e) {
            LOG.warn((Throwable)((Object)e));
        }
        return false;
    }

    private static boolean isBinaryMimeType(@NotNull String mimeType) {
        return !mimeType.startsWith("text/");
    }
}

