/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.WaitForProgressToShow;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnStatusUtil;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.BasicAction;
import org.jetbrains.idea.svn.dialogs.RelocateDialog;
import org.jetbrains.idea.svn.info.Info;

public class RelocateAction
extends BasicAction {
    private static final Logger LOG = Logger.getInstance(RelocateAction.class);

    @Override
    @NotNull
    protected String getActionName() {
        return "Relocate working copy to a different URL";
    }

    @Override
    protected boolean isEnabled(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        return SvnStatusUtil.isUnderControl(vcs, file);
    }

    @Override
    protected void perform(@NotNull SvnVcs vcs, @NotNull VirtualFile file, @NotNull DataContext context) {
        String afterURL;
        Info info2 = vcs.getInfo(file);
        if (info2 == null) {
            LOG.info("Could not get info for " + file);
            return;
        }
        RelocateDialog dlg = new RelocateDialog(vcs.getProject(), info2.getUrl());
        if (!dlg.showAndGet()) {
            return;
        }
        String beforeURL = dlg.getBeforeURL();
        if (beforeURL.equals(afterURL = dlg.getAfterURL())) {
            return;
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.setIndeterminate(true);
            }
            try {
                File path = VfsUtilCore.virtualToIoFile((VirtualFile)file);
                vcs.getFactory(path).createRelocateClient().relocate(path, SvnUtil.createUrl(beforeURL, false), SvnUtil.createUrl(afterURL, false));
                VcsDirtyScopeManager.getInstance((Project)vcs.getProject()).markEverythingDirty();
            }
            catch (VcsException e) {
                WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> Messages.showErrorDialog((Project)vcs.getProject(), (String)("Error relocating working copy: " + e.getMessage()), (String)"Relocate Working Copy"), null, (Project)vcs.getProject());
            }
        }, "Relocating Working Copy", false, vcs.getProject());
    }

    @Override
    protected void batchPerform(@NotNull SvnVcs vcs, VirtualFile @NotNull [] files, @NotNull DataContext context) {
    }

    @Override
    protected boolean isBatchAction() {
        return false;
    }
}

