/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.configurationStore.StoreUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnStatusUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.BasicAction;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.conflict.ConflictClient;
import org.jetbrains.idea.svn.dialogs.SelectFilesDialog;
import org.jetbrains.idea.svn.status.StatusClient;
import org.jetbrains.idea.svn.status.StatusType;

public class MarkResolvedAction
extends BasicAction {
    private static final Logger LOG = Logger.getInstance(MarkResolvedAction.class);

    @Override
    @NotNull
    protected String getActionName() {
        return SvnBundle.message("action.name.mark.resolved", new Object[0]);
    }

    @Override
    protected boolean needsAllFiles() {
        return false;
    }

    @Override
    protected boolean isEnabled(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        FileStatus status = FileStatusManager.getInstance((Project)vcs.getProject()).getStatus(file);
        return file.isDirectory() ? SvnStatusUtil.isUnderControl(vcs, file) : FileStatus.MERGED_WITH_CONFLICTS.equals(status) || FileStatus.MERGED_WITH_BOTH_CONFLICTS.equals(status) || FileStatus.MERGED_WITH_PROPERTY_CONFLICTS.equals(status);
    }

    @Override
    protected void perform(@NotNull SvnVcs vcs, @NotNull VirtualFile file, @NotNull DataContext context) throws VcsException {
        this.batchPerform(vcs, (VirtualFile[])ContainerUtil.ar((Object[])new VirtualFile[]{file}), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void batchPerform(@NotNull SvnVcs vcs, VirtualFile @NotNull [] files, @NotNull DataContext context) throws VcsException {
        StoreUtil.saveDocumentsAndProjectSettings((Project)vcs.getProject());
        Collection<String> paths = MarkResolvedAction.collectResolvablePaths(vcs, files);
        if (paths.isEmpty()) {
            Messages.showInfoMessage((Project)vcs.getProject(), (String)SvnBundle.message("message.text.no.conflicts.found", new Object[0]), (String)SvnBundle.message("message.title.no.conflicts.found", new Object[0]));
            return;
        }
        String[] pathsArray = ArrayUtilRt.toStringArray(paths);
        SelectFilesDialog dialog = new SelectFilesDialog(vcs.getProject(), SvnBundle.message("label.select.files.and.directories.to.mark.resolved", new Object[0]), SvnBundle.message("dialog.title.mark.resolved", new Object[0]), SvnBundle.message("action.name.mark.resolved", new Object[0]), pathsArray, "vcs.subversion.resolve");
        if (!dialog.showAndGet()) {
            return;
        }
        pathsArray = dialog.getSelectedPaths();
        try {
            for (String string : pathsArray) {
                File ioFile = new File(string);
                ConflictClient client = vcs.getFactory(ioFile).createConflictClient();
                client.resolve(ioFile, Depth.EMPTY, true, true, true);
            }
        }
        finally {
            for (String string : files) {
                VcsDirtyScopeManager.getInstance((Project)vcs.getProject()).fileDirty((VirtualFile)string);
                string.refresh(true, false);
                if (string.getParent() == null) continue;
                string.getParent().refresh(true, false);
            }
        }
    }

    @Override
    protected boolean isBatchAction() {
        return true;
    }

    @NotNull
    private static Collection<String> collectResolvablePaths(@NotNull SvnVcs vcs, VirtualFile @NotNull [] files) {
        TreeSet<String> result = new TreeSet<String>();
        for (VirtualFile file : files) {
            try {
                File path = VfsUtilCore.virtualToIoFile((VirtualFile)file);
                StatusClient client = vcs.getFactory(path).createStatusClient();
                client.doStatus(path, Depth.INFINITY, false, false, false, false, status -> {
                    if (status.is(StatusType.STATUS_CONFLICTED) || status.isProperty(StatusType.STATUS_CONFLICTED)) {
                        result.add(status.getFile().getAbsolutePath());
                    }
                });
            }
            catch (SvnBindException e) {
                LOG.warn((Throwable)((Object)e));
            }
        }
        return result;
    }
}

