/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.NestedCopyInfo;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.StatusReceiver;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;

public class NestedCopiesBuilder
implements StatusReceiver {
    @NotNull
    private final Set<NestedCopyInfo> myCopies;
    @NotNull
    private final SvnFileUrlMapping myMapping;
    @NotNull
    private final SvnVcs myVcs;

    public NestedCopiesBuilder(@NotNull SvnVcs vcs, @NotNull SvnFileUrlMapping mapping) {
        this.myVcs = vcs;
        this.myMapping = mapping;
        this.myCopies = new HashSet<NestedCopyInfo>();
    }

    @Override
    public void process(@NotNull FilePath path, Status status) {
        VirtualFile file = path.getVirtualFile();
        if (file != null) {
            if (status.is(StatusType.STATUS_EXTERNAL)) {
                this.myCopies.add(new NestedCopyInfo(file, null, WorkingCopyFormat.UNKNOWN, NestedCopyType.external, null));
            } else if (status.getUrl() != null && !status.is(StatusType.STATUS_UNVERSIONED) && status.isSwitched()) {
                this.myCopies.add(new NestedCopyInfo(file, status.getUrl(), this.myVcs.getWorkingCopyFormat(path.getIOFile()), NestedCopyType.switched, status.getRepositoryRootUrl()));
            }
        }
    }

    @Override
    public void processCopyRoot(@NotNull VirtualFile file, @Nullable Url url, @NotNull WorkingCopyFormat format, @Nullable Url rootURL) {
        this.myCopies.add(new NestedCopyInfo(file, url, format, NestedCopyType.inner, rootURL));
    }

    @Override
    public void bewareRoot(@NotNull VirtualFile vf, Url url) {
        File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)vf);
        RootUrlInfo info2 = this.myMapping.getWcRootForFilePath(VcsUtil.getFilePath((VirtualFile)vf));
        if (info2 != null && FileUtil.filesEqual((File)ioFile, (File)info2.getIoFile()) && !info2.getUrl().equals(url)) {
            this.myVcs.invokeRefreshSvnRoots();
        }
    }

    @Override
    public void finish() {
    }

    @NotNull
    public Set<NestedCopyInfo> getCopies() {
        return this.myCopies;
    }
}

