/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.utils.TokenizedCommandLine;
import com.google.common.collect.Lists;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0007\u00a8\u0006\t"}, d2={"Lcom/android/utils/StringHelperPOSIX;", "", "()V", "splitCommandLine", "", "", "commandLine", "tokenizeCommandLineToEscaped", "tokenizeCommandLineToRaw", "android.sdktools.common"})
public final class StringHelperPOSIX {
    public static final StringHelperPOSIX INSTANCE;

    @JvmStatic
    @NotNull
    public static final List<String> splitCommandLine(@NotNull String commandLine) {
        List commands = Lists.newArrayList();
        boolean quoting = false;
        char quote = '\u0000';
        boolean escaping = false;
        int commandStart = 0;
        int i2 = 0;
        while (i2 < commandLine.length()) {
            char c = commandLine.charAt(i2);
            if (escaping) {
                escaping = false;
                ++i2;
                continue;
            }
            if (!(c != '\\' || quoting && quote != '\"')) {
                escaping = true;
                ++i2;
                continue;
            }
            if (!(quoting || c != '\"' && c != '\'')) {
                quoting = true;
                quote = c;
                ++i2;
                continue;
            }
            if (quoting && c == quote) {
                quoting = false;
                quote = '\u0000';
                ++i2;
                continue;
            }
            if (!quoting) {
                int matched = 0;
                if (commandLine.length() > i2 + 1 && commandLine.charAt(i2) == '&' && commandLine.charAt(i2 + 1) == '&') {
                    matched = 2;
                } else if (commandLine.charAt(i2) == ';') {
                    matched = 1;
                }
                if (matched > 0) {
                    String string = commandLine;
                    boolean bl = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.substring(commandStart, i2);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    commands.add(string3);
                    commandStart = i2 += matched;
                }
            }
            ++i2;
        }
        if (commandStart < commandLine.length()) {
            String string = commandLine;
            boolean bl = false;
            String string4 = string;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(commandStart);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            commands.add(string5);
        }
        return commands;
    }

    @JvmStatic
    @NotNull
    public static final List<String> tokenizeCommandLineToEscaped(@NotNull String commandLine) {
        return new TokenizedCommandLine(commandLine, false, 1, null, 8, null).toTokenList();
    }

    @JvmStatic
    @NotNull
    public static final List<String> tokenizeCommandLineToRaw(@NotNull String commandLine) {
        return new TokenizedCommandLine(commandLine, true, 1, null, 8, null).toTokenList();
    }

    private StringHelperPOSIX() {
    }

    static {
        StringHelperPOSIX stringHelperPOSIX;
        INSTANCE = stringHelperPOSIX = new StringHelperPOSIX();
    }
}

