/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.io.FileTextMatcher;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.io.impl.DirectoryContentSpecImpl;
import com.intellij.util.io.impl.DirectoryContentSpecImplKt$WhenMappings;
import com.intellij.util.io.impl.DirectorySpec;
import com.intellij.util.io.impl.DirectorySpecBase;
import com.intellij.util.io.impl.FileSpec;
import com.intellij.util.io.impl.ZipSpec;
import java.io.Closeable;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a(\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000fH\u0002\u001a\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0007*\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"assertDirectoryContentMatches", "", "file", "Ljava/io/File;", "spec", "Lcom/intellij/util/io/impl/DirectoryContentSpecImpl;", "relativePath", "", "fileTextMatcher", "Lcom/intellij/util/io/FileTextMatcher;", "assertDirectoryMatches", "Lcom/intellij/util/io/impl/DirectorySpecBase;", "createSpecByDirectory", "Lcom/intellij/util/io/impl/DirectorySpec;", "dir", "Ljava/nio/file/Path;", "createSpecByPath", "path", "convertToText", "", "intellij.platform.testFramework"})
public final class DirectoryContentSpecImplKt {
    public static final void assertDirectoryContentMatches(@NotNull File file2, @NotNull DirectoryContentSpecImpl spec, @NotNull String relativePath, @NotNull FileTextMatcher fileTextMatcher) {
        block1: {
            String place;
            block3: {
                byte[] actualBytes;
                DirectoryContentSpecImpl directoryContentSpecImpl;
                block2: {
                    block0: {
                        Assert.assertTrue((String)(file2 + " doesn't exist"), (boolean)file2.exists());
                        directoryContentSpecImpl = spec;
                        if (!(directoryContentSpecImpl instanceof DirectorySpec)) break block0;
                        DirectoryContentSpecImplKt.assertDirectoryMatches(file2, (DirectorySpecBase)spec, relativePath, fileTextMatcher);
                        break block1;
                    }
                    if (!(directoryContentSpecImpl instanceof ZipSpec)) break block2;
                    Assert.assertTrue((String)(file2 + " is not a file"), (boolean)file2.isFile());
                    File dirForExtracted = FileUtil.createTempDirectory((String)("extracted-" + file2.getName()), null, (boolean)false);
                    ZipUtil.extract((File)file2, (File)dirForExtracted, null);
                    DirectoryContentSpecImplKt.assertDirectoryMatches(dirForExtracted, (DirectorySpecBase)spec, relativePath, fileTextMatcher);
                    FileUtil.delete((File)dirForExtracted);
                    break block1;
                }
                if (!(directoryContentSpecImpl instanceof FileSpec)) break block1;
                Assert.assertTrue((String)(file2 + " is not a file"), (boolean)file2.isFile());
                if (((FileSpec)spec).getContent() == null || Arrays.equals(actualBytes = FileUtil.loadFileBytes((File)file2), ((FileSpec)spec).getContent())) break block1;
                String actualString = DirectoryContentSpecImplKt.convertToText(actualBytes);
                String expectedString = DirectoryContentSpecImplKt.convertToText(((FileSpec)spec).getContent());
                String string = place = Intrinsics.areEqual((Object)relativePath, (Object)"") ^ true ? " at " + relativePath : "";
                if (actualString == null || expectedString == null) break block3;
                if (fileTextMatcher.matches(actualString, expectedString)) break block1;
                Assert.assertEquals((String)("File content mismatch" + place + ':'), (Object)expectedString, (Object)actualString);
                break block1;
            }
            Assert.fail((String)("Binary file content mismatch" + place));
        }
    }

    private static final String convertToText(byte[] $this$convertToText) {
        Charset charset;
        CharsetToolkit.GuessedEncoding encoding = new CharsetToolkit($this$convertToText, Charsets.UTF_8).guessFromContent($this$convertToText.length);
        switch (DirectoryContentSpecImplKt$WhenMappings.$EnumSwitchMapping$0[encoding.ordinal()]) {
            case 1: {
                charset = Charsets.US_ASCII;
                break;
            }
            case 2: {
                charset = Charsets.UTF_8;
                break;
            }
            default: {
                return null;
            }
        }
        Charset charset2 = charset;
        boolean bl = false;
        return new String($this$convertToText, charset2);
    }

    private static final void assertDirectoryMatches(File file2, DirectorySpecBase spec, String relativePath, FileTextMatcher fileTextMatcher) {
        Assert.assertTrue((String)(file2 + " is not a directory"), (boolean)file2.isDirectory());
        List actualChildrenNames = ArraysKt.sortedWith((Object[])file2.list(), (Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        Map<String, DirectoryContentSpecImpl> children = spec.getChildren();
        List expectedChildrenNames = CollectionsKt.sortedWith((Iterable)children.keySet(), (Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        Assert.assertEquals((String)("Directory content mismatch" + (Intrinsics.areEqual((Object)relativePath, (Object)"") ^ true ? " at " + relativePath : "") + ':'), (Object)CollectionsKt.joinToString$default((Iterable)expectedChildrenNames, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), (Object)CollectionsKt.joinToString$default((Iterable)actualChildrenNames, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        Iterable $this$forEach$iv = actualChildrenNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String child = (String)element$iv;
            boolean bl = false;
            File file3 = new File(file2, child);
            DirectoryContentSpecImpl directoryContentSpecImpl = children.get(child);
            if (directoryContentSpecImpl == null) {
                Intrinsics.throwNpe();
            }
            DirectoryContentSpecImplKt.assertDirectoryContentMatches(file3, directoryContentSpecImpl, relativePath + '/' + child, fileTextMatcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DirectorySpec createSpecByDirectory(@NotNull Path dir) {
        DirectorySpec spec = new DirectorySpec();
        Path $this$directoryStreamIfExists$iv = dir;
        boolean $i$f$directoryStreamIfExists = false;
        try {
            Closeable closeable = Files.newDirectoryStream($this$directoryStreamIfExists$iv);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                DirectoryStream children = (DirectoryStream)closeable;
                boolean bl3 = false;
                Iterable $this$forEach$iv = children;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Path it = (Path)element$iv;
                    boolean bl4 = false;
                    spec.addChild(((Object)it.getFileName()).toString(), DirectoryContentSpecImplKt.createSpecByPath(it));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        return spec;
    }

    private static final DirectoryContentSpecImpl createSpecByPath(Path path) {
        if (PathKt.isFile((Path)path)) {
            return new FileSpec(Files.readAllBytes(path));
        }
        return DirectoryContentSpecImplKt.createSpecByDirectory(path);
    }
}

