/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.testFramework.CodeStyleSettingsTracker;
import com.intellij.testFramework.HeavyPlatformTestCase;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.SdkLeakTracker;
import com.intellij.testFramework.TestApplicationManager;
import com.intellij.testFramework.TestApplicationManagerKt;
import com.intellij.testFramework.TestDataProvider;
import com.intellij.testFramework.fixtures.LightIdeaTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import com.intellij.util.ThrowableRunnable;
import org.jetbrains.annotations.NotNull;

public final class LightIdeaTestFixtureImpl
extends BaseFixture
implements LightIdeaTestFixture {
    private final LightProjectDescriptor myProjectDescriptor;
    private SdkLeakTracker myOldSdks;
    private CodeStyleSettingsTracker myCodeStyleSettingsTracker;
    private Project myProject;
    private Module myModule;

    public LightIdeaTestFixtureImpl(@NotNull LightProjectDescriptor projectDescriptor) {
        this.myProjectDescriptor = projectDescriptor;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        TestApplicationManager application = TestApplicationManager.getInstance();
        Pair.NonNull<Project, Module> setup = LightPlatformTestCase.doSetup(this.myProjectDescriptor, LocalInspectionTool.EMPTY_ARRAY, this.getTestRootDisposable());
        this.myProject = (Project)setup.getFirst();
        this.myModule = (Module)setup.getSecond();
        InjectedLanguageManagerImpl.pushInjectors((Project)this.getProject());
        this.myCodeStyleSettingsTracker = new CodeStyleSettingsTracker(this::getCurrentCodeStyleSettings);
        application.setDataProvider(new TestDataProvider(this.getProject()));
        this.myOldSdks = new SdkLeakTracker();
    }

    @Override
    public void tearDown() {
        Project project2 = this.getProject();
        if (project2 != null) {
            CodeStyle.dropTemporarySettings((Project)project2);
        }
        new RunAll(new ThrowableRunnable[0]).append(() -> {
            if (this.myCodeStyleSettingsTracker != null) {
                this.myCodeStyleSettingsTracker.checkForSettingsDamage();
            }
        }).append(() -> {
            StartMarkAction.checkCleared((Project)project2);
            InplaceRefactoring.checkCleared();
        }).append(() -> {
            if (project2 != null) {
                TestApplicationManagerKt.waitForProjectLeakingThreads(project2);
            }
        }).append(() -> super.tearDown()).append(() -> {
            this.myProject = null;
            this.myModule = null;
            if (project2 != null) {
                TestApplicationManagerKt.tearDownProjectAndApp(project2);
            }
        }).append(() -> LightPlatformTestCase.checkEditorsReleased()).append(() -> {
            SdkLeakTracker oldSdks = this.myOldSdks;
            if (oldSdks != null) {
                oldSdks.checkForJdkTableLeaks();
            }
        }).append(() -> {
            if (project2 != null) {
                InjectedLanguageManagerImpl.checkInjectorsAreDisposed((Project)project2);
            }
        }).append(() -> {
            ManagingFS managingFS;
            Application app = ApplicationManager.getApplication();
            if (app != null && (managingFS = (ManagingFS)app.getServiceIfCreated(ManagingFS.class)) != null) {
                ((PersistentFS)managingFS).clearIdCache();
            }
        }).append(() -> HeavyPlatformTestCase.cleanupApplicationCaches(project2)).run();
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    private CodeStyleSettings getCurrentCodeStyleSettings() {
        if (CodeStyleSchemes.getInstance().getCurrentScheme() == null) {
            return CodeStyle.createTestSettings();
        }
        return CodeStyle.getSettings((Project)this.getProject());
    }

    @Override
    public Module getModule() {
        return this.myModule;
    }
}

