/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.testFramework.builders.ModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.HeavyIdeaTestFixture;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import com.intellij.testFramework.fixtures.impl.HeavyIdeaTestFixtureImpl;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

final class HeavyTestFixtureBuilderImpl
implements TestFixtureBuilder<IdeaProjectTestFixture> {
    private final HeavyIdeaTestFixtureImpl myFixture;
    private final Map<Class<? extends ModuleFixtureBuilder<?>>, Class<? extends ModuleFixtureBuilder<?>>> myProviders;

    HeavyTestFixtureBuilderImpl(HeavyIdeaTestFixtureImpl fixture, Map<Class<? extends ModuleFixtureBuilder<?>>, Class<? extends ModuleFixtureBuilder<?>>> providers) {
        this.myFixture = fixture;
        this.myProviders = providers;
    }

    @Override
    @NotNull
    public HeavyIdeaTestFixture getFixture() {
        return this.myFixture;
    }

    @Override
    public <M extends ModuleFixtureBuilder<?>> M addModule(@NotNull Class<M> builderClass) {
        ModuleFixtureBuilder builder;
        HeavyTestFixtureBuilderImpl.loadClassConstants(builderClass);
        Class<ModuleFixtureBuilder<?>> aClass = this.myProviders.get(builderClass);
        Assert.assertNotNull((String)builderClass.toString(), aClass);
        Constructor<?>[] constructors = aClass.getDeclaredConstructors();
        if (constructors.length > 1) {
            Arrays.sort(constructors, (c0, c1) -> c1.getParameterCount() - c0.getParameterCount());
        }
        Constructor<?> constructor = constructors[0];
        constructor.setAccessible(true);
        try {
            builder = constructor.getParameterCount() == 1 ? (ModuleFixtureBuilder)constructor.newInstance(this) : (ModuleFixtureBuilder)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        this.myFixture.addModuleFixtureBuilder(builder);
        return (M)builder;
    }

    private static void loadClassConstants(@NotNull Class<?> builderClass) {
        try {
            for (Field field : builderClass.getFields()) {
                field.get(null);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

