/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.AssumptionViolatedException;

public final class IoTestUtil {
    public static final boolean isSymLinkCreationSupported = SystemInfo.isUnix || SystemInfo.isWinVistaOrNewer && IoTestUtil.canCreateSymlinks();
    private static final String[] UNICODE_PARTS = new String[]{"\u042e\u043d\u0438\u043a\u043e\u0434\u0435", "\u00da\u00f1\u00ed\u00e7\u00f8d\u00ea"};

    private IoTestUtil() {
    }

    @Nullable
    public static String getUnicodeName() {
        return IoTestUtil.filterParts(PathUtil::isValidFileName);
    }

    @Nullable
    public static String getUnicodeName(String forEncoding) {
        return IoTestUtil.filterParts(Charset.forName(forEncoding).newEncoder()::canEncode);
    }

    private static String filterParts(Predicate<? super String> predicate) {
        return StringUtil.nullize((String)Stream.of(UNICODE_PARTS).filter(predicate).collect(Collectors.joining("_")));
    }

    @NotNull
    public static File getTempDirectory() {
        File dir = new File(FileUtil.getTempDirectory());
        dir = IoTestUtil.expandWindowsPath(dir);
        return dir;
    }

    private static File expandWindowsPath(File file2) {
        if (SystemInfo.isWindows && file2.getPath().indexOf(126) > 0) {
            try {
                return file2.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return file2;
    }

    @NotNull
    public static File createSymLink(@NotNull String target, @NotNull String link) {
        return IoTestUtil.createSymLink(target, link, true);
    }

    @NotNull
    public static File createSymLink(@NotNull String target, @NotNull String link, boolean shouldExist) {
        File linkFile = IoTestUtil.getFullLinkPath(link);
        try {
            Files.createSymbolicLink(linkFile.toPath(), FileSystems.getDefault().getPath(target, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Assert.assertEquals((String)("target=" + target + ", link=" + linkFile), (Object)shouldExist, (Object)linkFile.exists());
        return linkFile;
    }

    public static void assumeSymLinkCreationIsSupported() throws AssumptionViolatedException {
        Assume.assumeTrue((String)("Can't create symlinks on " + SystemInfo.getOsNameAndVersion()), (boolean)isSymLinkCreationSupported);
    }

    public static void assumeWindows() throws AssumptionViolatedException {
        Assume.assumeTrue((String)("Need Windows, can't run on " + SystemInfo.OS_NAME), (boolean)SystemInfo.isWindows);
    }

    public static void assumeUnix() throws AssumptionViolatedException {
        Assume.assumeTrue((String)("Need Unix, can't run on " + SystemInfo.OS_NAME), (boolean)SystemInfo.isUnix);
    }

    @NotNull
    public static File createJunction(@NotNull String target, @NotNull String junction) {
        Assert.assertTrue((boolean)SystemInfo.isWindows);
        File targetFile = new File(target);
        Assert.assertTrue((String)targetFile.getPath(), (boolean)targetFile.isDirectory());
        File junctionFile = IoTestUtil.getFullLinkPath(junction);
        IoTestUtil.runCommand("cmd", "/C", "mklink", "/J", junctionFile.getPath(), targetFile.getPath());
        Assert.assertTrue((String)("target=" + targetFile + ", link=" + junctionFile), (boolean)junctionFile.isDirectory());
        return junctionFile;
    }

    public static void deleteJunction(@NotNull String junction) {
        Assert.assertTrue((boolean)SystemInfo.isWindows);
        Assert.assertTrue((boolean)new File(junction).delete());
    }

    @NotNull
    public static File createSubst(@NotNull String target) {
        Assert.assertTrue((boolean)SystemInfo.isWindows);
        File targetFile = new File(target);
        Assert.assertTrue((String)targetFile.getPath(), (boolean)targetFile.isDirectory());
        String substRoot = IoTestUtil.getFirstFreeDriveLetter() + ":";
        IoTestUtil.runCommand("subst", substRoot, targetFile.getPath());
        File rootFile = new File(substRoot + "\\");
        Assert.assertTrue((String)("target=" + targetFile + ", subst=" + rootFile), (boolean)rootFile.isDirectory());
        return rootFile;
    }

    public static void deleteSubst(@NotNull String substRoot) {
        IoTestUtil.runCommand("subst", StringUtil.trimEnd((String)substRoot, (String)"\\"), "/d");
    }

    private static char getFirstFreeDriveLetter() {
        Set roots = StreamSupport.stream(FileSystems.getDefault().getRootDirectories().spliterator(), false).map(root -> Character.valueOf(StringUtil.toUpperCase((String)root.toString()).charAt(0))).collect(Collectors.toSet());
        Logger.getInstance(IoTestUtil.class).debug("logical drives: " + roots);
        for (char c = 'E'; c <= 'Z'; c = (char)(c + '\u0001')) {
            if (roots.contains(Character.valueOf(c))) continue;
            return c;
        }
        throw new RuntimeException("No free roots");
    }

    private static File getFullLinkPath(String link) {
        File linkFile = new File(link);
        if (!linkFile.isAbsolute()) {
            linkFile = new File(IoTestUtil.getTempDirectory(), link);
        }
        Assert.assertTrue((String)link, (!linkFile.exists() || linkFile.delete() ? 1 : 0) != 0);
        File parentDir = linkFile.getParentFile();
        Assert.assertTrue((String)("link=" + link + ", parent=" + parentDir), (parentDir != null && (parentDir.isDirectory() || parentDir.mkdirs()) ? 1 : 0) != 0);
        return linkFile;
    }

    private static void runCommand(String ... command) {
        try {
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.redirectErrorStream(true);
            Process process = builder.start();
            StringBuilder output = new StringBuilder();
            Future<?> thread = ProcessIOExecutorService.INSTANCE.submit(() -> {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        output.append(line).append('\n');
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            int ret = process.waitFor();
            thread.get();
            if (ret != 0) {
                throw new RuntimeException(builder.command() + "\nresult: " + ret + "\noutput:\n" + output);
            }
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static void assertTimestampsEqual(long expected, long actual) {
        long roundedExpected = expected / 1000L * 1000L;
        long roundedActual = actual / 1000L * 1000L;
        Assert.assertEquals((String)("expected: " + expected + ", actual: " + actual), (long)roundedExpected, (long)roundedActual);
    }

    public static void assertTimestampsNotEqual(long expected, long actual) {
        long roundedExpected = expected / 1000L * 1000L;
        long roundedActual = actual / 1000L * 1000L;
        Assert.assertTrue((String)("(un)expected: " + expected + ", actual: " + actual), (roundedExpected != roundedActual ? 1 : 0) != 0);
    }

    @NotNull
    public static File createTestJar(@NotNull File jarFile) {
        return IoTestUtil.createTestJar(jarFile, "META-INF/MANIFEST.MF", "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static File createTestJar(@NotNull File jarFile, String ... namesAndTexts) {
        try (ZipOutputStream stream = new ZipOutputStream(new FileOutputStream(jarFile));){
            for (int i = 0; i < namesAndTexts.length; i += 2) {
                stream.putNextEntry(new ZipEntry(namesAndTexts[i]));
                if (namesAndTexts[i + 1] != null) {
                    stream.write(namesAndTexts[i + 1].getBytes(StandardCharsets.UTF_8));
                }
                stream.closeEntry();
            }
            File file2 = jarFile;
            return file2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static File createTestJar(@NotNull File jarFile, @NotNull Collection<? extends Pair<String, byte[]>> namesAndContents) {
        try (ZipOutputStream stream = new ZipOutputStream(new FileOutputStream(jarFile));){
            for (Pair<String, byte[]> pair : namesAndContents) {
                String name = (String)pair.first;
                byte[] content = (byte[])pair.second;
                stream.putNextEntry(new ZipEntry(name));
                stream.write(content);
                stream.closeEntry();
            }
            File file2 = jarFile;
            return file2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static File createTestJar(@NotNull File jarFile, @NotNull File root) {
        try (ZipOutputStream stream = new ZipOutputStream(new FileOutputStream(jarFile));){
            FileUtil.visitFiles((File)root, file2 -> {
                if (file2.isFile()) {
                    String path = FileUtil.toSystemIndependentName((String)Objects.requireNonNull(FileUtil.getRelativePath((File)root, (File)file2)));
                    try {
                        stream.putNextEntry(new ZipEntry(path));
                        try (FileInputStream is = new FileInputStream((File)file2);){
                            FileUtil.copy((InputStream)is, (OutputStream)stream);
                        }
                        stream.closeEntry();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return true;
            });
            File file3 = jarFile;
            return file3;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static File createTestDir(@NotNull String name) {
        return IoTestUtil.createTestDir(IoTestUtil.getTempDirectory(), name);
    }

    @NotNull
    public static File createTestDir(@NotNull File parent, @NotNull String name) {
        File dir = new File(parent, name);
        Assert.assertTrue((String)dir.getPath(), (boolean)dir.mkdirs());
        return dir;
    }

    @NotNull
    public static File createTestFile(@NotNull String name) {
        return IoTestUtil.createTestFile(name, null);
    }

    @NotNull
    public static File createTestFile(@NotNull String name, @Nullable String content) {
        return IoTestUtil.createTestFile(IoTestUtil.getTempDirectory(), name, content);
    }

    @NotNull
    public static File createTestFile(@NotNull File parent, @NotNull String name) {
        return IoTestUtil.createTestFile(parent, name, null);
    }

    @NotNull
    public static File createTestFile(@NotNull File parent, @NotNull String name, @Nullable String content) {
        try {
            Assert.assertTrue((String)parent.getPath(), (parent.isDirectory() || parent.mkdirs() ? 1 : 0) != 0);
            File file2 = new File(parent, name);
            Assert.assertTrue((String)file2.getPath(), (boolean)file2.createNewFile());
            if (content != null) {
                FileUtil.writeToFile((File)file2, (String)content);
            }
            return file2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void delete(File ... files) {
        for (File file2 : files) {
            if (file2 == null) continue;
            FileUtil.delete((File)file2);
        }
    }

    public static void updateFile(@NotNull File file2, String content) {
        try {
            FileUtil.writeToFile((File)file2, (String)content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean canCreateSymlinks() {
        try {
            Path target = Files.createTempFile("IOTestUtil_link_target.", ".txt", new FileAttribute[0]);
            try {
                boolean bl;
                Path link = target.getParent().resolve("IOTestUtil_link");
                try {
                    Files.createSymbolicLink(link, target.getFileName(), new FileAttribute[0]);
                    bl = true;
                }
                catch (Throwable throwable) {
                    Files.deleteIfExists(link);
                    throw throwable;
                }
                Files.deleteIfExists(link);
                return bl;
            }
            finally {
                Files.delete(target);
            }
        }
        catch (IOException ignored) {
            return false;
        }
    }

    @NotNull
    public static String toLocalUncPath(@NotNull String localPath) {
        return "\\\\127.0.0.1\\" + localPath.charAt(0) + '$' + localPath.substring(2);
    }
}

