/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.tools.projectWizard.wizard.service;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.tools.projectWizard.Versions;
import org.jetbrains.kotlin.tools.projectWizard.core.service.KotlinVersionProviderService;
import org.jetbrains.kotlin.tools.projectWizard.core.service.WizardKotlinVersion;
import org.jetbrains.kotlin.tools.projectWizard.plugins.kotlin.ProjectKind;
import org.jetbrains.kotlin.tools.projectWizard.settings.version.Version;
import org.jetbrains.kotlin.tools.projectWizard.wizard.service.IdeaWizardService;
import org.jetbrains.kotlin.tools.projectWizard.wizard.service.VersionsDownloader;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u00012\u00020\u0002:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\n\u0010\n\u001a\u0004\u0018\u00010\tH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/wizard/service/IdeaKotlinVersionProviderService;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/service/KotlinVersionProviderService;", "Lorg/jetbrains/kotlin/tools/projectWizard/wizard/service/IdeaWizardService;", "()V", "getKotlinVersion", "Lorg/jetbrains/kotlin/tools/projectWizard/core/service/WizardKotlinVersion;", "projectKind", "Lorg/jetbrains/kotlin/tools/projectWizard/plugins/kotlin/ProjectKind;", "getKotlinVersionFromCompiler", "Lorg/jetbrains/kotlin/tools/projectWizard/settings/version/Version;", "getPatchedKotlinVersion", "Companion", "kotlin.project-wizard.idea"})
public final class IdeaKotlinVersionProviderService
extends KotlinVersionProviderService
implements IdeaWizardService {
    private static final String KOTLIN_COMPILER_VERSION_TAG = "kotlin.compiler.version";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public WizardKotlinVersion getKotlinVersion(@NotNull ProjectKind projectKind) {
        Version version;
        Version version2;
        Intrinsics.checkNotNullParameter((Object)projectKind, (String)"projectKind");
        if (projectKind == ProjectKind.COMPOSE) {
            return this.kotlinVersionWithDefaultValues(Versions.INSTANCE.getKOTLIN_VERSION_FOR_COMPOSE());
        }
        Version version3 = this.getPatchedKotlinVersion();
        if (version3 == null) {
            version3 = version2 = this.getKotlinVersionFromCompiler();
        }
        if (version3 == null) {
            version2 = version = VersionsDownloader.INSTANCE.downloadLatestEapOrStableKotlinVersion();
        }
        if (version2 == null) {
            version = Versions.INSTANCE.getKOTLIN();
        }
        Version version4 = version;
        return this.kotlinVersionWithDefaultValues(version4);
    }

    private final Version getPatchedKotlinVersion() {
        Version version;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isInternal()) {
            String string = System.getProperty(KOTLIN_COMPILER_VERSION_TAG);
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                version = Version.Companion.fromString(it);
            } else {
                version = null;
            }
        } else {
            version = null;
        }
        return version;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Version getKotlinVersionFromCompiler() {
        String string = KotlinCompilerVersion.getVersion();
        String string2 = string;
        if (string == null) return null;
        String string3 = string2;
        boolean bl = false;
        boolean bl2 = false;
        String it = string3;
        boolean bl3 = false;
        String string4 = it;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it");
        if (StringsKt.contains((CharSequence)string4, (CharSequence)"snapshot", (boolean)true)) return null;
        String string5 = string3;
        string2 = string5;
        if (string5 == null) return null;
        string3 = string2;
        bl = false;
        bl2 = false;
        it = string3;
        boolean bl4 = false;
        String string6 = it;
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"it");
        Version version = Version.Companion.fromString(StringsKt.substringBefore$default((String)string6, (String)"-release", null, (int)2, null));
        return version;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/wizard/service/IdeaKotlinVersionProviderService$Companion;", "", "()V", "KOTLIN_COMPILER_VERSION_TAG", "", "kotlin.project-wizard.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

