/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.widget;

import com.intellij.json.JsonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.widget.StatusBarEditorBasedWidgetFactory;
import com.jetbrains.jsonSchema.widget.JsonSchemaStatusWidget;
import org.jetbrains.annotations.NotNull;

public class JsonSchemaStatusWidgetFactory
extends StatusBarEditorBasedWidgetFactory {
    @NotNull
    public String getId() {
        return "JSONSchemaSelector";
    }

    @NotNull
    public String getDisplayName() {
        return JsonBundle.message("schema.widget.display.name", new Object[0]);
    }

    public boolean canBeEnabledOn(@NotNull StatusBar statusBar) {
        Project project = statusBar.getProject();
        if (project == null) {
            return false;
        }
        FileEditor editor = this.getFileEditor(statusBar);
        return JsonSchemaStatusWidget.isAvailableOnFile(project, editor != null ? editor.getFile() : null);
    }

    @NotNull
    public StatusBarWidget createWidget(@NotNull Project project) {
        return new JsonSchemaStatusWidget(project);
    }

    public void disposeWidget(@NotNull StatusBarWidget widget) {
        Disposer.dispose((Disposable)widget);
    }
}

