/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.widget;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.icons.AllIcons;
import com.intellij.json.JsonBundle;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.FileDownloadingAdapter;
import com.intellij.openapi.vfs.impl.http.FileDownloadingListener;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfo;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedStatusBarPopup;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.jetbrains.jsonSchema.JsonSchemaCatalogProjectConfiguration;
import com.jetbrains.jsonSchema.extension.JsonSchemaEnabler;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaInfo;
import com.jetbrains.jsonSchema.extension.JsonWidgetSuppressor;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaServiceImpl;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import com.jetbrains.jsonSchema.widget.JsonSchemaStatusPopup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JsonSchemaStatusWidget
extends EditorBasedStatusBarPopup {
    public static final String ID = "JSONSchemaSelector";
    private final SynchronizedClearableLazy<JsonSchemaService> myServiceLazy;
    private static final AtomicBoolean myIsNotified = new AtomicBoolean(false);
    private final Runnable myUpdateCallback = () -> {
        this.update();
        myIsNotified.set(false);
    };

    JsonSchemaStatusWidget(Project project) {
        super(project, false);
        this.myServiceLazy = new SynchronizedClearableLazy(() -> {
            if (!project.isDisposed()) {
                JsonSchemaService myService = JsonSchemaService.Impl.get(project);
                myService.registerRemoteUpdateCallback(this.myUpdateCallback);
                myService.registerResetAction(this.myUpdateCallback);
                return myService;
            }
            return null;
        });
        JsonWidgetSuppressor.EXTENSION_POINT_NAME.addChangeListener(() -> ((JsonSchemaStatusWidget)this).update(), (Disposable)project);
    }

    @Nullable
    private JsonSchemaService getService() {
        return (JsonSchemaService)this.myServiceLazy.getValue();
    }

    private boolean hasAccessToSymbols() {
        return !DumbService.getInstance((Project)this.myProject).isDumb();
    }

    @Contract(value="_, null -> false")
    public static boolean isAvailableOnFile(@NotNull Project project, @Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        List enablers = JsonSchemaEnabler.EXTENSION_POINT_NAME.getExtensionList();
        if (enablers.stream().noneMatch(e -> e.isEnabledForFile(file, project) && e.shouldShowSwitcherWidget(file))) {
            return false;
        }
        if (DumbService.getInstance((Project)project).isDumb()) {
            return true;
        }
        List suppressors = JsonWidgetSuppressor.EXTENSION_POINT_NAME.getExtensionList();
        return !suppressors.stream().anyMatch(s -> s.suppressSwitcherWidget(file, project));
    }

    @NotNull
    protected EditorBasedStatusBarPopup.WidgetState getWidgetState(@Nullable VirtualFile file) {
        String bar;
        if (!JsonSchemaStatusWidget.isAvailableOnFile(this.myProject, file)) {
            return EditorBasedStatusBarPopup.WidgetState.HIDDEN;
        }
        FileType fileType = file.getFileType();
        Language language = fileType instanceof LanguageFileType ? ((LanguageFileType)fileType).getLanguage() : null;
        boolean isJsonFile = language instanceof JsonLanguage;
        if (!this.hasAccessToSymbols()) {
            return EditorBasedStatusBarPopup.WidgetState.getDumbModeState((String)JsonBundle.message("schema.widget.service", new Object[0]), (String)(isJsonFile ? JsonBundle.message("schema.widget.prefix.json.files", new Object[0]) : JsonBundle.message("schema.widget.prefix.other.files", new Object[0])));
        }
        JsonSchemaService service = this.getService();
        if (service == null) {
            return JsonSchemaStatusWidget.getNoSchemaState();
        }
        Collection<VirtualFile> schemaFiles = service.getSchemaFilesForFile(file);
        if (schemaFiles.size() == 0) {
            return JsonSchemaStatusWidget.getNoSchemaState();
        }
        if (schemaFiles.size() != 1) {
            ArrayList<VirtualFile> userSchemas = new ArrayList<VirtualFile>();
            if (JsonSchemaStatusWidget.hasConflicts(userSchemas, service, file)) {
                MyWidgetState state = new MyWidgetState(JsonSchemaStatusWidget.createMessage(schemaFiles, service, "<br/>", JsonBundle.message("schema.widget.conflict.message.prefix", new Object[0]), ""), schemaFiles.size() + " " + JsonBundle.message("schema.widget.conflict.message.postfix", new Object[0]), true);
                state.setWarning(true);
                state.setConflict();
                return state;
            }
            schemaFiles = userSchemas;
            if (schemaFiles.size() == 0) {
                return JsonSchemaStatusWidget.getNoSchemaState();
            }
        }
        VirtualFile schemaFile = schemaFiles.iterator().next();
        schemaFile = ((JsonSchemaServiceImpl)service).replaceHttpFileWithBuiltinIfNeeded(schemaFile);
        String tooltip = isJsonFile ? JsonBundle.message("schema.widget.tooltip.json.files", new Object[0]) : JsonBundle.message("schema.widget.tooltip.other.files", new Object[0]);
        String string = bar = isJsonFile ? JsonBundle.message("schema.widget.prefix.json.files", new Object[0]) : JsonBundle.message("schema.widget.prefix.other.files", new Object[0]);
        if (schemaFile instanceof HttpVirtualFile) {
            RemoteFileInfo info = ((HttpVirtualFile)schemaFile).getFileInfo();
            if (info == null) {
                return JsonSchemaStatusWidget.getDownloadErrorState(null);
            }
            switch (info.getState()) {
                case DOWNLOADING_NOT_STARTED: {
                    this.addDownloadingUpdateListener(info);
                    return new MyWidgetState(tooltip + JsonSchemaStatusWidget.getSchemaFileDesc(schemaFile), bar + JsonSchemaStatusWidget.getPresentableNameForFile(schemaFile), true);
                }
                case DOWNLOADING_IN_PROGRESS: {
                    this.addDownloadingUpdateListener(info);
                    return new MyWidgetState(JsonBundle.message("schema.widget.download.in.progress.tooltip", new Object[0]), JsonBundle.message("schema.widget.download.in.progress.label", new Object[0]), false);
                }
                case ERROR_OCCURRED: {
                    return JsonSchemaStatusWidget.getDownloadErrorState(info.getErrorMessage());
                }
            }
        }
        if (!this.isValidSchemaFile(schemaFile)) {
            MyWidgetState state = new MyWidgetState(JsonBundle.message("schema.widget.error.not.a.schema", new Object[0]), JsonBundle.message("schema.widget.error.label", new Object[0]), true);
            state.setWarning(true);
            return state;
        }
        JsonSchemaFileProvider provider = service.getSchemaProvider(schemaFile);
        if (provider != null) {
            boolean preferRemoteSchemas = JsonSchemaCatalogProjectConfiguration.getInstance(this.myProject).isPreferRemoteSchemas();
            String remoteSource = provider.getRemoteSource();
            boolean useRemoteSource = preferRemoteSchemas && remoteSource != null && !JsonFileResolver.isSchemaUrl(remoteSource) && !remoteSource.endsWith("!");
            String providerName = useRemoteSource ? remoteSource : provider.getPresentableName();
            String shortName = StringUtil.trimEnd((String)StringUtil.trimEnd((String)providerName, (String)".json"), (String)"-schema");
            String name = useRemoteSource ? bar + new JsonSchemaInfo(remoteSource).getDescription() : (shortName.contains(JsonBundle.message("schema.of.version", "")) ? shortName : bar + shortName);
            String kind = !useRemoteSource && (provider.getSchemaType() == SchemaType.embeddedSchema || provider.getSchemaType() == SchemaType.schema) ? JsonBundle.message("schema.widget.bundled.postfix", new Object[0]) : "";
            return new MyWidgetState(tooltip + providerName + kind, name, true);
        }
        return new MyWidgetState(tooltip + JsonSchemaStatusWidget.getSchemaFileDesc(schemaFile), bar + JsonSchemaStatusWidget.getPresentableNameForFile(schemaFile), true);
    }

    private void addDownloadingUpdateListener(@NotNull RemoteFileInfo info) {
        info.addDownloadingListener((FileDownloadingListener)new FileDownloadingAdapter(){

            public void fileDownloaded(@NotNull VirtualFile localFile) {
                JsonSchemaStatusWidget.this.update();
            }

            public void errorOccurred(@NotNull String errorMessage) {
                JsonSchemaStatusWidget.this.update();
            }

            public void downloadingCancelled() {
                JsonSchemaStatusWidget.this.update();
            }
        });
    }

    private boolean isValidSchemaFile(@Nullable VirtualFile schemaFile) {
        if (schemaFile == null) {
            return false;
        }
        JsonSchemaService service = this.getService();
        return service != null && service.isSchemaFile(schemaFile) && service.isApplicableToFile(schemaFile);
    }

    @Nullable
    private static String extractNpmPackageName(@Nullable String path) {
        int trimIndex;
        if (path == null) {
            return null;
        }
        int idx = path.indexOf("node_modules");
        if (idx != -1 && (trimIndex = idx + "node_modules".length() + 1) < path.length()) {
            idx = StringUtil.indexOfAny((String)(path = path.substring(trimIndex)), (String)"\\/");
            if (idx != -1 && path.startsWith("@")) {
                idx = StringUtil.indexOfAny((String)path, (String)"\\/", (int)(idx + 1), (int)path.length());
            }
            if (idx != -1) {
                return path.substring(0, idx);
            }
        }
        return null;
    }

    @NotNull
    private static String getPresentableNameForFile(@NotNull VirtualFile schemaFile) {
        if (schemaFile instanceof HttpVirtualFile) {
            return new JsonSchemaInfo(schemaFile.getUrl()).getDescription();
        }
        String nameWithoutExtension = schemaFile.getNameWithoutExtension();
        if (!JsonSchemaInfo.isVeryDumbName(nameWithoutExtension)) {
            return nameWithoutExtension;
        }
        String path = schemaFile.getPath();
        String npmPackageName = JsonSchemaStatusWidget.extractNpmPackageName(path);
        return npmPackageName != null ? npmPackageName : schemaFile.getName();
    }

    @NotNull
    private static EditorBasedStatusBarPopup.WidgetState getDownloadErrorState(@Nullable String message) {
        MyWidgetState state = new MyWidgetState(JsonBundle.message("schema.widget.error.cant.download", new Object[0]) + (message == null ? "" : ": <br/>" + message), JsonBundle.message("schema.widget.error.label", new Object[0]), true);
        state.setWarning(true);
        return state;
    }

    @NotNull
    private static EditorBasedStatusBarPopup.WidgetState getNoSchemaState() {
        return new MyWidgetState(JsonBundle.message("schema.widget.no.schema.tooltip", new Object[0]), JsonBundle.message("schema.widget.no.schema.label", new Object[0]), true);
    }

    @NotNull
    private static String getSchemaFileDesc(@NotNull VirtualFile schemaFile) {
        if (schemaFile instanceof HttpVirtualFile) {
            return schemaFile.getPresentableUrl();
        }
        String npmPackageName = JsonSchemaStatusWidget.extractNpmPackageName(schemaFile.getPath());
        return schemaFile.getName() + (npmPackageName == null ? "" : " " + JsonBundle.message("schema.widget.package.postfix", npmPackageName));
    }

    @Nullable
    protected ListPopup createPopup(DataContext context) {
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context);
        if (virtualFile == null) {
            return null;
        }
        Project project = this.getProject();
        EditorBasedStatusBarPopup.WidgetState state = this.getWidgetState(virtualFile);
        if (!(state instanceof MyWidgetState)) {
            return null;
        }
        JsonSchemaService service = this.getService();
        if (service == null) {
            return null;
        }
        return JsonSchemaStatusPopup.createPopup(service, project, virtualFile, ((MyWidgetState)state).isWarning());
    }

    protected void registerCustomListeners() {
        class Listener
        implements DumbService.DumbModeListener {
            volatile boolean isDumbMode;

            Listener() {
            }

            public void enteredDumbMode() {
                this.isDumbMode = true;
                JsonSchemaStatusWidget.this.update();
            }

            public void exitDumbMode() {
                this.isDumbMode = false;
                JsonSchemaStatusWidget.this.update();
            }
        }
        Listener listener = new Listener();
        this.myConnection.subscribe(DumbService.DUMB_MODE, (Object)listener);
    }

    protected void handleFileChange(VirtualFile file) {
        myIsNotified.set(false);
    }

    @NotNull
    protected StatusBarWidget createInstance(@NotNull Project project) {
        return new JsonSchemaStatusWidget(project);
    }

    @NotNull
    public String ID() {
        return ID;
    }

    public void dispose() {
        JsonSchemaService service;
        JsonSchemaService jsonSchemaService = service = this.myServiceLazy.isInitialized() ? (JsonSchemaService)this.myServiceLazy.getValue() : null;
        if (service != null) {
            service.unregisterRemoteUpdateCallback(this.myUpdateCallback);
            service.unregisterResetAction(this.myUpdateCallback);
        }
        super.dispose();
    }

    private static String createMessage(@NotNull Collection<? extends VirtualFile> schemaFiles, @NotNull JsonSchemaService jsonSchemaService, @NotNull String separator, @NotNull String prefix, @NotNull String suffix) {
        List pairList = schemaFiles.stream().map(file -> jsonSchemaService.getSchemaProvider((VirtualFile)file)).filter(Objects::nonNull).map(provider -> Pair.create((Object)SchemaType.userSchema.equals((Object)provider.getSchemaType()), (Object)provider.getName())).collect(Collectors.toList());
        long numOfSystemSchemas = pairList.stream().filter(pair -> (Boolean)pair.getFirst() == false).count();
        if (pairList.size() == 2 && numOfSystemSchemas == 1L) {
            return null;
        }
        boolean withTypes = numOfSystemSchemas > 0L;
        return pairList.stream().map(pair -> JsonSchemaStatusWidget.formatName(withTypes, (Pair<Boolean, String>)pair)).collect(Collectors.joining(separator, prefix, suffix));
    }

    private static String formatName(boolean withTypes, Pair<Boolean, String> pair) {
        return "&nbsp;&nbsp;- " + (withTypes ? String.format("%s schema '%s'", Boolean.TRUE.equals(pair.getFirst()) ? "user" : "system", pair.getSecond()) : (String)pair.getSecond());
    }

    private static boolean hasConflicts(@NotNull Collection<VirtualFile> files, @NotNull JsonSchemaService service, @NotNull VirtualFile file) {
        List<JsonSchemaFileProvider> providers = ((JsonSchemaServiceImpl)service).getProvidersForFile(file);
        for (JsonSchemaFileProvider provider : providers) {
            VirtualFile schemaFile;
            if (provider.getSchemaType() != SchemaType.userSchema || (schemaFile = provider.getSchemaFile()) == null) continue;
            files.add(schemaFile);
        }
        return files.size() > 1;
    }

    protected void afterVisibleUpdate(@NotNull EditorBasedStatusBarPopup.WidgetState state) {
        if (!(state instanceof MyWidgetState) || !((MyWidgetState)state).conflict) {
            myIsNotified.set(false);
            return;
        }
        if (myIsNotified.get()) {
            return;
        }
        myIsNotified.set(true);
        Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        alarm.addRequest(() -> {
            JComponent label = HintUtil.createErrorLabel((String)("<b>" + JsonBundle.message("schema.widget.conflict.popup.title", new Object[0]) + "</b><br/><br/>" + ((MyWidgetState)state).getTooltip()));
            BalloonBuilder builder = JBPopupFactory.getInstance().createBalloonBuilder(label);
            JComponent statusBarComponent = this.getComponent();
            Balloon balloon = builder.setCalloutShift(statusBarComponent.getHeight() / 2).setDisposable((Disposable)this).setFillColor(HintUtil.getErrorColor()).setHideOnClickOutside(true).createBalloon();
            balloon.showInCenterOf(statusBarComponent);
        }, 500, ModalityState.NON_MODAL);
    }

    private static class MyWidgetState
    extends EditorBasedStatusBarPopup.WidgetState {
        boolean warning = false;
        boolean conflict = false;

        MyWidgetState(String toolTip, String text, boolean actionEnabled) {
            super(toolTip, text, actionEnabled);
        }

        public boolean isWarning() {
            return this.warning;
        }

        public void setWarning(boolean warning) {
            this.warning = warning;
            this.setIcon(warning ? AllIcons.General.Warning : null);
        }

        private void setConflict() {
            this.conflict = true;
        }

        private String getTooltip() {
            return this.toolTip;
        }
    }
}

