/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.settings.mappings;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.json.JsonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.table.TableView;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.jsonSchema.JsonMappingKind;
import com.jetbrains.jsonSchema.UserDefinedJsonSchemaConfiguration;
import com.jetbrains.jsonSchema.extension.JsonSchemaInfo;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import com.jetbrains.jsonSchema.settings.mappings.JsonMappingsTableCellEditor;
import com.jetbrains.jsonSchema.settings.mappings.JsonMappingsTableView;
import com.jetbrains.jsonSchema.settings.mappings.TreeUpdater;
import com.jetbrains.jsonSchema.widget.JsonSchemaInfoPopupStep;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaMappingsView
implements Disposable {
    private static final String ADD_SCHEMA_MAPPING = "settings.json.schema.add.mapping";
    private static final String EDIT_SCHEMA_MAPPING = "settings.json.schema.edit.mapping";
    private static final String REMOVE_SCHEMA_MAPPING = "settings.json.schema.remove.mapping";
    private final TreeUpdater myTreeUpdater;
    private final BiConsumer<? super String, ? super Boolean> mySchemaPathChangedCallback;
    private TableView<UserDefinedJsonSchemaConfiguration.Item> myTableView;
    private JComponent myComponent;
    private Project myProject;
    private TextFieldWithBrowseButton mySchemaField;
    private ComboBox<JsonSchemaVersion> mySchemaVersionComboBox;
    private JEditorPane myError;
    private String myErrorText;
    private JBLabel myErrorIcon;
    private boolean myInitialized;

    public JsonSchemaMappingsView(Project project, TreeUpdater treeUpdater, BiConsumer<? super String, ? super Boolean> schemaPathChangedCallback) {
        this.myTreeUpdater = treeUpdater;
        this.mySchemaPathChangedCallback = schemaPathChangedCallback;
        this.createUI(project);
    }

    private void createUI(Project project) {
        this.myProject = project;
        MyAddActionButtonRunnable addActionButtonRunnable = new MyAddActionButtonRunnable();
        this.myTableView = new JsonMappingsTableView(addActionButtonRunnable);
        this.myTableView.getTableHeader().setVisible(false);
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myTableView);
        MyEditActionButtonRunnableImpl editAction = new MyEditActionButtonRunnableImpl();
        decorator.setRemoveAction((AnActionButtonRunnable)new MyRemoveActionButtonRunnable()).setRemoveActionName(REMOVE_SCHEMA_MAPPING).setAddAction((AnActionButtonRunnable)addActionButtonRunnable).setAddActionName(JsonBundle.message(ADD_SCHEMA_MAPPING, new Object[0])).setEditAction((AnActionButtonRunnable)editAction).setEditActionName(JsonBundle.message(EDIT_SCHEMA_MAPPING, new Object[0])).disableUpDownActions();
        JBTextField schemaFieldBacking = new JBTextField();
        this.mySchemaField = new TextFieldWithBrowseButton((JTextField)schemaFieldBacking);
        this.mySchemaField.setButtonIcon(AllIcons.General.OpenDiskHover);
        FixedSizeButton urlButton = new FixedSizeButton();
        urlButton.setIcon(AllIcons.General.Web);
        urlButton.addActionListener(a -> {
            JsonSchemaService service = JsonSchemaService.Impl.get(this.myProject);
            List<JsonSchemaInfo> schemas = service.getAllUserVisibleSchemas();
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new JsonSchemaInfoPopupStep(schemas, this.myProject, null, service, JsonBundle.message("schema.configuration.mapping.remote", new Object[0])){

                @Override
                protected void setMapping(@Nullable JsonSchemaInfo selectedValue, @Nullable VirtualFile virtualFile, @NotNull Project project) {
                    if (selectedValue != null) {
                        JsonSchemaMappingsView.this.mySchemaField.setText(selectedValue.getUrl(JsonSchemaMappingsView.this.myProject));
                        JsonSchemaMappingsView.this.mySchemaPathChangedCallback.accept(selectedValue.getDescription(), true);
                    }
                }
            }).showInCenterOf((Component)urlButton);
        });
        SwingHelper.installFileCompletionAndBrowseDialog((Project)this.myProject, (TextFieldWithBrowseButton)this.mySchemaField, (String)JsonBundle.message("json.schema.add.schema.chooser.title", new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileDescriptor());
        this.mySchemaField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                JsonSchemaMappingsView.this.mySchemaPathChangedCallback.accept(JsonSchemaMappingsView.this.mySchemaField.getText(), false);
            }
        });
        this.attachNavigateToSchema();
        this.myError = SwingHelper.createHtmlLabel((String)JsonBundle.message("json.schema.conflicting.mappings", new Object[0]), null, s -> {
            BalloonBuilder builder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(this.myErrorText, UIUtil.getBalloonWarningIcon(), MessageType.WARNING.getPopupBackground(), null);
            builder.setDisposable((Disposable)this);
            builder.setHideOnClickOutside(true);
            builder.setCloseButtonEnabled(true);
            builder.createBalloon().showInCenterOf((JComponent)this.myError);
        });
        JPanel schemaSelector = new JPanel(new BorderLayout());
        schemaSelector.add((Component)this.mySchemaField, "Center");
        schemaSelector.add((Component)urlButton, "East");
        FormBuilder builder = FormBuilder.createFormBuilder();
        JBLabel label = new JBLabel(JsonBundle.message("json.schema.file.selector.title", new Object[0]));
        builder.addLabeledComponent((JComponent)label, (JComponent)schemaSelector);
        label.setLabelFor((Component)schemaSelector);
        label.setBorder((Border)JBUI.Borders.empty((int)0, (int)10));
        schemaSelector.setBorder((Border)JBUI.Borders.emptyRight((int)10));
        JBLabel versionLabel = new JBLabel(JsonBundle.message("json.schema.version.selector.title", new Object[0]));
        this.mySchemaVersionComboBox = new ComboBox(new DefaultComboBoxModel<JsonSchemaVersion>(JsonSchemaVersion.values()));
        versionLabel.setLabelFor(this.mySchemaVersionComboBox);
        versionLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)10));
        builder.addLabeledComponent((JComponent)versionLabel, this.mySchemaVersionComboBox);
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.setBorder((Border)JBUI.Borders.empty((int)0, (int)10));
        this.myErrorIcon = new JBLabel(UIUtil.getBalloonWarningIcon());
        wrapper.add((Component)this.myErrorIcon, "West");
        wrapper.add((Component)this.myError, "Center");
        builder.addComponent((JComponent)wrapper);
        JPanel panel = decorator.createPanel();
        panel.setBorder(BorderFactory.createCompoundBorder((Border)JBUI.Borders.empty((int)0, (int)8), panel.getBorder()));
        builder.addComponentFillVertically((JComponent)panel, 5);
        JLabel commentComponent = ComponentPanelBuilder.createCommentComponent((String)JsonBundle.message("path.to.file.or.directory.relative.to.project.root.or.file.name", new Object[0]), (boolean)false);
        commentComponent.setBorder((Border)JBUI.Borders.empty((int)0, (int)8, (int)5, (int)0));
        builder.addComponent((JComponent)commentComponent);
        this.myComponent = builder.getPanel();
    }

    public void dispose() {
    }

    public void setError(String text, boolean showWarning) {
        this.myErrorText = text;
        this.myError.setVisible(showWarning && text != null);
        this.myErrorIcon.setVisible(showWarning && text != null);
    }

    private void attachNavigateToSchema() {
        DumbAwareAction.create(e -> {
            String pathToSchema = this.mySchemaField.getText();
            if (StringUtil.isEmptyOrSpaces((String)pathToSchema) || JsonFileResolver.isHttpPath(pathToSchema)) {
                return;
            }
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(pathToSchema));
            if (virtualFile == null) {
                BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(JsonBundle.message("json.schema.file.not.found", new Object[0]), UIUtil.getBalloonErrorIcon(), MessageType.ERROR.getPopupBackground(), null);
                Balloon balloon = balloonBuilder.setFadeoutTime(TimeUnit.SECONDS.toMillis(3L)).createBalloon();
                balloon.showInCenterOf((JComponent)this.mySchemaField);
                return;
            }
            PsiNavigationSupport.getInstance().createNavigatable(this.myProject, virtualFile, -1).navigate(true);
        }).registerCustomShortcutSet(CommonShortcuts.getEditSource(), (JComponent)this.mySchemaField);
    }

    public List<UserDefinedJsonSchemaConfiguration.Item> getData() {
        return Collections.unmodifiableList(ContainerUtil.filter((Collection)this.myTableView.getListTableModel().getItems(), i -> i.mappingKind == JsonMappingKind.Directory || !StringUtil.isEmpty((String)i.path)));
    }

    public void setItems(String schemaFilePath, JsonSchemaVersion version, List<UserDefinedJsonSchemaConfiguration.Item> data) {
        this.myInitialized = true;
        this.mySchemaField.setText(schemaFilePath);
        this.mySchemaVersionComboBox.setSelectedItem((Object)version);
        this.myTableView.setModelAndUpdateColumns(new ListTableModel(this.createColumns(), new ArrayList<UserDefinedJsonSchemaConfiguration.Item>(data)));
    }

    public boolean isInitialized() {
        return this.myInitialized;
    }

    public JsonSchemaVersion getSchemaVersion() {
        return (JsonSchemaVersion)((Object)this.mySchemaVersionComboBox.getSelectedItem());
    }

    public String getSchemaSubPath() {
        String schemaFieldText = this.mySchemaField.getText();
        if (JsonFileResolver.isAbsoluteUrl(schemaFieldText)) {
            return schemaFieldText;
        }
        return FileUtil.toSystemDependentName((String)JsonSchemaInfo.getRelativePath(this.myProject, schemaFieldText));
    }

    private ColumnInfo[] createColumns() {
        return new ColumnInfo[]{new MappingItemColumnInfo()};
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    private class MyRemoveActionButtonRunnable
    implements AnActionButtonRunnable {
        private MyRemoveActionButtonRunnable() {
        }

        public void run(AnActionButton button) {
            int[] rows = JsonSchemaMappingsView.this.myTableView.getSelectedRows();
            if (rows != null && rows.length > 0) {
                int cnt = 0;
                for (int row : rows) {
                    JsonSchemaMappingsView.this.myTableView.getListTableModel().removeRow(row - cnt);
                    ++cnt;
                }
                JsonSchemaMappingsView.this.myTableView.getListTableModel().fireTableDataChanged();
                JsonSchemaMappingsView.this.myTreeUpdater.updateTree(true);
            }
        }
    }

    private class MyEditActionButtonRunnableImpl
    implements AnActionButtonRunnable {
        MyEditActionButtonRunnableImpl() {
        }

        public void run(AnActionButton button) {
            this.execute();
        }

        public void execute() {
            int selectedRow = JsonSchemaMappingsView.this.myTableView.getSelectedRow();
            if (selectedRow == -1) {
                return;
            }
            JsonSchemaMappingsView.this.myTableView.editCellAt(selectedRow, 0);
        }
    }

    class MyAddActionButtonRunnable
    implements AnActionButtonRunnable {
        MyAddActionButtonRunnable() {
        }

        public void run(AnActionButton button) {
            RelativePoint point = button.getPreferredPopupPoint();
            if (point == null) {
                point = new RelativePoint((Component)button.getContextComponent(), new Point(0, 0));
            }
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<JsonMappingKind>(null, JsonMappingKind.values()){

                @NotNull
                public String getTextFor(JsonMappingKind value) {
                    return "Add " + StringUtil.capitalizeWords((String)value.getDescription(), (boolean)true);
                }

                public Icon getIconFor(JsonMappingKind value) {
                    return value.getIcon();
                }

                public PopupStep onChosen(JsonMappingKind selectedValue, boolean finalChoice) {
                    if (finalChoice) {
                        return this.doFinalStep(() -> MyAddActionButtonRunnable.this.doRun(selectedValue));
                    }
                    return PopupStep.FINAL_CHOICE;
                }
            }).show(point);
        }

        void doRun(JsonMappingKind mappingKind) {
            UserDefinedJsonSchemaConfiguration.Item currentItem = new UserDefinedJsonSchemaConfiguration.Item("", mappingKind);
            JsonSchemaMappingsView.this.myTableView.getListTableModel().addRow((Object)currentItem);
            JsonSchemaMappingsView.this.myTableView.editCellAt(JsonSchemaMappingsView.this.myTableView.getListTableModel().getRowCount() - 1, 0);
            JsonSchemaMappingsView.this.myTreeUpdater.updateTree(false);
        }
    }

    private class MappingItemColumnInfo
    extends ColumnInfo<UserDefinedJsonSchemaConfiguration.Item, String> {
        MappingItemColumnInfo() {
            super("");
        }

        @Nullable
        public String valueOf(UserDefinedJsonSchemaConfiguration.Item item) {
            return item.getPresentation();
        }

        @NotNull
        public TableCellRenderer getRenderer(final UserDefinedJsonSchemaConfiguration.Item item) {
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    label.setIcon(item.mappingKind.getIcon());
                    String error = item.getError();
                    if (error == null) {
                        return label;
                    }
                    JPanel panel = new JPanel();
                    panel.setLayout(new BorderLayout());
                    panel.add((Component)label, "Center");
                    JLabel warning = new JLabel(AllIcons.General.Warning);
                    panel.setBackground(label.getBackground());
                    panel.setToolTipText(error);
                    panel.add((Component)warning, "After");
                    return panel;
                }
            };
        }

        @Nullable
        public TableCellEditor getEditor(UserDefinedJsonSchemaConfiguration.Item item) {
            return new JsonMappingsTableCellEditor(item, JsonSchemaMappingsView.this.myProject, JsonSchemaMappingsView.this.myTreeUpdater);
        }

        public boolean isCellEditable(UserDefinedJsonSchemaConfiguration.Item item) {
            return true;
        }
    }
}

