/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.validations;

import com.intellij.json.JsonBundle;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.jsonSchema.extension.JsonErrorPriority;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.JsonSchemaValidation;
import com.jetbrains.jsonSchema.extension.JsonValidationHost;
import com.jetbrains.jsonSchema.extension.adapters.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ArrayValidation
implements JsonSchemaValidation {
    public static final ArrayValidation INSTANCE = new ArrayValidation();

    @Override
    public void validate(JsonValueAdapter propValue, JsonSchemaObject schema, JsonSchemaType schemaType, JsonValidationHost consumer, JsonComplianceCheckerOptions options) {
        ArrayValidation.checkArray(propValue, schema, consumer, options);
    }

    private static void checkArray(JsonValueAdapter value, JsonSchemaObject schema, JsonValidationHost consumer, JsonComplianceCheckerOptions options) {
        JsonArrayValueAdapter asArray = value.getAsArray();
        if (asArray == null) {
            return;
        }
        List<JsonValueAdapter> elements = asArray.getElements();
        ArrayValidation.checkArrayItems(value, elements, schema, consumer, options);
    }

    private static void checkArrayItems(@NotNull JsonValueAdapter array, @NotNull List<JsonValueAdapter> list, JsonSchemaObject schema, JsonValidationHost consumer, JsonComplianceCheckerOptions options) {
        if (schema.isUniqueItems()) {
            MultiMap valueTexts = new MultiMap();
            JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker(array.getDelegate(), schema);
            assert (walker != null);
            for (JsonValueAdapter adapter : list) {
                valueTexts.putValue((Object)walker.getNodeTextForValidation(adapter.getDelegate()), (Object)adapter);
            }
            for (Map.Entry entry : valueTexts.entrySet()) {
                if (((Collection)entry.getValue()).size() <= 1) continue;
                for (JsonValueAdapter item : (Collection)entry.getValue()) {
                    if (!item.shouldCheckAsValue()) continue;
                    consumer.error(JsonBundle.message("schema.validation.not.unique", new Object[0]), item.getDelegate(), JsonErrorPriority.TYPE_MISMATCH);
                }
            }
        }
        if (schema.getContainsSchema() != null) {
            boolean match = false;
            for (JsonValueAdapter item : list) {
                JsonValidationHost checker = consumer.checkByMatchResult(item, consumer.resolve(schema.getContainsSchema()), options);
                if (checker != null && !checker.isValid()) continue;
                match = true;
                break;
            }
            if (!match) {
                consumer.error(JsonBundle.message("schema.validation.array.not.contains", new Object[0]), array.getDelegate(), JsonErrorPriority.MEDIUM_PRIORITY);
            }
        }
        if (schema.getItemsSchema() != null) {
            for (JsonValueAdapter item : list) {
                consumer.checkObjectBySchemaRecordErrors(schema.getItemsSchema(), item);
            }
        } else if (schema.getItemsSchemaList() != null) {
            Iterator<JsonSchemaObject> iterator = schema.getItemsSchemaList().iterator();
            for (JsonValueAdapter arrayValue : list) {
                if (iterator.hasNext()) {
                    consumer.checkObjectBySchemaRecordErrors(iterator.next(), arrayValue);
                    continue;
                }
                if (!Boolean.TRUE.equals(schema.getAdditionalItemsAllowed())) {
                    consumer.error(JsonBundle.message("schema.validation.array.no.extra", new Object[0]), arrayValue.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
                    continue;
                }
                if (schema.getAdditionalItemsSchema() == null) continue;
                consumer.checkObjectBySchemaRecordErrors(schema.getAdditionalItemsSchema(), arrayValue);
            }
        }
        if (schema.getMinItems() != null && list.size() < schema.getMinItems()) {
            consumer.error(JsonBundle.message("schema.validation.array.shorter.than", schema.getMinItems()), array.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
        }
        if (schema.getMaxItems() != null && list.size() > schema.getMaxItems()) {
            consumer.error(JsonBundle.message("schema.validation.array.longer.than", schema.getMaxItems()), array.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
        }
        if (schema.getMinLength() != null && list.size() < schema.getMinLength()) {
            consumer.error(JsonBundle.message("schema.validation.array.shorter.than", schema.getMinLength()), array.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
        }
        if (schema.getMaxLength() != null && list.size() > schema.getMaxLength()) {
            consumer.error(JsonBundle.message("schema.validation.array.longer.than", schema.getMaxLength()), array.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
        }
    }
}

