/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.JsonPointerUtil;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.IfThenElse;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaTreeNode;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.SchemaResolveState;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaVariantsTreeBuilder {
    public static JsonSchemaTreeNode buildTree(@NotNull Project project, @NotNull JsonSchemaObject schema, @NotNull JsonPointerPosition position, boolean skipLastExpand) {
        JsonSchemaTreeNode root = new JsonSchemaTreeNode(null, schema);
        JsonSchemaService service = JsonSchemaService.Impl.get(project);
        JsonSchemaVariantsTreeBuilder.expandChildSchema(root, schema, service);
        for (JsonSchemaTreeNode treeNode : root.getChildren()) {
            treeNode.setPosition(position);
        }
        ArrayDeque<JsonSchemaTreeNode> queue = new ArrayDeque<JsonSchemaTreeNode>(root.getChildren());
        while (!queue.isEmpty()) {
            JsonSchemaTreeNode node = queue.removeFirst();
            if (node.isAny() || node.isNothing() || node.getPosition().isEmpty() || node.getSchema() == null) continue;
            JsonPointerPosition step = node.getPosition();
            if (!JsonSchemaVariantsTreeBuilder.typeMatches(step.isObject(0), node.getSchema())) {
                node.nothingChild();
                continue;
            }
            Pair<ThreeState, JsonSchemaObject> pair = JsonSchemaVariantsTreeBuilder.doSingleStep(step, node.getSchema(), true);
            if (ThreeState.NO.equals(pair.getFirst())) {
                node.nothingChild();
            } else if (ThreeState.YES.equals(pair.getFirst())) {
                node.anyChild();
            } else {
                assert (pair.getSecond() != null);
                if (node.getPosition().size() > 1 || !skipLastExpand) {
                    JsonSchemaVariantsTreeBuilder.expandChildSchema(node, (JsonSchemaObject)pair.getSecond(), service);
                } else {
                    node.setChild((JsonSchemaObject)pair.getSecond());
                }
            }
            queue.addAll(node.getChildren());
        }
        return root;
    }

    private static boolean typeMatches(boolean isObject, @NotNull JsonSchemaObject schema) {
        JsonSchemaType requiredType;
        JsonSchemaType jsonSchemaType = requiredType = isObject ? JsonSchemaType._object : JsonSchemaType._array;
        if (schema.getType() != null) {
            return requiredType.equals((Object)schema.getType());
        }
        if (schema.getTypeVariants() != null) {
            for (JsonSchemaType schemaType : schema.getTypeVariants()) {
                if (!requiredType.equals((Object)schemaType)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static void expandChildSchema(@NotNull JsonSchemaTreeNode node, @NotNull JsonSchemaObject childSchema, @NotNull JsonSchemaService service) {
        if (JsonSchemaVariantsTreeBuilder.interestingSchema(childSchema)) {
            node.createChildrenFromOperation(JsonSchemaVariantsTreeBuilder.getOperation(service, childSchema));
        } else {
            node.setChild(childSchema);
        }
    }

    @NotNull
    private static Operation getOperation(@NotNull JsonSchemaService service, JsonSchemaObject param) {
        ProcessDefinitionsOperation expand = new ProcessDefinitionsOperation(param, service);
        expand.doMap(new HashSet<JsonSchemaObject>());
        expand.doReduce();
        return expand;
    }

    @NotNull
    public static Pair<ThreeState, JsonSchemaObject> doSingleStep(@NotNull JsonPointerPosition step, @NotNull JsonSchemaObject parent, boolean processAllBranches) {
        String name = step.getFirstName();
        if (name != null) {
            return JsonSchemaVariantsTreeBuilder.propertyStep(name, parent, processAllBranches);
        }
        int index = step.getFirstIndex();
        assert (index >= 0);
        return JsonSchemaVariantsTreeBuilder.arrayOrNumericPropertyElementStep(index, parent);
    }

    private static List<JsonSchemaObject> andGroups(@NotNull List<JsonSchemaObject> g1, @NotNull List<JsonSchemaObject> g2) {
        ArrayList<JsonSchemaObject> result = new ArrayList<JsonSchemaObject>(g1.size() * g2.size());
        for (JsonSchemaObject s : g1) {
            result.addAll(JsonSchemaVariantsTreeBuilder.andGroup(s, g2));
        }
        return result;
    }

    private static List<JsonSchemaObject> andGroup(@NotNull JsonSchemaObject object, @NotNull List<JsonSchemaObject> group) {
        ArrayList<JsonSchemaObject> list = new ArrayList<JsonSchemaObject>(group.size());
        for (JsonSchemaObject s : group) {
            JsonSchemaObject schemaObject = JsonSchemaObject.merge(object, s, s);
            if (!schemaObject.isValidByExclusion()) continue;
            list.add(schemaObject);
        }
        return list;
    }

    private static boolean interestingSchema(@NotNull JsonSchemaObject schema) {
        return schema.getAnyOf() != null || schema.getOneOf() != null || schema.getAllOf() != null || schema.getRef() != null || schema.getIfThenElse() != null;
    }

    @NotNull
    private static Pair<ThreeState, JsonSchemaObject> propertyStep(@NotNull String name, @NotNull JsonSchemaObject parent, boolean processAllBranches) {
        List<IfThenElse> ifThenElseList;
        JsonSchemaObject child = parent.getProperties().get(name);
        if (child != null) {
            return Pair.create((Object)ThreeState.UNSURE, (Object)child);
        }
        JsonSchemaObject schema = parent.getMatchingPatternPropertySchema(name);
        if (schema != null) {
            return Pair.create((Object)ThreeState.UNSURE, (Object)schema);
        }
        if (parent.getAdditionalPropertiesSchema() != null) {
            return Pair.create((Object)ThreeState.UNSURE, (Object)parent.getAdditionalPropertiesSchema());
        }
        if (processAllBranches && (ifThenElseList = parent.getIfThenElse()) != null) {
            for (IfThenElse ifThenElse : ifThenElseList) {
                JsonSchemaObject childObject;
                JsonSchemaObject then = ifThenElse.getThen();
                if (then != null && (childObject = then.getProperties().get(name)) != null) {
                    return Pair.create((Object)ThreeState.UNSURE, (Object)childObject);
                }
                JsonSchemaObject elseBranch = ifThenElse.getElse();
                if (elseBranch == null || (childObject = elseBranch.getProperties().get(name)) == null) continue;
                return Pair.create((Object)ThreeState.UNSURE, (Object)childObject);
            }
        }
        if (Boolean.FALSE.equals(parent.getAdditionalPropertiesAllowed())) {
            return Pair.create((Object)ThreeState.NO, null);
        }
        return Pair.create((Object)ThreeState.YES, null);
    }

    @NotNull
    private static Pair<ThreeState, JsonSchemaObject> arrayOrNumericPropertyElementStep(int idx, @NotNull JsonSchemaObject parent) {
        if (parent.getItemsSchema() != null) {
            return Pair.create((Object)ThreeState.UNSURE, (Object)parent.getItemsSchema());
        }
        if (parent.getItemsSchemaList() != null) {
            List<JsonSchemaObject> list = parent.getItemsSchemaList();
            if (idx >= 0 && idx < list.size()) {
                return Pair.create((Object)ThreeState.UNSURE, (Object)list.get(idx));
            }
        }
        String keyAsString = String.valueOf(idx);
        if (parent.getProperties().containsKey(keyAsString)) {
            return Pair.create((Object)ThreeState.UNSURE, (Object)parent.getProperties().get(keyAsString));
        }
        JsonSchemaObject matchingPatternPropertySchema = parent.getMatchingPatternPropertySchema(keyAsString);
        if (matchingPatternPropertySchema != null) {
            return Pair.create((Object)ThreeState.UNSURE, (Object)matchingPatternPropertySchema);
        }
        if (parent.getAdditionalItemsSchema() != null) {
            return Pair.create((Object)ThreeState.UNSURE, (Object)parent.getAdditionalItemsSchema());
        }
        if (Boolean.FALSE.equals(parent.getAdditionalItemsAllowed())) {
            return Pair.create((Object)ThreeState.NO, null);
        }
        return Pair.create((Object)ThreeState.YES, null);
    }

    public static class SchemaUrlSplitter {
        @Nullable
        private final String mySchemaId;
        @NotNull
        private final String myRelativePath;

        public SchemaUrlSplitter(@NotNull String ref) {
            if (JsonPointerUtil.isSelfReference(ref)) {
                this.mySchemaId = null;
                this.myRelativePath = "";
                return;
            }
            if (!ref.startsWith("#/")) {
                int idx = ref.indexOf("#/");
                if (idx == -1) {
                    this.mySchemaId = ref.endsWith("#") ? ref.substring(0, ref.length() - 1) : ref;
                    this.myRelativePath = "";
                } else {
                    this.mySchemaId = ref.substring(0, idx);
                    this.myRelativePath = ref.substring(idx);
                }
            } else {
                this.mySchemaId = null;
                this.myRelativePath = ref;
            }
        }

        public boolean isAbsolute() {
            return this.mySchemaId != null;
        }

        @Nullable
        public String getSchemaId() {
            return this.mySchemaId;
        }

        @NotNull
        public String getRelativePath() {
            return this.myRelativePath;
        }
    }

    private static class AnyOfOperation
    extends Operation {
        private final JsonSchemaService myService;

        protected AnyOfOperation(@NotNull JsonSchemaObject sourceNode, JsonSchemaService service) {
            super(sourceNode);
            this.myService = service;
        }

        @Override
        public void map(@NotNull Set<JsonSchemaObject> visited) {
            List<JsonSchemaObject> anyOf = this.mySourceNode.getAnyOf();
            assert (anyOf != null);
            this.myChildOperations.addAll(ContainerUtil.map(anyOf, sourceNode -> new ProcessDefinitionsOperation((JsonSchemaObject)sourceNode, this.myService)));
        }

        @Override
        public void reduce() {
            for (Operation op : this.myChildOperations) {
                if (!op.myState.equals((Object)SchemaResolveState.normal)) continue;
                this.myAnyOfGroup.addAll(JsonSchemaVariantsTreeBuilder.andGroup(this.mySourceNode, op.myAnyOfGroup));
                for (List<JsonSchemaObject> group : op.myOneOfGroup) {
                    this.myOneOfGroup.add(JsonSchemaVariantsTreeBuilder.andGroup(this.mySourceNode, group));
                }
            }
        }
    }

    private static class OneOfOperation
    extends Operation {
        private final JsonSchemaService myService;

        protected OneOfOperation(@NotNull JsonSchemaObject sourceNode, JsonSchemaService service) {
            super(sourceNode);
            this.myService = service;
        }

        @Override
        public void map(@NotNull Set<JsonSchemaObject> visited) {
            List<JsonSchemaObject> oneOf = this.mySourceNode.getOneOf();
            assert (oneOf != null);
            this.myChildOperations.addAll(ContainerUtil.map(oneOf, sourceNode -> new ProcessDefinitionsOperation((JsonSchemaObject)sourceNode, this.myService)));
        }

        @Override
        public void reduce() {
            SmartList oneOf = new SmartList();
            for (Operation op : this.myChildOperations) {
                if (!op.myState.equals((Object)SchemaResolveState.normal)) continue;
                oneOf.addAll(JsonSchemaVariantsTreeBuilder.andGroup(this.mySourceNode, op.myAnyOfGroup));
                oneOf.addAll(JsonSchemaVariantsTreeBuilder.andGroup(this.mySourceNode, OneOfOperation.mergeOneOf(op)));
            }
            this.myOneOfGroup.add(oneOf);
        }
    }

    private static class AllOfOperation
    extends Operation {
        private final JsonSchemaService myService;

        protected AllOfOperation(@NotNull JsonSchemaObject sourceNode, JsonSchemaService service) {
            super(sourceNode);
            this.myService = service;
        }

        @Override
        public void map(@NotNull Set<JsonSchemaObject> visited) {
            List<JsonSchemaObject> allOf = this.mySourceNode.getAllOf();
            assert (allOf != null);
            this.myChildOperations.addAll(ContainerUtil.map(allOf, sourceNode -> new ProcessDefinitionsOperation((JsonSchemaObject)sourceNode, this.myService)));
        }

        private static <T> int maxSize(List<List<T>> items) {
            if (items.size() == 0) {
                return 0;
            }
            int maxsize = -1;
            for (List<T> item : items) {
                int size = item.size();
                if (maxsize >= size) continue;
                maxsize = size;
            }
            return maxsize;
        }

        @Override
        public void reduce() {
            this.myAnyOfGroup.add(this.mySourceNode);
            for (Operation op : this.myChildOperations) {
                if (!op.myState.equals((Object)SchemaResolveState.normal)) continue;
                List mergedAny = JsonSchemaVariantsTreeBuilder.andGroups(op.myAnyOfGroup, this.myAnyOfGroup);
                ArrayList<List> mergedExclusive = new ArrayList<List>(op.myAnyOfGroup.size() * AllOfOperation.maxSize(this.myOneOfGroup) + this.myAnyOfGroup.size() * AllOfOperation.maxSize(op.myOneOfGroup) + AllOfOperation.maxSize(this.myOneOfGroup) * AllOfOperation.maxSize(op.myOneOfGroup));
                for (List list : this.myOneOfGroup) {
                    mergedExclusive.add(JsonSchemaVariantsTreeBuilder.andGroups(op.myAnyOfGroup, list));
                }
                for (List list : op.myOneOfGroup) {
                    mergedExclusive.add(JsonSchemaVariantsTreeBuilder.andGroups(list, this.myAnyOfGroup));
                }
                for (List list : op.myOneOfGroup) {
                    for (List otherGroup : this.myOneOfGroup) {
                        mergedExclusive.add(JsonSchemaVariantsTreeBuilder.andGroups(list, otherGroup));
                    }
                }
                this.myAnyOfGroup.clear();
                this.myOneOfGroup.clear();
                this.myAnyOfGroup.addAll(mergedAny);
                this.myOneOfGroup.addAll(mergedExclusive);
            }
        }
    }

    private static class ProcessDefinitionsOperation
    extends Operation {
        private final JsonSchemaService myService;

        protected ProcessDefinitionsOperation(@NotNull JsonSchemaObject sourceNode, JsonSchemaService service) {
            super(sourceNode);
            this.myService = service;
        }

        @Override
        public void map(@NotNull Set<JsonSchemaObject> visited) {
            Operation expandOperation;
            JsonSchemaObject current = this.mySourceNode;
            while (!StringUtil.isEmptyOrSpaces((String)current.getRef())) {
                JsonSchemaObject definition = current.resolveRefSchema(this.myService);
                if (definition == null) {
                    this.myState = SchemaResolveState.brokenDefinition;
                    return;
                }
                if (!visited.add(definition)) break;
                current = JsonSchemaObject.merge(current, definition, current);
            }
            if ((expandOperation = this.createExpandOperation(current, this.myService)) != null) {
                this.myChildOperations.add(expandOperation);
            } else {
                this.myAnyOfGroup.add(current);
            }
        }

        @Override
        public void reduce() {
            if (!this.myChildOperations.isEmpty()) {
                assert (this.myChildOperations.size() == 1);
                Operation operation = (Operation)this.myChildOperations.get(0);
                this.myAnyOfGroup.addAll(operation.myAnyOfGroup);
                this.myOneOfGroup.addAll(operation.myOneOfGroup);
            }
        }
    }

    static abstract class Operation {
        @NotNull
        final List<JsonSchemaObject> myAnyOfGroup = new SmartList();
        @NotNull
        final List<List<JsonSchemaObject>> myOneOfGroup = new SmartList();
        @NotNull
        protected final List<Operation> myChildOperations;
        @NotNull
        protected final JsonSchemaObject mySourceNode;
        protected SchemaResolveState myState = SchemaResolveState.normal;

        protected Operation(@NotNull JsonSchemaObject sourceNode) {
            this.mySourceNode = sourceNode;
            this.myChildOperations = new ArrayList<Operation>();
        }

        protected abstract void map(@NotNull Set<JsonSchemaObject> var1);

        protected abstract void reduce();

        public void doMap(@NotNull Set<JsonSchemaObject> visited) {
            this.map(visited);
            for (Operation operation : this.myChildOperations) {
                operation.doMap(visited);
            }
        }

        public void doReduce() {
            if (!SchemaResolveState.normal.equals((Object)this.myState)) {
                this.myChildOperations.clear();
                this.myAnyOfGroup.clear();
                this.myOneOfGroup.clear();
                return;
            }
            this.myAnyOfGroup.forEach(Operation::clearVariants);
            this.myOneOfGroup.forEach(list -> list.forEach(Operation::clearVariants));
            for (Operation myChildOperation : this.myChildOperations) {
                myChildOperation.doReduce();
            }
            this.reduce();
            this.myChildOperations.clear();
        }

        private static void clearVariants(@NotNull JsonSchemaObject object) {
            object.setAllOf(null);
            object.setAnyOf(null);
            object.setOneOf(null);
        }

        @Nullable
        protected Operation createExpandOperation(@NotNull JsonSchemaObject schema, @NotNull JsonSchemaService service) {
            Operation forConflict = Operation.getOperationForConflict(schema, service);
            if (forConflict != null) {
                return forConflict;
            }
            if (schema.getAnyOf() != null) {
                return new AnyOfOperation(schema, service);
            }
            if (schema.getOneOf() != null) {
                return new OneOfOperation(schema, service);
            }
            if (schema.getAllOf() != null) {
                return new AllOfOperation(schema, service);
            }
            return null;
        }

        @Nullable
        private static Operation getOperationForConflict(@NotNull JsonSchemaObject schema, @NotNull JsonSchemaService service) {
            List<JsonSchemaObject> anyOf = schema.getAnyOf();
            List<JsonSchemaObject> oneOf = schema.getOneOf();
            List<JsonSchemaObject> allOf = schema.getAllOf();
            if (anyOf != null && (oneOf != null || allOf != null)) {
                return new AnyOfOperation(schema, service){
                    {
                        this.myState = SchemaResolveState.conflict;
                    }
                };
            }
            if (oneOf != null && allOf != null) {
                return new OneOfOperation(schema, service){
                    {
                        this.myState = SchemaResolveState.conflict;
                    }
                };
            }
            return null;
        }

        protected static List<JsonSchemaObject> mergeOneOf(Operation op) {
            return op.myOneOfGroup.stream().flatMap(Collection::stream).collect(Collectors.toList());
        }
    }
}

