/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import java.math.BigInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum JsonSchemaType {
    _string,
    _number,
    _integer,
    _object,
    _array,
    _boolean,
    _null,
    _any,
    _string_number;


    public String getName() {
        return this.name().substring(1);
    }

    public String getDefaultValue() {
        switch (this) {
            case _string: {
                return "\"\"";
            }
            case _number: 
            case _integer: 
            case _string_number: {
                return "0";
            }
            case _object: {
                return "{}";
            }
            case _array: {
                return "[]";
            }
            case _boolean: {
                return "false";
            }
            case _null: {
                return "null";
            }
        }
        return "";
    }

    public boolean isSimple() {
        switch (this) {
            case _string: 
            case _number: 
            case _integer: 
            case _boolean: 
            case _null: {
                return true;
            }
        }
        return false;
    }

    @Nullable
    static JsonSchemaType getType(@NotNull JsonValueAdapter value) {
        if (value.isNull()) {
            return _null;
        }
        if (value.isBooleanLiteral()) {
            return _boolean;
        }
        if (value.isStringLiteral()) {
            return value.isNumberLiteral() ? _string_number : _string;
        }
        if (value.isArray()) {
            return _array;
        }
        if (value.isObject()) {
            return _object;
        }
        if (value.isNumberLiteral()) {
            return JsonSchemaType.isInteger(value.getDelegate().getText()) ? _integer : _number;
        }
        return null;
    }

    public static boolean isInteger(@NotNull String text) {
        return JsonSchemaType.getIntegerValue(text) != null;
    }

    @Nullable
    public static Number getIntegerValue(@NotNull String text) {
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            try {
                return BigInteger.valueOf(Long.parseLong(text));
            }
            catch (NumberFormatException e2) {
                return null;
            }
        }
    }

    public String getDescription() {
        if (this == _any) {
            return "*";
        }
        return this.getName();
    }
}

