/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.json.JsonBundle;
import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonReferenceExpression;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.CaretSpecificDataContext;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.injection.Injectable;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.IfThenElse;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonRequiredPropsReferenceProvider;
import com.jetbrains.jsonSchema.impl.JsonSchemaAnnotatorChecker;
import com.jetbrains.jsonSchema.impl.JsonSchemaDocumentationProvider;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaUsageTriggerCollector;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaCompletionContributor
extends CompletionContributor {
    private static final String BUILTIN_USAGE_KEY = "builtin";
    private static final String SCHEMA_USAGE_KEY = "schema";
    private static final String USER_USAGE_KEY = "user";
    private static final String REMOTE_USAGE_KEY = "remote";

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        String propName;
        PsiElement parent;
        PsiElement position = parameters.getPosition();
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)position);
        if (file == null) {
            return;
        }
        JsonSchemaService service = JsonSchemaService.Impl.get(position.getProject());
        if (!service.isApplicableToFile(file)) {
            return;
        }
        JsonSchemaObject rootSchema = service.getSchemaObject(position.getContainingFile());
        if (rootSchema == null) {
            return;
        }
        PsiElement positionParent = position.getParent();
        if (positionParent != null && (parent = positionParent.getParent()) instanceof JsonProperty && ("$schema".equals(propName = ((JsonProperty)parent).getName()) && parent.getParent() instanceof JsonObject && parent.getParent().getParent() instanceof JsonFile || "$ref".equals(propName) && service.isSchemaFile(file))) {
            return;
        }
        JsonSchemaCompletionContributor.updateStat(service.getSchemaProvider(rootSchema), service.resolveSchemaFile(rootSchema));
        JsonSchemaCompletionContributor.doCompletion(parameters, result, rootSchema);
    }

    public static void doCompletion(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, @NotNull JsonSchemaObject rootSchema) {
        JsonSchemaCompletionContributor.doCompletion(parameters, result, rootSchema, true);
    }

    public static void doCompletion(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, @NotNull JsonSchemaObject rootSchema, boolean stop) {
        PsiElement completionPosition = parameters.getOriginalPosition() != null ? parameters.getOriginalPosition() : parameters.getPosition();
        new Worker(rootSchema, parameters.getPosition(), completionPosition, (Consumer<LookupElement>)result).work();
        if (stop) {
            result.stopHere();
        }
    }

    @NotNull
    public static List<LookupElement> getCompletionVariants(@NotNull JsonSchemaObject schema, @NotNull PsiElement position, @NotNull PsiElement originalPosition) {
        ArrayList<LookupElement> result = new ArrayList<LookupElement>();
        new Worker(schema, position, originalPosition, (Consumer<LookupElement>)((Consumer)element -> result.add((LookupElement)element))).work();
        return result;
    }

    private static void updateStat(@Nullable JsonSchemaFileProvider provider, VirtualFile schemaFile) {
        if (provider == null) {
            if (schemaFile instanceof HttpVirtualFile) {
                JsonSchemaUsageTriggerCollector.trigger(REMOTE_USAGE_KEY);
            }
            return;
        }
        SchemaType schemaType = provider.getSchemaType();
        switch (schemaType) {
            case schema: {
                JsonSchemaUsageTriggerCollector.trigger(SCHEMA_USAGE_KEY);
                break;
            }
            case userSchema: {
                JsonSchemaUsageTriggerCollector.trigger(USER_USAGE_KEY);
                break;
            }
            case embeddedSchema: {
                JsonSchemaUsageTriggerCollector.trigger(BUILTIN_USAGE_KEY);
                break;
            }
            case remoteSchema: {
                JsonSchemaUsageTriggerCollector.trigger(REMOTE_USAGE_KEY);
            }
        }
    }

    private static void insertPropertyWithEnum(InsertionContext context, Editor editor, String defaultValue, List<Object> values, JsonSchemaType type, String comma, JsonLikePsiWalker walker, boolean insertColon) {
        if (!walker.requiresValueQuotes() && defaultValue != null) {
            defaultValue = StringUtil.unquoteString((String)defaultValue);
        }
        boolean isNumber = type != null && (JsonSchemaType._integer.equals((Object)type) || JsonSchemaType._number.equals((Object)type)) || type == null && (defaultValue != null && !StringUtil.isQuotedString((String)defaultValue) || values != null && ContainerUtil.and(values, v -> !(v instanceof String)));
        boolean hasValues = !ContainerUtil.isEmpty(values);
        boolean hasDefaultValue = !StringUtil.isEmpty((String)defaultValue);
        boolean hasQuotes = isNumber || !walker.requiresValueQuotes();
        int offset = editor.getCaretModel().getOffset();
        CharSequence charSequence = editor.getDocument().getCharsSequence();
        String ws = charSequence.length() > offset && charSequence.charAt(offset) == ' ' ? "" : " ";
        String colonWs = insertColon ? ":" + ws : ws;
        String stringToInsert = colonWs + (hasDefaultValue ? defaultValue : (hasQuotes ? "" : "\"\"")) + comma;
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert, (boolean)false, (boolean)true, (int)(insertColon ? 2 : 1));
        if (!hasQuotes || hasDefaultValue) {
            SelectionModel model = editor.getSelectionModel();
            int caretStart = model.getSelectionStart();
            int newOffset = caretStart + (hasDefaultValue ? defaultValue.length() : 1);
            if (hasDefaultValue && !hasQuotes) {
                --newOffset;
            }
            model.setSelection(hasQuotes ? caretStart : caretStart + 1, newOffset);
            editor.getCaretModel().moveToOffset(newOffset);
        }
        if (!walker.hasWhitespaceDelimitedCodeBlocks() && !stringToInsert.equals(colonWs + comma)) {
            JsonSchemaCompletionContributor.formatInsertedString(context, stringToInsert.length());
        }
        if (hasValues) {
            AutoPopupController.getInstance((Project)context.getProject()).autoPopupMemberLookup(context.getEditor(), null);
        }
    }

    public static void formatInsertedString(@NotNull InsertionContext context, int offset) {
        Project project = context.getProject();
        PsiDocumentManager.getInstance((Project)project).commitDocument(context.getDocument());
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        codeStyleManager.reformatText(context.getFile(), context.getStartOffset(), context.getTailOffset() + offset);
    }

    private static class Worker {
        @NotNull
        private final JsonSchemaObject myRootSchema;
        @NotNull
        private final PsiElement myPosition;
        @NotNull
        private final PsiElement myOriginalPosition;
        @NotNull
        private final Consumer<LookupElement> myResultConsumer;
        private final boolean myWrapInQuotes;
        private final boolean myInsideStringLiteral;
        private final Set<LookupElement> myVariants;
        private final JsonLikePsiWalker myWalker;
        private final Project myProject;
        private static final Set<String> filtered = ContainerUtil.set((Object[])new String[]{"[]", "{}", "[ ]", "{ }"});

        Worker(@NotNull JsonSchemaObject rootSchema, @NotNull PsiElement position, @NotNull PsiElement originalPosition, @NotNull Consumer<LookupElement> resultConsumer) {
            this.myRootSchema = rootSchema;
            this.myPosition = position;
            this.myOriginalPosition = originalPosition;
            this.myProject = originalPosition.getProject();
            this.myResultConsumer = resultConsumer;
            this.myVariants = new HashSet<LookupElement>();
            this.myWalker = JsonLikePsiWalker.getWalker(this.myPosition, this.myRootSchema);
            this.myWrapInQuotes = !(position.getParent() instanceof JsonStringLiteral);
            this.myInsideStringLiteral = position.getParent() instanceof JsonStringLiteral;
        }

        public void work() {
            if (this.myWalker == null) {
                return;
            }
            PsiElement checkable = this.myWalker.findElementToCheck(this.myPosition);
            if (checkable == null) {
                return;
            }
            ThreeState isName = this.myWalker.isName(checkable);
            JsonPointerPosition position = this.myWalker.findPosition(checkable, isName == ThreeState.NO);
            if (position == null || position.isEmpty() && isName == ThreeState.NO) {
                return;
            }
            Collection<JsonSchemaObject> schemas = new JsonSchemaResolver(this.myProject, this.myRootSchema, position).resolve();
            HashSet knownNames = new HashSet();
            schemas.forEach(schema -> {
                if (isName != ThreeState.NO) {
                    boolean insertComma = this.myWalker.hasMissingCommaAfter(this.myPosition);
                    boolean hasValue = this.myWalker.isPropertyWithValue(checkable);
                    Set<String> properties = this.myWalker.getPropertyNamesOfParentObject(this.myOriginalPosition, this.myPosition);
                    JsonPropertyAdapter adapter = this.myWalker.getParentPropertyAdapter(this.myOriginalPosition);
                    Map<String, JsonSchemaObject> schemaProperties = schema.getProperties();
                    this.addAllPropertyVariants(insertComma, hasValue, properties, adapter, schemaProperties, knownNames);
                    this.addIfThenElsePropertyNameVariants((JsonSchemaObject)schema, insertComma, hasValue, (Collection<String>)properties, adapter, knownNames);
                    this.addPropertyNameSchemaVariants((JsonSchemaObject)schema);
                }
                if (isName != ThreeState.YES) {
                    this.suggestValues((JsonSchemaObject)schema, isName == ThreeState.NO);
                }
            });
            for (LookupElement variant : this.myVariants) {
                this.myResultConsumer.consume((Object)variant);
            }
        }

        private void addPropertyNameSchemaVariants(@NotNull JsonSchemaObject schema) {
            JsonSchemaObject propertyNamesSchema = schema.getPropertyNamesSchema();
            if (propertyNamesSchema == null) {
                return;
            }
            List<Object> anEnum = propertyNamesSchema.getEnum();
            if (anEnum == null) {
                return;
            }
            for (Object o : anEnum) {
                if (!(o instanceof String)) continue;
                String key = (String)o;
                key = !this.shouldWrapInQuotes(key, false) ? key : StringUtil.wrapWithDoubleQuote((String)key);
                this.myVariants.add((LookupElement)LookupElementBuilder.create((String)StringUtil.unquoteString((String)key)));
            }
        }

        private void addIfThenElsePropertyNameVariants(@NotNull JsonSchemaObject schema, boolean insertComma, boolean hasValue, @NotNull Collection<String> properties, @Nullable JsonPropertyAdapter adapter, Set<String> knownNames) {
            JsonPropertyAdapter propertyAdapter;
            List<IfThenElse> ifThenElseList = schema.getIfThenElse();
            if (ifThenElseList == null) {
                return;
            }
            JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker(this.myPosition, schema);
            JsonPropertyAdapter jsonPropertyAdapter = propertyAdapter = walker == null ? null : walker.getParentPropertyAdapter(this.myPosition);
            if (propertyAdapter == null) {
                return;
            }
            JsonObjectValueAdapter object = propertyAdapter.getParentObject();
            if (object == null) {
                return;
            }
            for (IfThenElse ifThenElse : ifThenElseList) {
                JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker(this.myProject, JsonComplianceCheckerOptions.RELAX_ENUM_CHECK);
                checker.checkByScheme(object, ifThenElse.getIf());
                if (checker.isCorrect()) {
                    JsonSchemaObject then = ifThenElse.getThen();
                    if (then == null) continue;
                    this.addAllPropertyVariants(insertComma, hasValue, properties, adapter, then.getProperties(), knownNames);
                    continue;
                }
                JsonSchemaObject schemaElse = ifThenElse.getElse();
                if (schemaElse == null) continue;
                this.addAllPropertyVariants(insertComma, hasValue, properties, adapter, schemaElse.getProperties(), knownNames);
            }
        }

        private void addAllPropertyVariants(boolean insertComma, boolean hasValue, Collection<String> properties, JsonPropertyAdapter adapter, Map<String, JsonSchemaObject> schemaProperties, Set<String> knownNames) {
            schemaProperties.keySet().stream().filter(name -> !properties.contains(name) && !knownNames.contains(name) || adapter != null && name.equals(adapter.getName())).forEach(name -> {
                knownNames.add((String)name);
                this.addPropertyVariant((String)name, (JsonSchemaObject)schemaProperties.get(name), hasValue, insertComma);
            });
        }

        private void suggestValues(JsonSchemaObject schema, boolean isSurelyValue) {
            block3: {
                block4: {
                    block2: {
                        this.suggestValuesForSchemaVariants(schema.getAnyOf(), isSurelyValue);
                        this.suggestValuesForSchemaVariants(schema.getOneOf(), isSurelyValue);
                        this.suggestValuesForSchemaVariants(schema.getAllOf(), isSurelyValue);
                        if (schema.getEnum() == null) break block2;
                        Map<String, Map<String, String>> metadata = schema.getEnumMetadata();
                        for (Object o : schema.getEnum()) {
                            String variant;
                            if (this.myInsideStringLiteral && !(o instanceof String) || filtered.contains(variant = o.toString())) continue;
                            Map<String, String> valueMetadata = metadata == null ? null : metadata.get(StringUtil.unquoteString((String)variant));
                            String description = valueMetadata == null ? null : valueMetadata.get("description");
                            String deprecated = valueMetadata == null ? null : valueMetadata.get("deprecationMessage");
                            this.addValueVariant(variant, description, deprecated != null ? variant + " (" + deprecated + ")" : null, null);
                        }
                        break block3;
                    }
                    if (!isSurelyValue) break block3;
                    JsonSchemaType type = schema.guessType();
                    this.suggestSpecialValues(type);
                    if (type == null) break block4;
                    this.suggestByType(schema, type);
                    break block3;
                }
                if (schema.getTypeVariants() == null) break block3;
                for (JsonSchemaType schemaType : schema.getTypeVariants()) {
                    this.suggestByType(schema, schemaType);
                }
            }
        }

        private void suggestSpecialValues(@Nullable JsonSchemaType type) {
            if (JsonSchemaVersion.isSchemaSchemaId(this.myRootSchema.getId()) && type == JsonSchemaType._string) {
                JsonPropertyAdapter adapter;
                JsonObjectValueAdapter parent;
                JsonPropertyAdapter propertyAdapter = this.myWalker.getParentPropertyAdapter(this.myOriginalPosition);
                if (propertyAdapter == null) {
                    return;
                }
                String name = propertyAdapter.getName();
                if (name == null) {
                    return;
                }
                if (name.equals("required")) {
                    this.addRequiredPropVariants();
                } else if (name.equals("x-intellij-language-injection")) {
                    this.addInjectedLanguageVariants();
                } else if (name.equals("language") && (parent = propertyAdapter.getParentObject()) != null && (adapter = this.myWalker.getParentPropertyAdapter(parent.getDelegate())) != null && "x-intellij-language-injection".equals(adapter.getName())) {
                    this.addInjectedLanguageVariants();
                }
            }
        }

        private void addInjectedLanguageVariants() {
            PsiElement checkable = this.myWalker.findElementToCheck(this.myPosition);
            if (!(checkable instanceof JsonStringLiteral) && !(checkable instanceof JsonReferenceExpression)) {
                return;
            }
            JBIterable.from((Iterable)Language.getRegisteredLanguages()).filter(LanguageUtil::isInjectableLanguage).map(Injectable::fromLanguage).forEach(it -> this.myVariants.add((LookupElement)LookupElementBuilder.create((String)it.getId()).withIcon(it.getIcon()).withTailText("(" + it.getDisplayName() + ")", true)));
        }

        private void addRequiredPropVariants() {
            PsiElement checkable = this.myWalker.findElementToCheck(this.myPosition);
            if (!(checkable instanceof JsonStringLiteral) && !(checkable instanceof JsonReferenceExpression)) {
                return;
            }
            JsonObject propertiesObject = JsonRequiredPropsReferenceProvider.findPropertiesObject(checkable);
            if (propertiesObject == null) {
                return;
            }
            PsiElement parent = checkable.getParent();
            HashSet items = parent instanceof JsonArray ? ((JsonArray)parent).getValueList().stream().filter(v -> v instanceof JsonStringLiteral).map(v -> ((JsonStringLiteral)v).getValue()).collect(Collectors.toSet()) : new HashSet();
            propertiesObject.getPropertyList().stream().map(p -> p.getName()).filter(n -> !items.contains(n)).forEach(n -> this.addStringVariant((String)n));
        }

        private void suggestByType(JsonSchemaObject schema, JsonSchemaType type) {
            if (JsonSchemaType._string.equals((Object)type)) {
                this.addPossibleStringValue(schema);
            }
            if (this.myInsideStringLiteral) {
                return;
            }
            if (JsonSchemaType._boolean.equals((Object)type)) {
                this.addPossibleBooleanValue(type);
            } else if (JsonSchemaType._null.equals((Object)type)) {
                this.addValueVariant("null", null);
            } else if (JsonSchemaType._array.equals((Object)type)) {
                String value = this.myWalker.getDefaultArrayValue();
                this.addValueVariant(value, null, "[...]", Worker.createArrayOrObjectLiteralInsertHandler(this.myWalker.hasWhitespaceDelimitedCodeBlocks(), value.length()));
            } else if (JsonSchemaType._object.equals((Object)type)) {
                String value = this.myWalker.getDefaultObjectValue();
                this.addValueVariant(value, null, "{...}", Worker.createArrayOrObjectLiteralInsertHandler(this.myWalker.hasWhitespaceDelimitedCodeBlocks(), value.length()));
            }
        }

        private void addPossibleStringValue(JsonSchemaObject schema) {
            Object defaultValue = schema.getDefault();
            String defaultValueString = defaultValue == null ? null : defaultValue.toString();
            this.addStringVariant(defaultValueString);
        }

        private void addStringVariant(String defaultValueString) {
            if (!StringUtil.isEmpty((String)defaultValueString)) {
                String normalizedValue = defaultValueString;
                boolean shouldQuote = this.myWalker.requiresValueQuotes();
                boolean isQuoted = StringUtil.isQuotedString((String)normalizedValue);
                if (shouldQuote && !isQuoted) {
                    normalizedValue = StringUtil.wrapWithDoubleQuote((String)normalizedValue);
                } else if (!shouldQuote && isQuoted) {
                    normalizedValue = StringUtil.unquoteString((String)normalizedValue);
                }
                this.addValueVariant(normalizedValue, null);
            }
        }

        private void suggestValuesForSchemaVariants(List<JsonSchemaObject> list, boolean isSurelyValue) {
            if (list != null && list.size() > 0) {
                for (JsonSchemaObject schemaObject : list) {
                    this.suggestValues(schemaObject, isSurelyValue);
                }
            }
        }

        private void addPossibleBooleanValue(JsonSchemaType type) {
            if (JsonSchemaType._boolean.equals((Object)type)) {
                this.addValueVariant("true", null);
                this.addValueVariant("false", null);
            }
        }

        private void addValueVariant(@NotNull String key, @Nullable String description) {
            this.addValueVariant(key, description, null, null);
        }

        private void addValueVariant(@NotNull String key, @Nullable String description, @Nullable String altText, @Nullable InsertHandler<LookupElement> handler) {
            String unquoted = StringUtil.unquoteString((String)key);
            LookupElementBuilder builder = LookupElementBuilder.create((String)(!this.shouldWrapInQuotes(unquoted, true) ? unquoted : key));
            if (altText != null) {
                builder = builder.withPresentableText(altText);
            }
            if (description != null) {
                builder = builder.withTypeText(description);
            }
            if (handler != null) {
                builder = builder.withInsertHandler(handler);
            }
            this.myVariants.add((LookupElement)builder);
        }

        private boolean shouldWrapInQuotes(String key, boolean isValue) {
            return this.myWrapInQuotes && this.myWalker != null && (isValue && this.myWalker.requiresValueQuotes() || !isValue && this.myWalker.requiresNameQuotes() || !this.myWalker.isValidIdentifier(key, this.myProject));
        }

        private void addPropertyVariant(@NotNull String key, @NotNull JsonSchemaObject jsonSchemaObject, boolean hasValue, boolean insertComma) {
            Object type;
            Collection<JsonSchemaObject> variants = new JsonSchemaResolver(this.myProject, jsonSchemaObject).resolve();
            jsonSchemaObject = (JsonSchemaObject)ObjectUtils.coalesce((Object)ContainerUtil.getFirstItem(variants), (Object)jsonSchemaObject);
            key = !this.shouldWrapInQuotes(key, false) ? key : StringUtil.wrapWithDoubleQuote((String)key);
            LookupElementBuilder builder = LookupElementBuilder.create((String)key);
            String typeText = JsonSchemaDocumentationProvider.getBestDocumentation(true, jsonSchemaObject);
            if (!StringUtil.isEmptyOrSpaces((String)typeText)) {
                String text = StringUtil.removeHtmlTags((String)typeText);
                int firstSentenceMark = text.indexOf(". ");
                builder = builder.withTypeText(firstSentenceMark == -1 ? text : text.substring(0, firstSentenceMark + 1), true);
            } else {
                type = jsonSchemaObject.getTypeDescription(true);
                if (type != null) {
                    builder = builder.withTypeText(type, true);
                }
            }
            builder = builder.withIcon(Worker.getIcon(jsonSchemaObject.guessType()));
            if (Worker.hasSameType(variants)) {
                boolean hasValues;
                type = jsonSchemaObject.guessType();
                List<Object> values = jsonSchemaObject.getEnum();
                Object defaultValue = jsonSchemaObject.getDefault();
                boolean bl = hasValues = !ContainerUtil.isEmpty(values);
                builder = type != null || hasValues || defaultValue != null ? builder.withInsertHandler(!hasValues || values.stream().map(v -> v.getClass()).distinct().count() == 1L ? this.createPropertyInsertHandler(jsonSchemaObject, hasValue, insertComma) : this.createDefaultPropertyInsertHandler(true, insertComma)) : builder.withInsertHandler(this.createDefaultPropertyInsertHandler(hasValue, insertComma));
            } else {
                builder = builder.withInsertHandler(this.createDefaultPropertyInsertHandler(hasValue, insertComma));
            }
            String deprecationMessage = jsonSchemaObject.getDeprecationMessage();
            if (deprecationMessage != null) {
                builder = builder.withTailText(JsonBundle.message("schema.documentation.deprecated.postfix", new Object[0]), true).withStrikeoutness(true);
            }
            this.myVariants.add((LookupElement)builder);
        }

        @NotNull
        private static Icon getIcon(@Nullable JsonSchemaType type) {
            if (type == null) {
                return AllIcons.Nodes.Property;
            }
            switch (type) {
                case _object: {
                    return AllIcons.Json.Object;
                }
                case _array: {
                    return AllIcons.Json.Array;
                }
            }
            return AllIcons.Nodes.Property;
        }

        private static boolean hasSameType(@NotNull Collection<JsonSchemaObject> variants) {
            return variants.stream().map(JsonSchemaObject::guessType).filter(Objects::nonNull).distinct().count() <= 1L;
        }

        private static InsertHandler<LookupElement> createArrayOrObjectLiteralInsertHandler(final boolean newline, final int insertedTextSize) {
            return new InsertHandler<LookupElement>(){

                public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                    Editor editor = context.getEditor();
                    if (!newline) {
                        EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)-1);
                    } else {
                        EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)(-insertedTextSize));
                        PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(editor.getDocument());
                        Worker.invokeEnterHandler(editor);
                        EditorActionUtil.moveCaretToLineEnd((Editor)editor, (boolean)false, (boolean)false);
                    }
                    AutoPopupController.getInstance((Project)context.getProject()).autoPopupMemberLookup(editor, null);
                }
            };
        }

        private InsertHandler<LookupElement> createDefaultPropertyInsertHandler(final boolean hasValue, final boolean insertComma) {
            return new InsertHandler<LookupElement>(){

                public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                    int offset;
                    ApplicationManager.getApplication().assertWriteAccessAllowed();
                    Editor editor = context.getEditor();
                    Project project = context.getProject();
                    if (this.handleInsideQuotesInsertion(context, editor, hasValue)) {
                        return;
                    }
                    int initialOffset = offset = editor.getCaretModel().getOffset();
                    CharSequence docChars = context.getDocument().getCharsSequence();
                    while (offset < docChars.length() && Character.isWhitespace(docChars.charAt(offset))) {
                        ++offset;
                    }
                    if (hasValue) {
                        if (offset < docChars.length() && docChars.charAt(offset) != ':') {
                            editor.getDocument().insertString(initialOffset, (CharSequence)":");
                            this.handleWhitespaceAfterColon(editor, docChars, initialOffset + 1);
                        }
                        return;
                    }
                    if (offset < docChars.length() && docChars.charAt(offset) == ':') {
                        this.handleWhitespaceAfterColon(editor, docChars, offset + 1);
                    } else {
                        String stringToInsert = ": 1" + (insertComma ? "," : "");
                        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert, (boolean)false, (boolean)true, (int)2);
                        JsonSchemaCompletionContributor.formatInsertedString(context, stringToInsert.length());
                        offset = editor.getCaretModel().getOffset();
                        context.getDocument().deleteString(offset, offset + 1);
                    }
                    PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                    AutoPopupController.getInstance((Project)context.getProject()).autoPopupMemberLookup(context.getEditor(), null);
                }

                public void handleWhitespaceAfterColon(Editor editor, CharSequence docChars, int nextOffset) {
                    if (nextOffset < docChars.length() && docChars.charAt(nextOffset) == ' ') {
                        editor.getCaretModel().moveToOffset(nextOffset + 1);
                    } else {
                        editor.getCaretModel().moveToOffset(nextOffset);
                        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)" ", (boolean)false, (boolean)true, (int)1);
                    }
                }
            };
        }

        @NotNull
        private InsertHandler<LookupElement> createPropertyInsertHandler(@NotNull JsonSchemaObject jsonSchemaObject, final boolean hasValue, final boolean insertComma) {
            Object defaultValue;
            JsonSchemaType type = jsonSchemaObject.guessType();
            final List<Object> values = jsonSchemaObject.getEnum();
            if (type == null && values != null && !values.isEmpty()) {
                type = Worker.detectType(values);
            }
            final String defaultValueAsString = (defaultValue = jsonSchemaObject.getDefault()) == null || defaultValue instanceof JsonSchemaObject ? null : (defaultValue instanceof String ? "\"" + defaultValue + "\"" : String.valueOf(defaultValue));
            final JsonSchemaType finalType = type;
            return new InsertHandler<LookupElement>(){

                public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                    block18: {
                        boolean insertColon;
                        String comma;
                        Editor editor;
                        block17: {
                            ApplicationManager.getApplication().assertWriteAccessAllowed();
                            editor = context.getEditor();
                            Project project = context.getProject();
                            String stringToInsert = null;
                            String string = comma = insertComma ? "," : "";
                            if (this.handleInsideQuotesInsertion(context, editor, hasValue)) {
                                return;
                            }
                            PsiElement element = context.getFile().findElementAt(editor.getCaretModel().getOffset());
                            boolean bl = insertColon = element == null || !":".equals(element.getText());
                            if (!insertColon) {
                                editor.getCaretModel().moveToOffset(editor.getCaretModel().getOffset() + 1);
                            }
                            if (finalType == null) break block17;
                            switch (finalType) {
                                case _object: {
                                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)(insertColon ? ": " : " "), (boolean)false, (boolean)true, (int)(insertColon ? 2 : 1));
                                    boolean hadEnter = false;
                                    boolean invokeEnter = myWalker.hasWhitespaceDelimitedCodeBlocks();
                                    if (insertColon && invokeEnter) {
                                        Worker.invokeEnterHandler(editor);
                                        hadEnter = true;
                                    }
                                    if (insertColon) {
                                        stringToInsert = myWalker.getDefaultObjectValue() + comma;
                                        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert, (boolean)false, (boolean)true, (int)(hadEnter ? 0 : 1));
                                    }
                                    if (hadEnter || !insertColon) {
                                        EditorActionUtil.moveCaretToLineEnd((Editor)editor, (boolean)false, (boolean)false);
                                    }
                                    PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                                    if (!hadEnter && stringToInsert != null) {
                                        JsonSchemaCompletionContributor.formatInsertedString(context, stringToInsert.length());
                                    }
                                    if (stringToInsert != null && !invokeEnter) {
                                        Worker.invokeEnterHandler(editor);
                                        break;
                                    }
                                    break block18;
                                }
                                case _boolean: {
                                    String value = String.valueOf(Boolean.TRUE.toString().equals(defaultValueAsString));
                                    stringToInsert = (insertColon ? ": " : " ") + value + comma;
                                    SelectionModel model = editor.getSelectionModel();
                                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert, (boolean)false, (boolean)true, (int)(stringToInsert.length() - comma.length()));
                                    JsonSchemaCompletionContributor.formatInsertedString(context, stringToInsert.length());
                                    int start = editor.getSelectionModel().getSelectionStart();
                                    model.setSelection(start - value.length(), start);
                                    AutoPopupController.getInstance((Project)context.getProject()).autoPopupMemberLookup(context.getEditor(), null);
                                    break;
                                }
                                case _array: {
                                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)(insertColon ? ": " : " "), (boolean)false, (boolean)true, (int)(insertColon ? 2 : 1));
                                    boolean hadEnter = false;
                                    if (insertColon && myWalker.hasWhitespaceDelimitedCodeBlocks()) {
                                        Worker.invokeEnterHandler(editor);
                                        hadEnter = true;
                                    }
                                    if (insertColon) {
                                        stringToInsert = myWalker.getDefaultArrayValue() + comma;
                                        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert, (boolean)false, (boolean)true, (int)(hadEnter ? 0 : 1));
                                    }
                                    if (hadEnter) {
                                        EditorActionUtil.moveCaretToLineEnd((Editor)editor, (boolean)false, (boolean)false);
                                    }
                                    PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                                    if (stringToInsert != null) {
                                        JsonSchemaCompletionContributor.formatInsertedString(context, stringToInsert.length());
                                        break;
                                    }
                                    break block18;
                                }
                                case _string: 
                                case _integer: 
                                case _number: {
                                    JsonSchemaCompletionContributor.insertPropertyWithEnum(context, editor, defaultValueAsString, values, finalType, comma, myWalker, insertColon);
                                    break;
                                }
                            }
                            break block18;
                        }
                        JsonSchemaCompletionContributor.insertPropertyWithEnum(context, editor, defaultValueAsString, values, null, comma, myWalker, insertColon);
                    }
                }
            };
        }

        private static void invokeEnterHandler(Editor editor) {
            EditorActionHandler handler = EditorActionManager.getInstance().getActionHandler("EditorEnter");
            Caret caret = editor.getCaretModel().getCurrentCaret();
            handler.execute(editor, caret, (DataContext)new CaretSpecificDataContext(DataManager.getInstance().getDataContext((Component)editor.getContentComponent()), caret));
        }

        private boolean handleInsideQuotesInsertion(@NotNull InsertionContext context, @NotNull Editor editor, boolean hasValue) {
            if (this.myInsideStringLiteral) {
                int offset = editor.getCaretModel().getOffset();
                PsiElement element = context.getFile().findElementAt(offset);
                int tailOffset = context.getTailOffset();
                int guessEndOffset = tailOffset + 1;
                if (element instanceof LeafPsiElement) {
                    if (Worker.handleIncompleteString(editor, element)) {
                        return false;
                    }
                    int endOffset = element.getTextRange().getEndOffset();
                    if (endOffset > tailOffset) {
                        context.getDocument().deleteString(tailOffset, endOffset - 1);
                    }
                }
                if (hasValue) {
                    return true;
                }
                editor.getCaretModel().moveToOffset(guessEndOffset);
            } else {
                editor.getCaretModel().moveToOffset(context.getTailOffset());
            }
            return false;
        }

        private static boolean handleIncompleteString(@NotNull Editor editor, @NotNull PsiElement element) {
            JsonValue nameElement;
            PsiElement prevSibling;
            if (((LeafPsiElement)element).getElementType() == TokenType.WHITE_SPACE && (prevSibling = element.getPrevSibling()) instanceof JsonProperty && !(nameElement = ((JsonProperty)prevSibling).getNameElement()).getText().endsWith("\"")) {
                editor.getCaretModel().moveToOffset(nameElement.getTextRange().getEndOffset());
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"\"", (boolean)false, (boolean)true, (int)1);
                return true;
            }
            return false;
        }

        @Nullable
        private static JsonSchemaType detectType(List<Object> values) {
            JsonSchemaType type = null;
            for (Object value : values) {
                JsonSchemaType newType = null;
                if (value instanceof Integer) {
                    newType = JsonSchemaType._integer;
                }
                if (type != null && !type.equals((Object)newType)) {
                    return null;
                }
                type = newType;
            }
            return type;
        }
    }
}

