/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.JsonBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.jsonSchema.extension.JsonErrorPriority;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.JsonSchemaValidation;
import com.jetbrains.jsonSchema.extension.JsonValidationHost;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonValidationError;
import com.jetbrains.jsonSchema.impl.MatchResult;
import com.jetbrains.jsonSchema.impl.validations.ArrayValidation;
import com.jetbrains.jsonSchema.impl.validations.EnumValidation;
import com.jetbrains.jsonSchema.impl.validations.IfThenElseValidation;
import com.jetbrains.jsonSchema.impl.validations.NotValidation;
import com.jetbrains.jsonSchema.impl.validations.NumericValidation;
import com.jetbrains.jsonSchema.impl.validations.ObjectValidation;
import com.jetbrains.jsonSchema.impl.validations.StringValidation;
import com.jetbrains.jsonSchema.impl.validations.TypeValidation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaAnnotatorChecker
implements JsonValidationHost {
    private static final Set<JsonSchemaType> PRIMITIVE_TYPES = ContainerUtil.set((Object[])new JsonSchemaType[]{JsonSchemaType._integer, JsonSchemaType._number, JsonSchemaType._boolean, JsonSchemaType._string, JsonSchemaType._null});
    private final Map<PsiElement, JsonValidationError> myErrors;
    @NotNull
    private final Project myProject;
    @NotNull
    private final JsonComplianceCheckerOptions myOptions;
    private boolean myHadTypeError;
    private static final JsonSchemaType[] NO_TYPES = new JsonSchemaType[0];

    protected JsonSchemaAnnotatorChecker(@NotNull Project project, @NotNull JsonComplianceCheckerOptions options) {
        this.myProject = project;
        this.myOptions = options;
        this.myErrors = new HashMap<PsiElement, JsonValidationError>();
    }

    public Map<PsiElement, JsonValidationError> getErrors() {
        return this.myErrors;
    }

    public boolean isHadTypeError() {
        return this.myHadTypeError;
    }

    public static JsonSchemaAnnotatorChecker checkByMatchResult(@NotNull Project project, @NotNull JsonValueAdapter elementToCheck, @NotNull MatchResult result, @NotNull JsonComplianceCheckerOptions options) {
        ArrayList<Object> checkers = new ArrayList<Object>();
        if (result.myExcludingSchemas.isEmpty() && result.mySchemas.size() == 1) {
            JsonSchemaAnnotatorChecker checker2 = new JsonSchemaAnnotatorChecker(project, options);
            checker2.checkByScheme(elementToCheck, result.mySchemas.iterator().next());
            checkers.add(checker2);
        } else {
            if (!result.mySchemas.isEmpty()) {
                checkers.add(JsonSchemaAnnotatorChecker.processSchemasVariants(project, result.mySchemas, elementToCheck, false, options).getSecond());
            }
            if (!result.myExcludingSchemas.isEmpty()) {
                List list = ContainerUtil.map(result.myExcludingSchemas, group -> (JsonSchemaAnnotatorChecker)JsonSchemaAnnotatorChecker.processSchemasVariants(project, group, elementToCheck, true, options).getSecond());
                checkers.add(JsonSchemaAnnotatorChecker.mergeErrors(project, list, options, result.myExcludingSchemas));
            }
        }
        if (checkers.isEmpty()) {
            return null;
        }
        if (checkers.size() == 1) {
            return (JsonSchemaAnnotatorChecker)checkers.get(0);
        }
        return checkers.stream().filter(checker -> !checker.isHadTypeError()).findFirst().orElse((JsonSchemaAnnotatorChecker)checkers.get(0));
    }

    private static JsonSchemaAnnotatorChecker mergeErrors(@NotNull Project project, @NotNull List<JsonSchemaAnnotatorChecker> list, @NotNull JsonComplianceCheckerOptions options, @NotNull List<Collection<? extends JsonSchemaObject>> excludingSchemas) {
        JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker(project, options);
        for (JsonSchemaAnnotatorChecker ch : list) {
            for (Map.Entry<PsiElement, JsonValidationError> element : ch.myErrors.entrySet()) {
                JsonValidationError error = element.getValue();
                if (error.getFixableIssueKind() == JsonValidationError.FixableIssueKind.ProhibitedProperty) {
                    String propertyName = ((JsonValidationError.ProhibitedPropertyIssueData)error.getIssueData()).propertyName;
                    boolean skip = false;
                    for (Collection<? extends JsonSchemaObject> objects : excludingSchemas) {
                        Set keys = objects.stream().filter(o -> !o.hasOwnExtraPropertyProhibition()).map(o -> o.getProperties().keySet()).flatMap(Collection::stream).collect(Collectors.toSet());
                        if (!keys.contains(propertyName)) continue;
                        skip = true;
                    }
                    if (skip) continue;
                }
                checker.myErrors.put(element.getKey(), error);
            }
        }
        return checker;
    }

    @Override
    public void error(String error, PsiElement holder, JsonErrorPriority priority) {
        this.error(error, holder, JsonValidationError.FixableIssueKind.None, null, priority);
    }

    @Override
    public void error(PsiElement newHolder, JsonValidationError error) {
        this.error(error.getMessage(), newHolder, error.getFixableIssueKind(), error.getIssueData(), error.getPriority());
    }

    @Override
    public void error(String error, PsiElement holder, JsonValidationError.FixableIssueKind fixableIssueKind, JsonValidationError.IssueData data, JsonErrorPriority priority) {
        if (this.myErrors.containsKey(holder)) {
            return;
        }
        this.myErrors.put(holder, new JsonValidationError(error, fixableIssueKind, data, priority));
    }

    @Override
    public void typeError(@NotNull PsiElement value, @Nullable JsonSchemaType currentType, JsonSchemaType ... allowedTypes) {
        if (allowedTypes.length == 0) {
            return;
        }
        String currentTypeDesc = currentType == null ? "" : " " + JsonBundle.message("schema.validation.actual", new Object[0]) + currentType.getName() + ".";
        String prefix = JsonBundle.message("schema.validation.incompatible.types", new Object[0]) + "\n";
        if (allowedTypes.length == 1) {
            this.error(prefix + " " + JsonBundle.message("schema.validation.required.one", allowedTypes[0].getName(), currentTypeDesc), value, JsonValidationError.FixableIssueKind.ProhibitedType, new JsonValidationError.TypeMismatchIssueData(allowedTypes), JsonErrorPriority.TYPE_MISMATCH);
        } else {
            String typesText = Arrays.stream(allowedTypes).map(JsonSchemaType::getName).distinct().sorted(Comparator.naturalOrder()).collect(Collectors.joining(", "));
            this.error(prefix + " " + JsonBundle.message("schema.validation.required.one.of", typesText, currentTypeDesc), value, JsonValidationError.FixableIssueKind.ProhibitedType, new JsonValidationError.TypeMismatchIssueData(allowedTypes), JsonErrorPriority.TYPE_MISMATCH);
        }
        this.myHadTypeError = true;
    }

    @Override
    public MatchResult resolve(JsonSchemaObject schemaObject) {
        return new JsonSchemaResolver(this.myProject, schemaObject).detailedResolve();
    }

    @Override
    @Nullable
    public JsonValidationHost checkByMatchResult(JsonValueAdapter adapter, MatchResult result, JsonComplianceCheckerOptions options) {
        return JsonSchemaAnnotatorChecker.checkByMatchResult(this.myProject, adapter, result, options);
    }

    @Override
    public boolean isValid() {
        return this.myErrors.size() == 0 && !this.myHadTypeError;
    }

    private static Collection<JsonSchemaValidation> getAllValidations(@NotNull JsonSchemaObject schema, JsonSchemaType type, @NotNull JsonValueAdapter value) {
        LinkedHashSet<JsonSchemaValidation> validations = new LinkedHashSet<JsonSchemaValidation>();
        validations.add(EnumValidation.INSTANCE);
        if (type != null) {
            validations.add(TypeValidation.INSTANCE);
            if (JsonSchemaType._string_number.equals((Object)type)) {
                validations.add(NumericValidation.INSTANCE);
                validations.add(StringValidation.INSTANCE);
            } else if (JsonSchemaType._number.equals((Object)type) || JsonSchemaType._integer.equals((Object)type)) {
                validations.add(NumericValidation.INSTANCE);
            } else if (JsonSchemaType._string.equals((Object)type)) {
                validations.add(StringValidation.INSTANCE);
            } else if (JsonSchemaType._array.equals((Object)type)) {
                validations.add(ArrayValidation.INSTANCE);
            } else if (JsonSchemaType._object.equals((Object)type)) {
                validations.add(ObjectValidation.INSTANCE);
            }
        }
        if (!value.isShouldBeIgnored()) {
            if (schema.hasNumericChecks() && value.isNumberLiteral()) {
                validations.add(NumericValidation.INSTANCE);
            }
            if (schema.hasStringChecks() && value.isStringLiteral()) {
                validations.add(StringValidation.INSTANCE);
            }
            if (schema.hasArrayChecks() && value.isArray()) {
                validations.add(ArrayValidation.INSTANCE);
            }
            if (JsonSchemaAnnotatorChecker.hasMinMaxLengthChecks(schema)) {
                if (value.isStringLiteral()) {
                    validations.add(StringValidation.INSTANCE);
                } else if (value.isArray()) {
                    validations.add(ArrayValidation.INSTANCE);
                }
            }
            if (schema.hasObjectChecks() && value.isObject()) {
                validations.add(ObjectValidation.INSTANCE);
            }
        }
        if (schema.getNot() != null) {
            validations.add(NotValidation.INSTANCE);
        }
        if (schema.getIfThenElse() != null) {
            validations.add(IfThenElseValidation.INSTANCE);
        }
        return validations;
    }

    public void checkByScheme(@NotNull JsonValueAdapter value, @NotNull JsonSchemaObject schema) {
        JsonSchemaType type = JsonSchemaType.getType(value);
        for (JsonSchemaValidation validation : JsonSchemaAnnotatorChecker.getAllValidations(schema, type, value)) {
            validation.validate(value, schema, type, this, this.myOptions);
        }
    }

    @Override
    public void checkObjectBySchemaRecordErrors(@NotNull JsonSchemaObject schema, @NotNull JsonValueAdapter object) {
        JsonSchemaAnnotatorChecker checker = JsonSchemaAnnotatorChecker.checkByMatchResult(this.myProject, object, new JsonSchemaResolver(this.myProject, schema).detailedResolve(), this.myOptions);
        if (checker != null) {
            this.myHadTypeError = checker.isHadTypeError();
            this.myErrors.putAll(checker.getErrors());
        }
    }

    @Override
    public void addErrorsFrom(JsonValidationHost otherHost) {
        this.myErrors.putAll(((JsonSchemaAnnotatorChecker)otherHost).myErrors);
    }

    @NotNull
    private static Pair<JsonSchemaObject, JsonSchemaAnnotatorChecker> processSchemasVariants(@NotNull Project project, @NotNull Collection<? extends JsonSchemaObject> collection, @NotNull JsonValueAdapter value, boolean isOneOf, JsonComplianceCheckerOptions options) {
        JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker(project, options);
        JsonSchemaType type = JsonSchemaType.getType(value);
        JsonSchemaObject selected = null;
        if (type == null) {
            if (!value.isShouldBeIgnored()) {
                checker.typeError(value.getDelegate(), null, JsonSchemaAnnotatorChecker.getExpectedTypes(collection));
            }
        } else {
            ArrayList<JsonSchemaObject> filtered = new ArrayList<JsonSchemaObject>(collection.size());
            JsonSchemaType altType = value.getAlternateType(type);
            for (JsonSchemaObject jsonSchemaObject : collection) {
                if (!JsonSchemaAnnotatorChecker.areSchemaTypesCompatible(jsonSchemaObject, type) && !JsonSchemaAnnotatorChecker.areSchemaTypesCompatible(jsonSchemaObject, altType)) continue;
                filtered.add(jsonSchemaObject);
            }
            if (filtered.isEmpty()) {
                checker.typeError(value.getDelegate(), altType, JsonSchemaAnnotatorChecker.getExpectedTypes(collection));
            } else if (filtered.size() == 1) {
                selected = (JsonSchemaObject)filtered.get(0);
                checker.checkByScheme(value, selected);
            } else {
                selected = isOneOf ? checker.processOneOf(value, filtered) : checker.processAnyOf(value, filtered);
            }
        }
        return Pair.create(selected, (Object)checker);
    }

    public static JsonSchemaType[] getExpectedTypes(Collection<? extends JsonSchemaObject> schemas) {
        ArrayList<JsonSchemaType> list = new ArrayList<JsonSchemaType>();
        for (JsonSchemaObject jsonSchemaObject : schemas) {
            JsonSchemaType type = jsonSchemaObject.getType();
            if (type != null) {
                list.add(type);
                continue;
            }
            Set<JsonSchemaType> variants = jsonSchemaObject.getTypeVariants();
            if (variants == null) continue;
            list.addAll(variants);
        }
        return list.isEmpty() ? NO_TYPES : list.toArray(NO_TYPES);
    }

    public static boolean areSchemaTypesCompatible(@NotNull JsonSchemaObject schema, @NotNull JsonSchemaType type) {
        JsonSchemaType matchingSchemaType = JsonSchemaAnnotatorChecker.getMatchingSchemaType(schema, type);
        if (matchingSchemaType != null) {
            return matchingSchemaType.equals((Object)type);
        }
        if (schema.getEnum() != null) {
            return PRIMITIVE_TYPES.contains((Object)type);
        }
        return true;
    }

    @Nullable
    public static JsonSchemaType getMatchingSchemaType(@NotNull JsonSchemaObject schema, @NotNull JsonSchemaType input) {
        JsonSchemaType matchType;
        if (schema.getType() != null && (matchType = schema.getType()) != null) {
            if (JsonSchemaType._integer.equals((Object)input) && JsonSchemaType._number.equals((Object)matchType)) {
                return input;
            }
            if (JsonSchemaType._string_number.equals((Object)input) && (JsonSchemaType._number.equals((Object)matchType) || JsonSchemaType._integer.equals((Object)matchType) || JsonSchemaType._string.equals((Object)matchType))) {
                return input;
            }
            return matchType;
        }
        if (schema.getTypeVariants() != null) {
            Set<JsonSchemaType> matchTypes = schema.getTypeVariants();
            if (matchTypes.contains((Object)input)) {
                return input;
            }
            if (JsonSchemaType._integer.equals((Object)input) && matchTypes.contains((Object)JsonSchemaType._number)) {
                return input;
            }
            if (JsonSchemaType._string_number.equals((Object)input) && (matchTypes.contains((Object)JsonSchemaType._number) || matchTypes.contains((Object)JsonSchemaType._integer) || matchTypes.contains((Object)JsonSchemaType._string))) {
                return input;
            }
            return matchTypes.iterator().next();
        }
        if (!schema.getProperties().isEmpty() && JsonSchemaType._object.equals((Object)input)) {
            return JsonSchemaType._object;
        }
        return null;
    }

    private static boolean hasMinMaxLengthChecks(JsonSchemaObject schema) {
        return schema.getMinLength() != null || schema.getMaxLength() != null;
    }

    @Nullable
    public static String getValue(PsiElement propValue, JsonSchemaObject schema) {
        JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker(propValue, schema);
        assert (walker != null);
        JsonValueAdapter adapter = walker.createValueAdapter(propValue);
        if (adapter != null && !adapter.shouldCheckAsValue()) {
            return null;
        }
        return walker.getNodeTextForValidation(propValue);
    }

    private JsonSchemaObject processOneOf(@NotNull JsonValueAdapter value, List<JsonSchemaObject> oneOf) {
        ArrayList<JsonSchemaAnnotatorChecker> candidateErroneousCheckers = new ArrayList<JsonSchemaAnnotatorChecker>();
        ArrayList<JsonSchemaObject> candidateErroneousSchemas = new ArrayList<JsonSchemaObject>();
        SmartList correct = new SmartList();
        for (JsonSchemaObject object : oneOf) {
            if (object.isShouldValidateAgainstJSType()) continue;
            JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker(this.myProject, this.myOptions);
            checker.checkByScheme(value, object);
            if (checker.isCorrect()) {
                candidateErroneousCheckers.clear();
                candidateErroneousSchemas.clear();
                correct.add(object);
                continue;
            }
            candidateErroneousCheckers.add(checker);
            candidateErroneousSchemas.add(object);
        }
        if (correct.size() == 1) {
            return (JsonSchemaObject)correct.get(0);
        }
        if (correct.size() > 0) {
            JsonSchemaType type = JsonSchemaType.getType(value);
            if (type != null && new HashSet(correct).size() > 1 && !JsonSchemaAnnotatorChecker.schemesDifferWithNotCheckedProperties((List<JsonSchemaObject>)correct)) {
                this.error(JsonBundle.message("schema.validation.to.more.than.one", new Object[0]), value.getDelegate(), JsonErrorPriority.MEDIUM_PRIORITY);
            }
            return (JsonSchemaObject)ContainerUtil.getLastItem((List)correct);
        }
        return this.showErrorsAndGetLeastErroneous(candidateErroneousCheckers, candidateErroneousSchemas, true);
    }

    private static boolean schemesDifferWithNotCheckedProperties(@NotNull List<JsonSchemaObject> list) {
        return list.stream().anyMatch(s -> !StringUtil.isEmptyOrSpaces((String)s.getFormat()));
    }

    @NotNull
    private static AverageFailureAmount getAverageFailureAmount(@NotNull JsonSchemaAnnotatorChecker checker) {
        int lowPriorityCount = 0;
        boolean hasMedium = false;
        boolean hasMissing = false;
        boolean hasHard = false;
        Collection<JsonValidationError> values = checker.getErrors().values();
        for (JsonValidationError value : values) {
            switch (value.getPriority()) {
                case LOW_PRIORITY: {
                    ++lowPriorityCount;
                    break;
                }
                case MISSING_PROPS: {
                    hasMissing = true;
                    break;
                }
                case MEDIUM_PRIORITY: {
                    hasMedium = true;
                    break;
                }
                case TYPE_MISMATCH: {
                    hasHard = true;
                    break;
                }
                case NOT_SCHEMA: {
                    return AverageFailureAmount.NotSchema;
                }
            }
        }
        if (hasHard) {
            return AverageFailureAmount.Hard;
        }
        if (hasMissing) {
            return AverageFailureAmount.MissingItems;
        }
        if (hasMedium) {
            return AverageFailureAmount.Medium;
        }
        return lowPriorityCount <= 3 ? AverageFailureAmount.Light : AverageFailureAmount.Medium;
    }

    private JsonSchemaObject processAnyOf(@NotNull JsonValueAdapter value, List<JsonSchemaObject> anyOf) {
        ArrayList<JsonSchemaAnnotatorChecker> candidateErroneousCheckers = new ArrayList<JsonSchemaAnnotatorChecker>();
        ArrayList<JsonSchemaObject> candidateErroneousSchemas = new ArrayList<JsonSchemaObject>();
        for (JsonSchemaObject object : anyOf) {
            JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker(this.myProject, this.myOptions);
            checker.checkByScheme(value, object);
            if (checker.isCorrect()) {
                return object;
            }
            candidateErroneousCheckers.add(checker);
            candidateErroneousSchemas.add(object);
        }
        return this.showErrorsAndGetLeastErroneous(candidateErroneousCheckers, candidateErroneousSchemas, false);
    }

    @Nullable
    private JsonSchemaObject showErrorsAndGetLeastErroneous(@NotNull List<JsonSchemaAnnotatorChecker> candidateErroneousCheckers, @NotNull List<JsonSchemaObject> candidateErroneousSchemas, boolean isOneOf) {
        JsonSchemaObject current = null;
        JsonSchemaObject currentWithMinAverage = null;
        Optional<AverageFailureAmount> minAverage = candidateErroneousCheckers.stream().map(c -> JsonSchemaAnnotatorChecker.getAverageFailureAmount(c)).min(Comparator.comparingInt(c -> c.ordinal()));
        int min = minAverage.orElse(AverageFailureAmount.Hard).ordinal();
        int minErrorCount = candidateErroneousCheckers.stream().map(c -> c.getErrors().size()).min(Integer::compareTo).orElse(Integer.MAX_VALUE);
        MultiMap errorsWithMinAverage = MultiMap.create();
        MultiMap allErrors = MultiMap.create();
        for (int i = 0; i < candidateErroneousCheckers.size(); ++i) {
            boolean isMoreThanAverage;
            JsonSchemaAnnotatorChecker checker = candidateErroneousCheckers.get(i);
            boolean isMoreThanMinErrors = checker.getErrors().size() > minErrorCount;
            boolean bl = isMoreThanAverage = JsonSchemaAnnotatorChecker.getAverageFailureAmount(checker).ordinal() > min;
            if (isMoreThanMinErrors) continue;
            if (isMoreThanAverage) {
                currentWithMinAverage = candidateErroneousSchemas.get(i);
            } else {
                current = candidateErroneousSchemas.get(i);
            }
            for (Map.Entry<Object, JsonValidationError> entry : checker.getErrors().entrySet()) {
                (isMoreThanAverage ? errorsWithMinAverage : allErrors).putValue(entry.getKey(), (Object)entry.getValue());
            }
        }
        if (allErrors.isEmpty()) {
            allErrors = errorsWithMinAverage;
        }
        for (Map.Entry entry : allErrors.entrySet()) {
            Collection value = (Collection)entry.getValue();
            if (value.size() == 0) continue;
            if (value.size() == 1) {
                this.error((PsiElement)entry.getKey(), (JsonValidationError)value.iterator().next());
                continue;
            }
            JsonValidationError error = JsonSchemaAnnotatorChecker.tryMergeErrors(value, isOneOf);
            if (error != null) {
                this.error((PsiElement)entry.getKey(), error);
                continue;
            }
            for (JsonValidationError jsonValidationError : value) {
                this.error((PsiElement)entry.getKey(), jsonValidationError);
            }
        }
        if (current == null) {
            current = currentWithMinAverage;
        }
        if (current == null) {
            current = (JsonSchemaObject)ContainerUtil.getLastItem(candidateErroneousSchemas);
        }
        return current;
    }

    @Nullable
    private static JsonValidationError tryMergeErrors(@NotNull Collection<JsonValidationError> errors, boolean isOneOf) {
        JsonValidationError.FixableIssueKind commonIssueKind = null;
        for (JsonValidationError error : errors) {
            JsonValidationError.FixableIssueKind currentIssueKind = error.getFixableIssueKind();
            if (currentIssueKind == JsonValidationError.FixableIssueKind.None) {
                return null;
            }
            if (commonIssueKind == null) {
                commonIssueKind = currentIssueKind;
                continue;
            }
            if (currentIssueKind == commonIssueKind) continue;
            return null;
        }
        if (commonIssueKind == JsonValidationError.FixableIssueKind.NonEnumValue) {
            String prefix = JsonBundle.message("schema.validation.enum.mismatch", "");
            return new JsonValidationError(prefix + errors.stream().map(e -> StringUtil.trimEnd((String)StringUtil.trimStart((String)e.getMessage(), (String)prefix), (String)prefix)).map(e -> StringUtil.split((String)e, (String)", ")).flatMap(e -> e.stream()).distinct().collect(Collectors.joining(", ")), commonIssueKind, null, errors.iterator().next().getPriority());
        }
        if (commonIssueKind == JsonValidationError.FixableIssueKind.MissingProperty) {
            String sets = errors.stream().map(e -> (JsonValidationError.MissingMultiplePropsIssueData)e.getIssueData()).map(d -> d.getMessage(false)).collect(Collectors.joining(", or "));
            return new JsonValidationError(JsonBundle.message(isOneOf ? "schema.validation.one.of.property.sets.required" : "schema.validation.at.least.one.of.property.sets.required", sets), isOneOf ? JsonValidationError.FixableIssueKind.MissingOneOfProperty : JsonValidationError.FixableIssueKind.MissingAnyOfProperty, new JsonValidationError.MissingOneOfPropsIssueData(ContainerUtil.map(errors, e -> (JsonValidationError.MissingMultiplePropsIssueData)e.getIssueData())), errors.iterator().next().getPriority());
        }
        if (commonIssueKind == JsonValidationError.FixableIssueKind.ProhibitedType) {
            Set allTypes = errors.stream().map(e -> (JsonValidationError.TypeMismatchIssueData)e.getIssueData()).flatMap(d -> Arrays.stream(d.expectedTypes)).collect(Collectors.toSet());
            if (allTypes.size() == 1) {
                return errors.iterator().next();
            }
            List actualInfos = errors.stream().map(e -> e.getMessage()).map(JsonSchemaAnnotatorChecker::fetchActual).distinct().collect(Collectors.toList());
            String actualInfo = actualInfos.size() == 1 ? " " + JsonBundle.message("schema.validation.actual", new Object[0]) + (String)actualInfos.get(0) + "." : "";
            String commonTypeMessage = JsonBundle.message("schema.validation.incompatible.types", new Object[0]) + "\n" + JsonBundle.message("schema.validation.required.one.of", allTypes.stream().map(t -> t.getDescription()).sorted().collect(Collectors.joining(", ")), actualInfo);
            return new JsonValidationError(commonTypeMessage, JsonValidationError.FixableIssueKind.TypeMismatch, new JsonValidationError.TypeMismatchIssueData((JsonSchemaType[])ContainerUtil.toArray(allTypes, JsonSchemaType[]::new)), errors.iterator().next().getPriority());
        }
        return null;
    }

    private static String fetchActual(String message) {
        String actualMessage = JsonBundle.message("schema.validation.actual", new Object[0]);
        int actual = message.indexOf(actualMessage);
        if (actual == -1) {
            return null;
        }
        String substring = message.endsWith(actualMessage) ? message.substring(0, actual) : message.substring(actual + actualMessage.length());
        return StringUtil.trimEnd((String)substring, (String)".");
    }

    public boolean isCorrect() {
        return this.myErrors.isEmpty();
    }

    private static enum AverageFailureAmount {
        Light,
        MissingItems,
        Medium,
        Hard,
        NotSchema;

    }
}

