/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.extension;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.JsonSchemaMappingsProjectConfiguration;
import com.jetbrains.jsonSchema.UserDefinedJsonSchemaConfiguration;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaImportedProviderMarker;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaUserDefinedProviderFactory
implements JsonSchemaProviderFactory {
    @Override
    @NotNull
    public List<JsonSchemaFileProvider> getProviders(@NotNull Project project) {
        JsonSchemaMappingsProjectConfiguration configuration = JsonSchemaMappingsProjectConfiguration.getInstance(project);
        Map<String, UserDefinedJsonSchemaConfiguration> map = configuration.getStateMap();
        List providers = ContainerUtil.map(map.values(), schema -> this.createProvider(project, (UserDefinedJsonSchemaConfiguration)schema));
        return providers;
    }

    @NotNull
    public MyProvider createProvider(@NotNull Project project, UserDefinedJsonSchemaConfiguration schema) {
        String relPath = schema.getRelativePathToSchema();
        return new MyProvider(project, schema.getSchemaVersion(), schema.getName(), JsonFileResolver.isHttpPath(relPath) || relPath.startsWith("temp:///") || new File(relPath).isAbsolute() ? relPath : new File(project.getBasePath(), relPath).getAbsolutePath(), schema.getCalculatedPatterns());
    }

    static class MyProvider
    implements JsonSchemaFileProvider,
    JsonSchemaImportedProviderMarker {
        @NotNull
        private final Project myProject;
        @NotNull
        private final JsonSchemaVersion myVersion;
        @NotNull
        private final String myName;
        @NotNull
        private final String myFile;
        private VirtualFile myVirtualFile;
        @NotNull
        private final List<? extends PairProcessor<Project, VirtualFile>> myPatterns;

        MyProvider(@NotNull Project project, @NotNull JsonSchemaVersion version, @NotNull String name, @NotNull String file, @NotNull List<? extends PairProcessor<Project, VirtualFile>> patterns) {
            this.myProject = project;
            this.myVersion = version;
            this.myName = name;
            this.myFile = file;
            this.myPatterns = patterns;
        }

        @Override
        public JsonSchemaVersion getSchemaVersion() {
            return this.myVersion;
        }

        @Override
        @Nullable
        public VirtualFile getSchemaFile() {
            if (this.myVirtualFile != null && this.myVirtualFile.isValid()) {
                return this.myVirtualFile;
            }
            String path = this.myFile;
            if (JsonFileResolver.isAbsoluteUrl(path)) {
                this.myVirtualFile = JsonFileResolver.urlToFile(path);
            } else {
                LocalFileSystem lfs = LocalFileSystem.getInstance();
                this.myVirtualFile = lfs.findFileByPath(this.myFile);
                if (this.myVirtualFile == null) {
                    this.myVirtualFile = lfs.refreshAndFindFileByPath(this.myFile);
                }
            }
            return this.myVirtualFile;
        }

        @Override
        @NotNull
        public SchemaType getSchemaType() {
            return SchemaType.userSchema;
        }

        @Override
        @NotNull
        public String getName() {
            return this.myName;
        }

        @Override
        public boolean isAvailable(@NotNull VirtualFile file) {
            if (this.myPatterns.isEmpty() || file.isDirectory() || !file.isValid()) {
                return false;
            }
            return this.myPatterns.stream().anyMatch(processor -> processor.process((Object)this.myProject, (Object)file));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyProvider provider = (MyProvider)o;
            if (!this.myName.equals(provider.myName)) {
                return false;
            }
            return FileUtil.pathsEqual((String)this.myFile, (String)provider.myFile);
        }

        public int hashCode() {
            int result = this.myName.hashCode();
            result = 31 * result + FileUtil.pathHashCode((String)this.myFile);
            return result;
        }

        @Override
        @Nullable
        public String getRemoteSource() {
            return JsonFileResolver.isHttpPath(this.myFile) ? this.myFile : null;
        }
    }
}

