/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.extension;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaInfo {
    @Nullable
    private final JsonSchemaFileProvider myProvider;
    @Nullable
    private final String myUrl;
    @Nullable
    private String myName = null;
    @Nullable
    private String myDocumentation = null;
    @NotNull
    private static final Set<String> myDumbNames = ContainerUtil.set((Object[])new String[]{"schema", "lib", "cli", "packages", "master", "format", "angular", "config"});
    @NotNull
    private static final Map<String, String> myWeirdNames = ContainerUtil.stringMap((String[])new String[]{"http://json.schemastore.org/config", "asp.net config", "https://schemastore.azurewebsites.net/schemas/json/config.json", "asp.net config", "http://json.schemastore.org/2.0.0-csd.2.beta.2018-10-10.json", "sarif-2.0.0-csd.2.beta.2018-10-10", "https://schemastore.azurewebsites.net/schemas/json/2.0.0-csd.2.beta.2018-10-10.json", "sarif-2.0.0-csd.2.beta.2018-10-10"});

    public JsonSchemaInfo(@NotNull JsonSchemaFileProvider provider) {
        this.myProvider = provider;
        this.myUrl = null;
    }

    public JsonSchemaInfo(@NotNull String url) {
        this.myUrl = url;
        this.myProvider = null;
    }

    @Nullable
    public JsonSchemaFileProvider getProvider() {
        return this.myProvider;
    }

    @NotNull
    public String getUrl(Project project) {
        if (this.myProvider != null) {
            String remoteSource = this.myProvider.getRemoteSource();
            if (remoteSource != null) {
                return remoteSource;
            }
            VirtualFile schemaFile = this.myProvider.getSchemaFile();
            if (schemaFile == null) {
                return "";
            }
            if (schemaFile instanceof HttpVirtualFile) {
                return schemaFile.getUrl();
            }
            return JsonSchemaInfo.getRelativePath(project, schemaFile.getPath());
        }
        assert (this.myUrl != null);
        return this.myUrl;
    }

    @NotNull
    public String getDescription() {
        if (this.myProvider != null) {
            String providerName = this.myProvider.getPresentableName();
            return JsonSchemaInfo.sanitizeName(providerName);
        }
        assert (this.myUrl != null);
        if (myWeirdNames.containsKey(this.myUrl)) {
            return myWeirdNames.get(this.myUrl);
        }
        String url = this.myUrl.replace('\\', '/');
        return ContainerUtil.reverse((List)StringUtil.split((String)url, (String)"/")).stream().map(p -> JsonSchemaInfo.sanitizeName(p)).filter(p -> !JsonSchemaInfo.isVeryDumbName(p)).findFirst().orElse(JsonSchemaInfo.sanitizeName(this.myUrl));
    }

    @Nullable
    public String getDocumentation() {
        return this.myDocumentation;
    }

    public void setDocumentation(@Nullable String documentation) {
        this.myDocumentation = documentation;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    public void setName(@Nullable String name) {
        this.myName = name;
    }

    public static boolean isVeryDumbName(@Nullable String possibleName) {
        if (StringUtil.isEmptyOrSpaces((String)possibleName) || myDumbNames.contains(possibleName)) {
            return true;
        }
        return StringUtil.split((String)possibleName, (String)".").stream().allMatch(s -> JsonSchemaType.isInteger(s));
    }

    @NotNull
    private static String sanitizeName(@NotNull String providerName) {
        return StringUtil.trimEnd((String)StringUtil.trimEnd((String)StringUtil.trimEnd((String)providerName, (String)".json"), (String)"-schema"), (String)".schema");
    }

    @NotNull
    public JsonSchemaVersion getSchemaVersion() {
        return this.myProvider != null ? this.myProvider.getSchemaVersion() : JsonSchemaVersion.SCHEMA_4;
    }

    @NotNull
    public static String getRelativePath(@NotNull Project project, @NotNull String text) {
        String path;
        text = text.trim();
        if (project.isDefault() || project.getBasePath() == null || Strings.isEmptyOrSpaces((CharSequence)text)) {
            return text;
        }
        Path file = Paths.get(text, new String[0]);
        if (!file.isAbsolute()) {
            return text;
        }
        String relativePath = FileUtil.getRelativePath((String)project.getBasePath(), (String)FileUtil.toSystemIndependentName((String)file.toString()), (char)'/');
        if (relativePath != null) {
            return relativePath;
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByNioFile(file);
        if (virtualFile == null) {
            return text;
        }
        VirtualFile projectBaseDir = LocalFileSystem.getInstance().findFileByPath(project.getBasePath());
        if (projectBaseDir == null) {
            return text;
        }
        if (JsonSchemaInfo.isMeaningfulAncestor(VfsUtilCore.getCommonAncestor((VirtualFile)virtualFile, (VirtualFile)projectBaseDir)) && (path = VfsUtilCore.findRelativePath((VirtualFile)projectBaseDir, (VirtualFile)virtualFile, (char)File.separatorChar)) != null) {
            return path;
        }
        return text;
    }

    private static boolean isMeaningfulAncestor(@Nullable VirtualFile ancestor) {
        if (ancestor == null) {
            return false;
        }
        VirtualFile homeDir = VfsUtil.getUserHomeDir();
        return homeDir != null && VfsUtilCore.isAncestor((VirtualFile)homeDir, (VirtualFile)ancestor, (boolean)true);
    }
}

