/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.codeinsight;

import com.intellij.json.JsonBundle;
import com.intellij.json.codeinsight.JsonLiteralChecker;
import com.intellij.json.highlighting.JsonSyntaxHighlighterFactory;
import com.intellij.json.psi.JsonNumberLiteral;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonReferenceExpression;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JsonLiteralAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        block6: {
            List extensions;
            block7: {
                block5: {
                    extensions = JsonLiteralChecker.EP_NAME.getExtensionList();
                    if (!(element instanceof JsonReferenceExpression)) break block5;
                    JsonLiteralAnnotator.highlightPropertyKey(element, holder);
                    break block6;
                }
                if (!(element instanceof JsonStringLiteral)) break block7;
                JsonStringLiteral stringLiteral = (JsonStringLiteral)element;
                int elementOffset = element.getTextOffset();
                JsonLiteralAnnotator.highlightPropertyKey(element, holder);
                String text = JsonPsiUtil.getElementTextWithoutHostEscaping(element);
                int length = text.length();
                if (length <= 1 || text.charAt(0) != text.charAt(length - 1) || JsonPsiUtil.isEscapedChar(text, length - 1)) {
                    holder.newAnnotation(HighlightSeverity.ERROR, JsonBundle.message("syntax.error.missing.closing.quote", new Object[0])).create();
                }
                List<Pair<TextRange, String>> fragments = stringLiteral.getTextFragments();
                for (Pair<TextRange, String> fragment : fragments) {
                    for (JsonLiteralChecker checker : extensions) {
                        Pair<TextRange, String> error;
                        if (!checker.isApplicable(element) || (error = checker.getErrorForStringFragment(fragment, stringLiteral)) == null) continue;
                        holder.newAnnotation(HighlightSeverity.ERROR, (String)error.second).range(((TextRange)error.getFirst()).shiftRight(elementOffset)).create();
                    }
                }
                break block6;
            }
            if (!(element instanceof JsonNumberLiteral)) break block6;
            String text = null;
            for (JsonLiteralChecker checker : extensions) {
                String error;
                if (!checker.isApplicable(element)) continue;
                if (text == null) {
                    text = JsonPsiUtil.getElementTextWithoutHostEscaping(element);
                }
                if ((error = checker.getErrorForNumericLiteral(text)) == null) continue;
                holder.newAnnotation(HighlightSeverity.ERROR, error).create();
            }
        }
    }

    private static void highlightPropertyKey(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (JsonPsiUtil.isPropertyKey(element)) {
            if (Holder.DEBUG) {
                holder.newAnnotation(HighlightSeverity.INFORMATION, JsonBundle.message("annotation.property.key", new Object[0])).textAttributes(JsonSyntaxHighlighterFactory.JSON_PROPERTY_KEY).create();
            } else {
                holder.newSilentAnnotation(HighlightSeverity.INFORMATION).textAttributes(JsonSyntaxHighlighterFactory.JSON_PROPERTY_KEY).create();
            }
        }
    }

    private static class Holder {
        private static final boolean DEBUG = ApplicationManager.getApplication().isUnitTestMode();

        private Holder() {
        }
    }
}

