/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.ResourceBundleReferenceProvider;
import com.intellij.lang.properties.UastPropertiesReferenceProvider;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.UastInjectionHostReferenceProvider;
import com.intellij.psi.UastReferenceProvider;
import com.intellij.psi.UastReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;

public class PropertiesReferenceContributor
extends PsiReferenceContributor {
    private static final Logger LOG = Logger.getInstance(PropertiesReferenceContributor.class);

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        UastReferenceRegistrar.registerUastReferenceProvider((PsiReferenceRegistrar)registrar, (ElementPattern)UastPatterns.injectionHostUExpression(), (UastReferenceProvider)new UastPropertiesReferenceProvider(true), (double)-100.0);
        UastReferenceRegistrar.registerUastReferenceProvider((PsiReferenceRegistrar)registrar, (ElementPattern)UastPatterns.injectionHostUExpression().annotationParam("org.jetbrains.annotations.PropertyKey", "resourceBundle"), (UastReferenceProvider)new ResourceBundleReferenceProvider(), (double)0.0);
        UastReferenceRegistrar.registerUastReferenceProvider((PsiReferenceRegistrar)registrar, (ElementPattern)UastPatterns.injectionHostUExpression(), (UastReferenceProvider)new UastInjectionHostReferenceProvider(){
            private final ResourceBundleReferenceProvider myUnderlying = new ResourceBundleReferenceProvider();

            public PsiReference @NotNull [] getReferencesForInjectionHost(@NotNull UExpression uExpression, @NotNull PsiLanguageInjectionHost host, @NotNull ProcessingContext context) {
                UElement parent = uExpression.getUastParent();
                if (!(parent instanceof UField)) {
                    return PsiReference.EMPTY_ARRAY;
                }
                UField field = (UField)parent;
                UExpression initializer = field.getUastInitializer();
                if (initializer == null) {
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiElement initializerSource = initializer.getSourcePsi();
                if (initializerSource == null) {
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiElement elementSource = uExpression.getSourcePsi();
                if (initializerSource != elementSource || !field.isFinal() || !field.getType().equalsToText("java.lang.String")) {
                    return PsiReference.EMPTY_ARRAY;
                }
                ArrayList references = new ArrayList();
                PsiClass propertyKeyAnnotation = JavaPsiFacade.getInstance((Project)initializerSource.getProject()).findClass("org.jetbrains.annotations.PropertyKey", elementSource.getResolveScope());
                if (propertyKeyAnnotation != null) {
                    LOG.assertTrue(propertyKeyAnnotation.isAnnotationType());
                    AnnotatedElementsSearch.searchPsiParameters((PsiClass)propertyKeyAnnotation, (SearchScope)new LocalSearchScope((PsiElement)elementSource.getContainingFile())).forEach(parameter -> {
                        PsiModifierList list = parameter.getModifierList();
                        LOG.assertTrue(list != null);
                        PsiAnnotation annotation = list.findAnnotation("org.jetbrains.annotations.PropertyKey");
                        LOG.assertTrue(annotation != null);
                        for (PsiNameValuePair pair : annotation.getParameterList().getAttributes()) {
                            PsiAnnotationMemberValue value;
                            if (!"resourceBundle".equals(pair.getName()) || !((value = pair.getValue()) instanceof PsiReferenceExpression) || ((PsiReferenceExpression)value).resolve() != field.getSourcePsi()) continue;
                            Collections.addAll(references, this.myUnderlying.getReferencesForInjectionHost(uExpression, host, context));
                            return false;
                        }
                        return true;
                    });
                }
                return references.toArray(PsiReference.EMPTY_ARRAY);
            }
        }, (double)0.0);
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.psiElement(PropertyValueImpl.class), new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                String text = element.getText();
                String[] words = text.split("\\s");
                if (words.length != 1) {
                    return PsiReference.EMPTY_ARRAY;
                }
                return Holder.CLASS_REFERENCE_PROVIDER.getReferencesByString(words[0], element, 0);
            }
        });
    }

    private static class Holder {
        private static final JavaClassReferenceProvider CLASS_REFERENCE_PROVIDER = new JavaClassReferenceProvider(){

            public boolean isSoft() {
                return true;
            }
        };

        private Holder() {
        }
    }
}

