/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n.batch;

import org.jetbrains.annotations.NotNull;

public class I18nizedPropertyData<D> {
    private final String myKey;
    private final String myValue;
    private final boolean myMarkAsNonNls;
    private final D myContextData;

    public I18nizedPropertyData(@NotNull String key, @NotNull String value, @NotNull D contextData) {
        this(key, value, contextData, false);
    }

    private I18nizedPropertyData(@NotNull String key, @NotNull String value, @NotNull D contextData, boolean markAsNonNls) {
        this.myKey = key;
        this.myValue = value;
        this.myContextData = contextData;
        this.myMarkAsNonNls = markAsNonNls;
    }

    public String getKey() {
        return this.myKey;
    }

    public String getValue() {
        return this.myValue;
    }

    public D getContextData() {
        return this.myContextData;
    }

    public boolean isMarkAsNonNls() {
        return this.myMarkAsNonNls;
    }

    public I18nizedPropertyData<D> changeKey(@NotNull String newKey) {
        return new I18nizedPropertyData<D>(newKey, this.myValue, this.myContextData, this.myMarkAsNonNls);
    }

    public I18nizedPropertyData<D> setMarkAsNonNls(boolean markAsNonNls) {
        return new I18nizedPropertyData<D>(this.myKey, this.myValue, this.myContextData, markAsNonNls);
    }
}

