/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.IntStream;
import kotlin.Pair;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;

public abstract class NlsInfo {
    @NotNull
    private static final Set<String> ANNOTATION_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"org.jetbrains.annotations.Nls", "org.jetbrains.annotations.NonNls"});
    @NotNull
    private static final String NLS_CONTEXT = "com.intellij.openapi.util.NlsContext";
    @NotNull
    private final ThreeState myNls;

    private NlsInfo(@NotNull ThreeState nls) {
        this.myNls = nls;
    }

    @NotNull
    public ThreeState getNlsStatus() {
        return this.myNls;
    }

    @NotNull
    public static Localized localized() {
        return Localized.NLS;
    }

    @NotNull
    public static NonLocalized nonLocalized() {
        return NonLocalized.INSTANCE;
    }

    @NotNull
    public static NlsInfo forExpression(@NotNull UExpression expression) {
        NlsInfo info = NlsInfo.fromMethodReturn(expression);
        if (info != Unspecified.UNKNOWN) {
            return info;
        }
        info = NlsInfo.fromInitializer(expression);
        if (info != Unspecified.UNKNOWN) {
            return info;
        }
        return NlsInfo.fromArgument(expression);
    }

    @NotNull
    public static NlsInfo forModifierListOwner(@NotNull PsiModifierListOwner owner) {
        PsiElement scope;
        if (owner instanceof PsiParameter && (scope = ((PsiParameter)owner).getDeclarationScope()) instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)scope;
            PsiParameterList list = method.getParameterList();
            int index = list.getParameterIndex((PsiParameter)owner);
            if (index < 0) {
                return Unspecified.UNKNOWN;
            }
            return NlsInfo.fromMethodParameter(method, index, null);
        }
        if (owner instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)owner;
            return NlsInfo.fromMethodReturn(method, method.getReturnType(), null);
        }
        return NlsInfo.fromAnnotationOwner((PsiAnnotationOwner)owner.getModifierList());
    }

    @NotNull
    public static Nls.Capitalization getCapitalization(@NotNull PsiModifierListOwner owner) {
        NlsInfo info = NlsInfo.forModifierListOwner(owner);
        if (info instanceof Localized) {
            return ((Localized)info).getCapitalization();
        }
        return Nls.Capitalization.NotSpecified;
    }

    private static NlsInfo fromInitializer(UExpression expression) {
        UElement parent;
        PsiElement var = null;
        while ((parent = expression.getUastParent()) instanceof UParenthesizedExpression || parent instanceof UIfExpression || parent instanceof UPolyadicExpression && ((UPolyadicExpression)parent).getOperator() == UastBinaryOperator.PLUS) {
            expression = (UExpression)parent;
        }
        if (parent instanceof UBinaryExpression) {
            UReferenceExpression lValue;
            UBinaryExpression binOp = (UBinaryExpression)parent;
            UastBinaryOperator operator = binOp.getOperator();
            if ((operator == UastBinaryOperator.ASSIGN || operator == UastBinaryOperator.PLUS_ASSIGN) && expression.equals(binOp.getRightOperand()) && (lValue = (UReferenceExpression)ObjectUtils.tryCast((Object)UastUtils.skipParenthesizedExprDown((UExpression)binOp.getLeftOperand()), UReferenceExpression.class)) != null) {
                var = lValue.resolve();
            }
        } else if (parent instanceof UVariable) {
            var = parent.getJavaPsi();
        }
        if (var instanceof PsiVariable) {
            NlsInfo info = NlsInfo.fromAnnotationOwner((PsiAnnotationOwner)((PsiVariable)var).getModifierList());
            if (info != Unspecified.UNKNOWN) {
                return info;
            }
            return NlsInfo.fromType(((PsiVariable)var).getType());
        }
        return Unspecified.UNKNOWN;
    }

    @NotNull
    private static NlsInfo fromArgument(@NotNull UExpression expression) {
        UCallExpression callExpression;
        UElement parent = UastUtils.skipParenthesizedExprUp((UElement)expression.getUastParent());
        if (parent instanceof UPolyadicExpression) {
            parent = UastUtils.skipParenthesizedExprUp((UElement)parent.getUastParent());
        }
        if ((callExpression = UastUtils.getUCallExpression((UElement)parent)) == null) {
            return Unspecified.UNKNOWN;
        }
        List arguments = callExpression.getValueArguments();
        OptionalInt idx = IntStream.range(0, arguments.size()).filter(i -> UastUtils.isUastChildOf((UElement)expression, (UElement)UastLiteralUtils.wrapULiteral((UExpression)((UExpression)arguments.get(i))), (boolean)false)).findFirst();
        if (!idx.isPresent()) {
            return Unspecified.UNKNOWN;
        }
        PsiMethod method = callExpression.resolve();
        if (method == null) {
            return Unspecified.UNKNOWN;
        }
        NlsInfo fromParameter = NlsInfo.fromMethodParameter(method, idx.getAsInt(), null);
        if (fromParameter != Unspecified.UNKNOWN) {
            return fromParameter;
        }
        PsiParameter parameter = method.getParameterList().getParameter(idx.getAsInt());
        if (parameter != null) {
            NlsInfo info;
            PsiType parameterType = parameter.getType();
            PsiElement psi = callExpression.getSourcePsi();
            if (psi instanceof PsiMethodCallExpression) {
                PsiSubstitutor substitutor = ((PsiMethodCallExpression)psi).getMethodExpression().advancedResolve(false).getSubstitutor();
                parameterType = substitutor.substitute(parameterType);
            }
            if ((info = NlsInfo.fromType(parameterType)) != Unspecified.UNKNOWN) {
                return info;
            }
        }
        return new Unspecified((PsiModifierListOwner)parameter);
    }

    @NotNull
    private static NlsInfo fromType(PsiType type) {
        if (type == null) {
            return Unspecified.UNKNOWN;
        }
        Ref result = Ref.create((Object)Unspecified.UNKNOWN);
        InheritanceUtil.processSuperTypes((PsiType)type, (boolean)true, eachType -> {
            NlsInfo info = NlsInfo.fromAnnotationOwner((PsiAnnotationOwner)eachType);
            if (info != Unspecified.UNKNOWN) {
                result.set((Object)info);
                return false;
            }
            return !(eachType instanceof PsiClassType) || PsiUtil.resolveClassInClassTypeOnly((PsiType)eachType) instanceof PsiTypeParameter;
        });
        return (NlsInfo)result.get();
    }

    @NotNull
    private static NlsInfo fromMethodReturn(@NotNull UExpression expression) {
        PsiMethod method;
        PsiType returnType = null;
        UNamedExpression nameValuePair = (UNamedExpression)UastUtils.getParentOfType((UElement)expression, UNamedExpression.class);
        if (nameValuePair != null) {
            method = UastUtils.getAnnotationMethod((UNamedExpression)nameValuePair);
        } else {
            UElement parent = UastUtils.skipParenthesizedExprUp((UElement)expression.getUastParent());
            while (parent instanceof UCallExpression && (UastExpressionUtils.isArrayInitializer((UElement)parent) || UastExpressionUtils.isNewArrayWithInitializer((UElement)parent))) {
                parent = UastUtils.skipParenthesizedExprUp((UElement)parent.getUastParent());
            }
            if (parent == null) {
                return Unspecified.UNKNOWN;
            }
            UReturnExpression returnStmt = (UReturnExpression)UastUtils.getParentOfType((UElement)parent, UReturnExpression.class, (boolean)false, (Class[])new Class[]{UCallExpression.class, ULambdaExpression.class});
            if (returnStmt == null) {
                return Unspecified.UNKNOWN;
            }
            UElement jumpTarget = returnStmt.getJumpTarget();
            if (jumpTarget instanceof UMethod) {
                method = ((UMethod)jumpTarget).getJavaPsi();
            } else if (jumpTarget instanceof ULambdaExpression) {
                PsiType type = ((ULambdaExpression)jumpTarget).getFunctionalInterfaceType();
                returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)type);
                if (type == null) {
                    return Unspecified.UNKNOWN;
                }
                method = LambdaUtil.getFunctionalInterfaceMethod((PsiType)type);
            } else {
                return Unspecified.UNKNOWN;
            }
        }
        if (method == null) {
            return Unspecified.UNKNOWN;
        }
        return NlsInfo.fromMethodReturn(method, returnType, null);
    }

    @NotNull
    private static NlsInfo fromMethodReturn(@NotNull PsiMethod method, @Nullable PsiType returnType, @Nullable Collection<? super PsiMethod> processed) {
        NlsInfo info;
        if (processed != null && processed.contains(method)) {
            return Unspecified.UNKNOWN;
        }
        NlsInfo methodInfo = NlsInfo.fromAnnotationOwner((PsiAnnotationOwner)method.getModifierList());
        if (methodInfo != Unspecified.UNKNOWN) {
            return methodInfo;
        }
        if (returnType != null && (info = NlsInfo.fromType(returnType)) != Unspecified.UNKNOWN) {
            return info;
        }
        PsiMethod[] superMethods = method.findSuperMethods();
        if (superMethods.length > 0) {
            if (processed == null) {
                processed = new THashSet();
            }
            processed.add((PsiMethod)method);
            for (PsiMethod superMethod : superMethods) {
                NlsInfo superInfo = NlsInfo.fromMethodReturn(superMethod, null, (Collection<? super PsiMethod>)processed);
                if (superInfo == Unspecified.UNKNOWN) continue;
                return superInfo;
            }
        }
        return new Unspecified((PsiModifierListOwner)method);
    }

    @NotNull
    private static NlsInfo fromAnnotationOwner(@Nullable PsiAnnotationOwner owner) {
        if (owner == null) {
            return Unspecified.UNKNOWN;
        }
        if (owner instanceof PsiModifierList) {
            return (NlsInfo)CachedValuesManager.getCachedValue((PsiElement)((PsiModifierList)owner), () -> CachedValueProvider.Result.create((Object)NlsInfo.computeFromAnnotationOwner(owner), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        }
        return NlsInfo.computeFromAnnotationOwner(owner);
    }

    @NotNull
    private static NlsInfo computeFromAnnotationOwner(@NotNull PsiAnnotationOwner owner) {
        PsiAnnotation annotation;
        PsiElement parent;
        for (PsiAnnotation annotation2 : owner.getAnnotations()) {
            NlsInfo info = NlsInfo.fromAnnotation(annotation2);
            if (info != Unspecified.UNKNOWN) {
                return info;
            }
            info = NlsInfo.fromMetaAnnotation(annotation2);
            if (info == Unspecified.UNKNOWN) continue;
            return info;
        }
        if (owner instanceof PsiModifierList && (parent = ((PsiModifierList)owner).getParent()) instanceof PsiModifierListOwner && (annotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)((PsiModifierListOwner)parent), ANNOTATION_NAMES, (boolean)false)) != null) {
            return NlsInfo.fromAnnotation(annotation);
        }
        return Unspecified.UNKNOWN;
    }

    @NotNull
    private static NlsInfo fromMetaAnnotation(@NotNull PsiAnnotation annotation) {
        PsiJavaCodeReferenceElement element = annotation.getNameReferenceElement();
        if (element == null) {
            return Unspecified.UNKNOWN;
        }
        PsiClass annotationClass = (PsiClass)ObjectUtils.tryCast((Object)element.resolve(), PsiClass.class);
        if (annotationClass == null) {
            return Unspecified.UNKNOWN;
        }
        NlsInfo baseInfo = Unspecified.UNKNOWN;
        String prefix = "";
        String suffix = "";
        for (PsiAnnotation metaAnno : annotationClass.getAnnotations()) {
            if (metaAnno.hasQualifiedName(NLS_CONTEXT)) {
                prefix = StringUtil.notNullize((String)AnnotationUtil.getStringAttributeValue((PsiAnnotation)metaAnno, (String)"prefix"));
                suffix = StringUtil.notNullize((String)AnnotationUtil.getStringAttributeValue((PsiAnnotation)metaAnno, (String)"suffix"));
                continue;
            }
            NlsInfo info = NlsInfo.fromAnnotation(metaAnno);
            if (info == Unspecified.UNKNOWN) continue;
            baseInfo = info;
        }
        if (baseInfo instanceof Localized) {
            return ((Localized)baseInfo).withPrefixAndSuffix(prefix, suffix);
        }
        return baseInfo;
    }

    @NotNull
    private static NlsInfo fromAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation.hasQualifiedName("org.jetbrains.annotations.NonNls") || annotation.hasQualifiedName("org.jetbrains.annotations.PropertyKey")) {
            return NonLocalized.INSTANCE;
        }
        if (annotation.hasQualifiedName("org.jetbrains.annotations.Nls")) {
            Pair pair;
            PsiAnnotationMemberValue value = annotation.findAttributeValue("capitalization");
            String name = null;
            if (value instanceof PsiReferenceExpression) {
                name = ((PsiReferenceExpression)value).getReferenceName();
            } else if (value instanceof PsiLiteralExpression && (pair = (Pair)ObjectUtils.tryCast((Object)((PsiLiteralExpression)value).getValue(), Pair.class)) != null && pair.getSecond() != null) {
                name = pair.getSecond().toString();
            }
            if (name != null) {
                if (Nls.Capitalization.Title.name().equals(name)) {
                    return Localized.NLS_TITLE;
                }
                if (Nls.Capitalization.Sentence.name().equals(name)) {
                    return Localized.NLS_SENTENCE;
                }
            }
            return Localized.NLS;
        }
        return Unspecified.UNKNOWN;
    }

    @NotNull
    private static NlsInfo fromMethodParameter(@NotNull PsiMethod method, int idx, @Nullable Collection<? super PsiMethod> processed) {
        Object param;
        if (processed != null && processed.contains(method)) {
            return Unspecified.UNKNOWN;
        }
        Object[] params = method.getParameterList().getParameters();
        if (idx >= params.length) {
            PsiParameter lastParam = (PsiParameter)ArrayUtil.getLastElement((Object[])params);
            if (lastParam == null || !lastParam.isVarArgs()) {
                return Unspecified.UNKNOWN;
            }
            param = lastParam;
        } else {
            param = params[idx];
        }
        NlsInfo explicit = NlsInfo.fromAnnotationOwner((PsiAnnotationOwner)param.getModifierList());
        if (explicit != Unspecified.UNKNOWN) {
            return explicit;
        }
        PsiMethod[] superMethods = method.findSuperMethods();
        if (superMethods.length > 0) {
            if (processed == null) {
                processed = new THashSet();
            }
            processed.add((PsiMethod)method);
            for (PsiMethod superMethod : superMethods) {
                NlsInfo superInfo = NlsInfo.fromMethodParameter(superMethod, idx, (Collection<? super PsiMethod>)processed);
                if (superInfo == Unspecified.UNKNOWN) continue;
                return superInfo;
            }
        }
        return NlsInfo.fromContainer(method);
    }

    @NotNull
    private static NlsInfo fromContainer(@NotNull PsiMethod method) {
        for (PsiClass containingClass = method.getContainingClass(); containingClass != null; containingClass = containingClass.getContainingClass()) {
            NlsInfo classInfo = NlsInfo.fromAnnotationOwner((PsiAnnotationOwner)containingClass.getModifierList());
            if (classInfo == Unspecified.UNKNOWN) continue;
            return classInfo;
        }
        PsiFile containingFile = method.getContainingFile();
        if (containingFile instanceof PsiClassOwner) {
            String packageName = ((PsiClassOwner)containingFile).getPackageName();
            PsiPackage aPackage = JavaPsiFacade.getInstance((Project)method.getProject()).findPackage(packageName);
            if (aPackage != null) {
                NlsInfo info = NlsInfo.fromAnnotationOwner((PsiAnnotationOwner)aPackage.getAnnotationList());
                if (info != Unspecified.UNKNOWN) {
                    return info;
                }
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)aPackage, ANNOTATION_NAMES, (boolean)false);
                if (annotation != null) {
                    return NlsInfo.fromAnnotation(annotation);
                }
            }
        }
        return Unspecified.UNKNOWN;
    }

    public static class Unspecified
    extends NlsInfo {
        private static final Unspecified UNKNOWN = new Unspecified(null);
        @Nullable
        private final PsiModifierListOwner myCandidate;

        private Unspecified(@Nullable PsiModifierListOwner candidate) {
            super(ThreeState.UNSURE);
            this.myCandidate = candidate;
        }

        @Nullable
        public PsiModifierListOwner getAnnotationCandidate() {
            return this.myCandidate;
        }
    }

    public static class NonLocalized
    extends NlsInfo {
        private static final NonLocalized INSTANCE = new NonLocalized();

        private NonLocalized() {
            super(ThreeState.NO);
        }
    }

    public static class Localized
    extends NlsInfo {
        private static final Localized NLS = new Localized(Nls.Capitalization.NotSpecified, "", "");
        private static final Localized NLS_TITLE = new Localized(Nls.Capitalization.Title, "", "");
        private static final Localized NLS_SENTENCE = new Localized(Nls.Capitalization.Sentence, "", "");
        @NotNull
        private final Nls.Capitalization myCapitalization;
        @NotNull
        @NonNls
        private final String myPrefix;
        @NotNull
        @NonNls
        private final String mySuffix;

        private Localized(@NotNull Nls.Capitalization capitalization, @NotNull @NonNls String prefix, @NotNull @NonNls String suffix) {
            super(ThreeState.YES);
            this.myCapitalization = capitalization;
            this.myPrefix = prefix;
            this.mySuffix = suffix;
        }

        @NotNull
        public Nls.Capitalization getCapitalization() {
            return this.myCapitalization;
        }

        @NotNull
        @NonNls
        public String getPrefix() {
            return this.myPrefix;
        }

        @NotNull
        @NonNls
        public String getSuffix() {
            return this.mySuffix;
        }

        @NotNull
        private NlsInfo withPrefixAndSuffix(@NotNull String prefix, @NotNull String suffix) {
            if (prefix.equals(this.myPrefix) && suffix.equals(this.mySuffix)) {
                return this;
            }
            return new Localized(this.myCapitalization, prefix, suffix);
        }
    }
}

