/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInspection.i18n.I18nizeQuickFix;
import com.intellij.codeInspection.i18n.JavaI18nizeQuickFixDialog;
import com.intellij.codeInspection.i18n.NlsInfo;
import com.intellij.java.i18n.JavaI18nBundle;
import com.intellij.lang.properties.psi.I18nizedTextGenerator;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.util.PsiConcatenationUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class I18nizeConcatenationQuickFix
extends I18nizeQuickFix {
    private static final Logger LOG = Logger.getInstance(I18nizeConcatenationQuickFix.class);
    @NonNls
    static final String PARAMETERS_OPTION_KEY = "PARAMETERS";

    public I18nizeConcatenationQuickFix(NlsInfo.Localized info) {
        super(info);
    }

    @Override
    public void checkApplicability(PsiFile psiFile, Editor editor) throws IncorrectOperationException {
        PsiPolyadicExpression concatenation = I18nizeConcatenationQuickFix.getEnclosingLiteralConcatenation(psiFile, editor);
        if (concatenation != null) {
            return;
        }
        String message = JavaI18nBundle.message("quickfix.i18n.concatentation.error", new Object[0]);
        throw new IncorrectOperationException(message);
    }

    @Override
    public JavaI18nizeQuickFixDialog createDialog(Project project, Editor editor, PsiFile psiFile) {
        PsiPolyadicExpression concatenation = I18nizeConcatenationQuickFix.getEnclosingLiteralConcatenation(psiFile, editor);
        assert (concatenation != null);
        PsiLiteralExpression literalExpression = I18nizeConcatenationQuickFix.getContainingLiteral(concatenation);
        if (literalExpression == null) {
            return null;
        }
        return this.createDialog(project, psiFile, literalExpression);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return JavaI18nBundle.message("quickfix.i18n.concatentation", new Object[0]);
    }

    @Override
    protected PsiElement doReplacementInJava(@NotNull PsiFile psiFile, @NotNull Editor editor, @Nullable PsiLiteralExpression literalExpression, String i18nizedText) throws IncorrectOperationException {
        PsiPolyadicExpression concatenation = I18nizeConcatenationQuickFix.getEnclosingLiteralConcatenation(psiFile, editor);
        assert (concatenation != null);
        PsiExpression expression = JavaPsiFacade.getInstance((Project)psiFile.getProject()).getElementFactory().createExpressionFromText(i18nizedText, (PsiElement)concatenation);
        return concatenation.replace((PsiElement)expression);
    }

    private static String composeParametersText(List<PsiExpression> args) {
        return args.stream().map(PsiElement::getText).collect(Collectors.joining(","));
    }

    @Override
    protected JavaI18nizeQuickFixDialog createDialog(Project project, PsiFile context, PsiLiteralExpression literalExpression) {
        PsiPolyadicExpression concatenation = I18nizeConcatenationQuickFix.getEnclosingLiteralConcatenation((PsiElement)literalExpression);
        final ArrayList<PsiExpression> args = new ArrayList<PsiExpression>();
        String formatString = I18nizeConcatenationQuickFix.getValueString(concatenation, args);
        return new JavaI18nizeQuickFixDialog(project, context, literalExpression, formatString, this.getCustomization(formatString), true, true){

            @Override
            @Nullable
            protected String getTemplateName() {
                return this.myResourceBundleManager.getConcatenationTemplateName();
            }

            @Override
            protected String generateText(I18nizedTextGenerator textGenerator, @NotNull String propertyKey, PropertiesFile propertiesFile, PsiLiteralExpression literalExpression) {
                return textGenerator.getI18nizedConcatenationText(propertyKey, I18nizeConcatenationQuickFix.composeParametersText(args), propertiesFile, literalExpression);
            }

            @Override
            public PsiExpression[] getParameters() {
                return args.toArray(PsiExpression.EMPTY_ARRAY);
            }

            @Override
            protected void addAdditionalAttributes(Map<String, String> attributes) {
                attributes.put(I18nizeConcatenationQuickFix.PARAMETERS_OPTION_KEY, I18nizeConcatenationQuickFix.composeParametersText(args));
            }
        };
    }

    @NotNull
    static String getValueString(PsiPolyadicExpression concatenation, List<PsiExpression> args) {
        String formatString = "";
        try {
            formatString = PsiConcatenationUtil.buildUnescapedFormatString((PsiExpression)concatenation, (boolean)false, args);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return formatString;
    }

    @Nullable
    private static PsiPolyadicExpression getEnclosingLiteralConcatenation(@NotNull PsiFile file, @NotNull Editor editor) {
        PsiElement elementAt = file.findElementAt(editor.getCaretModel().getOffset());
        return I18nizeConcatenationQuickFix.getEnclosingLiteralConcatenation(elementAt);
    }

    @Nullable
    static PsiPolyadicExpression getEnclosingLiteralConcatenation(PsiElement psiElement) {
        PsiPolyadicExpression element = (PsiPolyadicExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiPolyadicExpression.class, (boolean)false, (Class[])new Class[]{PsiMember.class});
        if (element == null) {
            return null;
        }
        PsiPolyadicExpression concatenation = null;
        boolean stringLiteralOccured = false;
        while (element.getOperationTokenType() == JavaTokenType.PLUS) {
            PsiElement parent;
            for (PsiExpression operand : element.getOperands()) {
                if (stringLiteralOccured |= operand instanceof PsiLiteralExpression && ((PsiLiteralExpression)operand).getValue() instanceof String) break;
            }
            if (stringLiteralOccured) {
                concatenation = element;
            }
            if (!((parent = element.getParent()) instanceof PsiPolyadicExpression)) {
                return concatenation;
            }
            element = (PsiPolyadicExpression)parent;
        }
        return concatenation;
    }

    private static PsiLiteralExpression getContainingLiteral(PsiPolyadicExpression concatenation) {
        for (PsiExpression operand : concatenation.getOperands()) {
            if (!(operand instanceof PsiLiteralExpression)) continue;
            return (PsiLiteralExpression)operand;
        }
        return null;
    }
}

