/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class SimpleColoredText
implements ColoredTextContainer {
    private final ArrayList<String> myTexts = new ArrayList(3);
    private final ArrayList<SimpleTextAttributes> myAttributes = new ArrayList(3);
    private String myCachedToString = null;

    public SimpleColoredText() {
    }

    public SimpleColoredText(@NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
        this();
        this.append(fragment, attributes);
    }

    @Override
    public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
        this.myTexts.add(fragment);
        this.myCachedToString = null;
        this.myAttributes.add(attributes);
    }

    public void insert(int index, @NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
        this.myTexts.add(index, fragment);
        this.myCachedToString = null;
        this.myAttributes.add(index, attributes);
    }

    public void clear() {
        this.myTexts.clear();
        this.myCachedToString = null;
        this.myAttributes.clear();
    }

    public void appendToComponent(@NotNull ColoredTextContainer component) {
        int size = this.myTexts.size();
        for (int i = 0; i < size; ++i) {
            String text = this.myTexts.get(i);
            SimpleTextAttributes attribute = this.myAttributes.get(i);
            component.append(text, attribute);
        }
    }

    public String toString() {
        if (this.myCachedToString == null) {
            this.myCachedToString = StringUtil.join(this.myTexts, (String)"");
        }
        return this.myCachedToString;
    }

    public ArrayList<String> getTexts() {
        return this.myTexts;
    }

    public ArrayList<SimpleTextAttributes> getAttributes() {
        return this.myAttributes;
    }

    public SimpleColoredText derive(SimpleTextAttributes attributes, boolean override) {
        SimpleColoredText result = new SimpleColoredText();
        for (int i = 0; i < this.myTexts.size(); ++i) {
            SimpleTextAttributes overridden = override ? SimpleTextAttributes.merge(this.myAttributes.get(i), attributes) : SimpleTextAttributes.merge(attributes, this.myAttributes.get(i));
            result.append(this.myTexts.get(i), overridden);
        }
        return result;
    }
}

