/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.IconWithToolTip;
import com.intellij.ui.RowIcon;
import com.intellij.ui.icons.CompositeIcon;
import com.intellij.ui.icons.DarkIconProvider;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBCachingScalableIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayeredIcon
extends JBCachingScalableIcon<LayeredIcon>
implements DarkIconProvider,
CompositeIcon,
IconWithToolTip {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.LayeredIcon");
    private final Icon[] myIcons;
    private Icon[] myScaledIcons;
    private final boolean[] myDisabledLayers;
    private final int[] myHShifts;
    private final int[] myVShifts;
    private int myXShift;
    private int myYShift;
    private int myWidth;
    private int myHeight;

    public LayeredIcon(int layerCount) {
        this.getScaleContext().addUpdateListener(this::updateSize);
        this.setAutoUpdateScaleContext(false);
        this.myIcons = new Icon[layerCount];
        this.myDisabledLayers = new boolean[layerCount];
        this.myHShifts = new int[layerCount];
        this.myVShifts = new int[layerCount];
    }

    public LayeredIcon(Icon ... icons) {
        this(icons.length);
        for (int i = 0; i < icons.length; ++i) {
            this.setIcon(icons[i], i);
        }
    }

    protected LayeredIcon(LayeredIcon icon) {
        super((JBCachingScalableIcon)icon);
        this.getScaleContext().addUpdateListener(this::updateSize);
        this.setAutoUpdateScaleContext(false);
        this.myIcons = (Icon[])ArrayUtil.copyOf((Object[])icon.myIcons);
        this.myScaledIcons = null;
        this.myDisabledLayers = ArrayUtil.copyOf((boolean[])icon.myDisabledLayers);
        this.myHShifts = ArrayUtil.copyOf((int[])icon.myHShifts);
        this.myVShifts = ArrayUtil.copyOf((int[])icon.myVShifts);
        this.myXShift = icon.myXShift;
        this.myYShift = icon.myYShift;
        this.myWidth = icon.myWidth;
        this.myHeight = icon.myHeight;
    }

    @NotNull
    public LayeredIcon copy() {
        return new LayeredIcon(this);
    }

    @NotNull
    public LayeredIcon deepCopy() {
        LayeredIcon icon = new LayeredIcon(this);
        for (int i = 0; i < icon.myIcons.length; ++i) {
            icon.myIcons[i] = IconUtil.copy(icon.myIcons[i], null);
        }
        return icon;
    }

    private Icon @NotNull [] myScaledIcons() {
        if (this.myScaledIcons != null) {
            return this.myScaledIcons;
        }
        this.myScaledIcons = RowIcon.scaleIcons(this.myIcons, this.getScale());
        return this.myScaledIcons;
    }

    @NotNull
    public LayeredIcon withIconPreScaled(boolean preScaled) {
        super.withIconPreScaled(preScaled);
        this.updateSize();
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LayeredIcon)) {
            return false;
        }
        LayeredIcon icon = (LayeredIcon)o;
        if (this.myHeight != icon.myHeight) {
            return false;
        }
        if (this.myWidth != icon.myWidth) {
            return false;
        }
        if (this.myXShift != icon.myXShift) {
            return false;
        }
        if (this.myYShift != icon.myYShift) {
            return false;
        }
        if (!Arrays.equals(this.myHShifts, icon.myHShifts)) {
            return false;
        }
        if (!Arrays.equals(this.myIcons, icon.myIcons)) {
            return false;
        }
        return Arrays.equals(this.myVShifts, icon.myVShifts);
    }

    public int hashCode() {
        return 0;
    }

    public void setIcon(Icon icon, int layer) {
        this.setIcon(icon, layer, 0, 0);
    }

    public Icon getIcon(int layer) {
        return this.myIcons[layer];
    }

    public int getIconCount() {
        return this.myIcons.length;
    }

    public Icon @NotNull [] getAllLayers() {
        return this.myIcons;
    }

    public void setIcon(Icon icon, int layer, int hShift, int vShift) {
        if (icon instanceof LayeredIcon) {
            ((LayeredIcon)icon).checkIHaventIconInsideMe(this);
        }
        this.myIcons[layer] = icon;
        this.myScaledIcons = null;
        this.myHShifts[layer] = hShift;
        this.myVShifts[layer] = vShift;
        this.updateSize();
    }

    public void setIcon(Icon icon, int layer, int constraint) {
        int y;
        int x;
        int width = this.getIconWidth();
        int height = this.getIconHeight();
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        if (width <= 1 || height <= 1) {
            this.setIcon(icon, layer);
            return;
        }
        switch (constraint) {
            case 0: {
                x = (width - w) / 2;
                y = (height - h) / 2;
                break;
            }
            case 1: {
                x = (width - w) / 2;
                y = 0;
                break;
            }
            case 2: {
                x = width - w;
                y = 0;
                break;
            }
            case 3: {
                x = width - w;
                y = (height - h) / 2;
                break;
            }
            case 4: {
                x = width - w;
                y = height - h;
                break;
            }
            case 5: {
                x = (width - w) / 2;
                y = height - h;
                break;
            }
            case 6: {
                x = 0;
                y = height - h;
                break;
            }
            case 7: {
                x = 0;
                y = (height - h) / 2;
                break;
            }
            case 8: {
                x = 0;
                y = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("The constraint should be one of SwingConstants' compass-directions [1..8] or CENTER [0], actual value is " + constraint);
            }
        }
        this.setIcon(icon, layer, x, y);
    }

    private void checkIHaventIconInsideMe(Icon icon) {
        LOG.assertTrue(icon != this);
        for (Icon child : this.myIcons) {
            if (!(child instanceof LayeredIcon)) continue;
            ((LayeredIcon)child).checkIHaventIconInsideMe(icon);
        }
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.getScaleContext().update();
        Icon[] icons = this.myScaledIcons();
        for (int i = 0; i < icons.length; ++i) {
            Icon icon = icons[i];
            if (icon == null || this.myDisabledLayers[i]) continue;
            int xOffset = (int)Math.floor((double)x + this.scaleVal(this.myXShift + this.myHShifts(i), ScaleType.OBJ_SCALE));
            int yOffset = (int)Math.floor((double)y + this.scaleVal(this.myYShift + this.myVShifts(i), ScaleType.OBJ_SCALE));
            icon.paintIcon(c, g, xOffset, yOffset);
        }
    }

    public boolean isLayerEnabled(int layer) {
        return !this.myDisabledLayers[layer];
    }

    public void setLayerEnabled(int layer, boolean enabled) {
        if (this.myDisabledLayers[layer] == enabled) {
            this.myDisabledLayers[layer] = !enabled;
            this.clearCachedScaledValue();
        }
    }

    @Override
    public int getIconWidth() {
        this.getScaleContext().update();
        if (this.myWidth <= 1) {
            this.updateSize();
        }
        return (int)Math.ceil(this.scaleVal(this.myWidth, ScaleType.OBJ_SCALE));
    }

    @Override
    public int getIconHeight() {
        this.getScaleContext().update();
        if (this.myHeight <= 1) {
            this.updateSize();
        }
        return (int)Math.ceil(this.scaleVal(this.myHeight, ScaleType.OBJ_SCALE));
    }

    private int myHShifts(int i) {
        return (int)Math.floor(this.scaleVal(this.myHShifts[i], ScaleType.USR_SCALE));
    }

    private int myVShifts(int i) {
        return (int)Math.floor(this.scaleVal(this.myVShifts[i], ScaleType.USR_SCALE));
    }

    protected void updateSize() {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        boolean allIconsAreNull = true;
        for (int i = 0; i < this.myIcons.length; ++i) {
            Icon icon = this.myIcons[i];
            if (icon == null) continue;
            allIconsAreNull = false;
            int hShift = this.myHShifts(i);
            int vShift = this.myVShifts(i);
            minX = Math.min(minX, hShift);
            maxX = Math.max(maxX, hShift + icon.getIconWidth());
            minY = Math.min(minY, vShift);
            maxY = Math.max(maxY, vShift + icon.getIconHeight());
        }
        if (allIconsAreNull) {
            return;
        }
        this.myWidth = maxX - minX;
        this.myHeight = maxY - minY;
        if (this.myIcons.length > 1) {
            this.myXShift = -minX;
            this.myYShift = -minY;
        }
    }

    @NotNull
    public Icon getDarkIcon(boolean isDark) {
        LayeredIcon newIcon = this.copy();
        for (int i = 0; i < newIcon.myIcons.length; ++i) {
            newIcon.myIcons[i] = newIcon.myIcons[i] == null ? null : IconLoader.getDarkIcon((Icon)newIcon.myIcons[i], (boolean)isDark);
        }
        return newIcon;
    }

    public static Icon create(Icon backgroundIcon, Icon foregroundIcon) {
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(backgroundIcon, 0);
        layeredIcon.setIcon(foregroundIcon, 1);
        return layeredIcon;
    }

    public String toString() {
        return "Layered icon " + this.getIconWidth() + "x" + this.getIconHeight() + ". myIcons=" + Arrays.asList(this.myIcons);
    }

    @Override
    public String getToolTip(boolean composite) {
        return LayeredIcon.combineIconTooltips(this.myIcons);
    }

    @Nullable
    static String combineIconTooltips(Icon[] icons) {
        Icon singleIcon = null;
        for (Icon icon : icons) {
            if (icon == null) continue;
            if (singleIcon != null) {
                return LayeredIcon.buildCompositeTooltip(icons);
            }
            singleIcon = icon;
        }
        if (singleIcon != null) {
            return singleIcon instanceof IconWithToolTip ? ((IconWithToolTip)singleIcon).getToolTip(false) : null;
        }
        return null;
    }

    @Nullable
    private static String buildCompositeTooltip(Icon[] icons) {
        StringBuilder result = null;
        for (int i = 0; i < icons.length; ++i) {
            String toolTip;
            Icon icon;
            Icon icon2 = icon = i == icons.length - 1 ? icons[0] : icons[i + 1];
            if (!(icon instanceof IconWithToolTip) || (toolTip = ((IconWithToolTip)icon).getToolTip(true)) == null) continue;
            if (result == null) {
                result = new StringBuilder(toolTip);
                continue;
            }
            result.append(" ").append(toolTip);
        }
        return result != null ? result.toString() : null;
    }
}

