/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.listeners;

import com.intellij.coverage.listeners.CoverageListener;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.testng.IDEATestNGListener;
import org.testng.ITestContext;
import org.testng.ITestResult;

public class IDEATestNGCoverageListener
extends CoverageListener
implements IDEATestNGListener {
    public void onTestStart(ITestResult iTestResult) {
        Object data = this.getData();
        if (data != null) {
            ((ProjectData)data).testStarted(IDEATestNGCoverageListener.getSanitizeTestName(iTestResult));
        }
    }

    private static String getSanitizeTestName(ITestResult iTestResult) {
        return IDEATestNGCoverageListener.sanitize(iTestResult.getTestClass().getName(), iTestResult.getName());
    }

    public void onTestSuccess(ITestResult iTestResult) {
        Object data = this.getData();
        if (data != null) {
            ((ProjectData)data).testEnded(IDEATestNGCoverageListener.getSanitizeTestName(iTestResult));
        }
    }

    public void onTestFailure(ITestResult iTestResult) {
        Object data = this.getData();
        if (data != null) {
            ((ProjectData)data).testEnded(IDEATestNGCoverageListener.getSanitizeTestName(iTestResult));
        }
    }

    public void onTestSkipped(ITestResult iTestResult) {
        Object data = this.getData();
        if (data != null) {
            ((ProjectData)data).testEnded(IDEATestNGCoverageListener.getSanitizeTestName(iTestResult));
        }
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult iTestResult) {
    }

    public void onStart(ITestContext iTestContext) {
    }

    public void onFinish(ITestContext iTestContext) {
    }
}

