/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.updater;

import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.ide.StatisticsNotificationManager;
import com.intellij.internal.statistic.connect.StatisticsService;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogMigration;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerKt;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerProvider;
import com.intellij.internal.statistic.eventLog.fus.FeatureUsageLogger;
import com.intellij.internal.statistic.eventLog.uploader.EventLogExternalUploader;
import com.intellij.internal.statistic.eventLog.validator.SensitiveDataValidator;
import com.intellij.internal.statistic.service.fus.collectors.FUStateUsagesLogger;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

final class StatisticsJobsScheduler
implements ApplicationInitializedListener {
    private static final int SEND_STATISTICS_INITIAL_DELAY_IN_MILLIS = 300000;
    private static final int CHECK_STATISTICS_PROVIDERS_DELAY_IN_MIN = 1;
    private static final int CHECK_EXTERNAL_UPLOADER_DELAY_IN_MIN = 3;
    public static final int LOG_APPLICATION_STATES_INITIAL_DELAY_IN_MIN = 15;
    public static final int LOG_APPLICATION_STATES_DELAY_IN_MIN = 1440;
    public static final int LOG_PROJECTS_STATES_INITIAL_DELAY_IN_MIN = 30;
    public static final int LOG_PROJECTS_STATES_DELAY_IN_MIN = 720;
    private static final Map<Project, Future<?>> myPersistStatisticsSessionsMap = Collections.synchronizedMap(new HashMap());

    StatisticsJobsScheduler() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw ExtensionNotApplicableException.INSTANCE;
        }
    }

    public void componentsInitialized() {
        StatisticsNotificationManager notificationManager = (StatisticsNotificationManager)ServiceManager.getService(StatisticsNotificationManager.class);
        if (notificationManager != null) {
            notificationManager.showNotificationIfNeeded();
        }
        StatisticsJobsScheduler.checkPreviousExternalUploadResult();
        StatisticsJobsScheduler.runEventLogStatisticsService();
        StatisticsJobsScheduler.runStatesLogging();
        StatisticsJobsScheduler.runWhitelistStorageUpdater();
        StatisticsEventLogMigration.performMigration();
    }

    private static void runWhitelistStorageUpdater() {
        JobScheduler.getScheduler().scheduleWithFixedDelay(() -> {
            List<StatisticsEventLoggerProvider> providers = StatisticsEventLoggerKt.getEventLogProviders();
            for (StatisticsEventLoggerProvider provider : providers) {
                if (!provider.isRecordEnabled()) continue;
                SensitiveDataValidator.getInstance(provider.getRecorderId()).update();
            }
        }, 3L, 180L, TimeUnit.MINUTES);
    }

    private static void checkPreviousExternalUploadResult() {
        JobScheduler.getScheduler().schedule(() -> {
            StatisticsEventLoggerProvider config = FeatureUsageLogger.INSTANCE.getConfig();
            if (config.isRecordEnabled()) {
                EventLogExternalUploader.INSTANCE.logPreviousExternalUploadResult(config.getRecorderId());
            }
        }, 3L, TimeUnit.MINUTES);
    }

    private static void runEventLogStatisticsService() {
        JobScheduler.getScheduler().schedule(() -> {
            List<StatisticsEventLoggerProvider> providers = StatisticsEventLoggerKt.getEventLogProviders();
            for (StatisticsEventLoggerProvider provider : providers) {
                if (!provider.isSendEnabled()) continue;
                StatisticsService statisticsService = StatisticsUploadAssistant.getEventLogStatisticsService(provider.getRecorderId());
                StatisticsJobsScheduler.runStatisticsServiceWithDelay(statisticsService, provider.getSendFrequencyMs());
            }
        }, 1L, TimeUnit.MINUTES);
    }

    private static void runStatesLogging() {
        if (!StatisticsUploadAssistant.isSendAllowed()) {
            return;
        }
        JobScheduler.getScheduler().scheduleWithFixedDelay(() -> FUStateUsagesLogger.create().logApplicationStates(), 15L, 1440L, TimeUnit.MINUTES);
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                ScheduledFuture<?> future = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> FUStateUsagesLogger.create().logProjectStates(project, (ProgressIndicator)new EmptyProgressIndicator()), 30L, 720L, TimeUnit.MINUTES);
                myPersistStatisticsSessionsMap.put(project, future);
            }

            public void projectClosed(@NotNull Project project) {
                Future future = (Future)myPersistStatisticsSessionsMap.remove(project);
                if (future != null) {
                    future.cancel(true);
                }
            }
        });
    }

    private static void runStatisticsServiceWithDelay(@NotNull StatisticsService statisticsService, long delayInMs) {
        JobScheduler.getScheduler().scheduleWithFixedDelay(() -> ((StatisticsService)statisticsService).send(), 300000L, delayInMs, TimeUnit.MILLISECONDS);
    }
}

