/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.persistence;

import com.intellij.analytics.AndroidStudioAnalytics;
import com.intellij.ide.ConsentOptionsProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="UsagesStatistic", storages={@Storage(value="usage.statistics.xml", roamingType=RoamingType.DISABLED)}, reportStatistic=false)
@Service
public final class UsageStatisticsPersistenceComponent
implements PersistentStateComponent<Element> {
    public static final String USAGE_STATISTICS_XML = "usage.statistics.xml";
    private boolean isAllowedForEAP = true;
    private boolean isShowNotification = true;
    private static final String LAST_TIME_ATTR = "time";
    private static final String IS_ALLOWED_ATTR = "allowed";
    private static final String IS_ALLOWED_EAP_ATTR = "allowedEap";
    private static final String SHOW_NOTIFICATION_ATTR = "show-notification";
    private static final String SYSTEM_EVENT_ATTR = "system-event-id";
    private static final String EVENT_ID_ATTR = "id";
    private static final String RECORDER_ATTR = "recorder";
    private long mySentTime = 0L;
    private final Map<String, Long> myRecorderToSystemEventIds = new HashMap<String, Long>();

    public long getLastTimeSent() {
        return this.mySentTime;
    }

    public void setSentTime(long time) {
        this.mySentTime = time;
    }

    public static UsageStatisticsPersistenceComponent getInstance() {
        return (UsageStatisticsPersistenceComponent)ApplicationManager.getApplication().getService(UsageStatisticsPersistenceComponent.class);
    }

    public void loadState(@NotNull Element element) {
        String isShowNotificationValue;
        ConsentOptionsProvider options;
        try {
            this.setSentTime(Long.parseLong(element.getAttributeValue(LAST_TIME_ATTR, "0")));
        }
        catch (NumberFormatException e) {
            this.setSentTime(0L);
        }
        String isAllowedEapValue = element.getAttributeValue(IS_ALLOWED_EAP_ATTR, "true");
        this.isAllowedForEAP = StringUtil.isEmptyOrSpaces((String)isAllowedEapValue) || Boolean.parseBoolean(isAllowedEapValue);
        String isAllowedValue = element.getAttributeValue(IS_ALLOWED_ATTR);
        if (!StringUtil.isEmptyOrSpaces((String)isAllowedValue) && Boolean.parseBoolean(isAllowedValue) && (options = UsageStatisticsPersistenceComponent.getConsentOptionsProvider()) != null) {
            options.setSendingUsageStatsAllowed(true);
        }
        this.setShowNotification(StringUtil.isEmptyOrSpaces((String)(isShowNotificationValue = element.getAttributeValue(SHOW_NOTIFICATION_ATTR))) || Boolean.parseBoolean(isShowNotificationValue));
        this.myRecorderToSystemEventIds.clear();
        for (Element path : element.getChildren(SYSTEM_EVENT_ATTR)) {
            String recorder = path.getAttributeValue(RECORDER_ATTR);
            if (!StringUtil.isNotEmpty((String)recorder)) continue;
            try {
                long eventId = Long.parseLong(path.getAttributeValue(EVENT_ID_ATTR, "0"));
                this.myRecorderToSystemEventIds.put(recorder, eventId);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public Element getState() {
        Element element = new Element("state");
        long lastTimeSent = this.getLastTimeSent();
        if (lastTimeSent > 0L) {
            element.setAttribute(LAST_TIME_ATTR, String.valueOf(lastTimeSent));
        }
        if (!this.isShowNotification()) {
            element.setAttribute(SHOW_NOTIFICATION_ATTR, "false");
        }
        if (!this.isAllowedForEAP) {
            element.setAttribute(IS_ALLOWED_EAP_ATTR, "false");
        }
        for (Map.Entry<String, Long> entry : this.myRecorderToSystemEventIds.entrySet()) {
            Element event = new Element(SYSTEM_EVENT_ATTR);
            event.setAttribute(RECORDER_ATTR, entry.getKey());
            event.setAttribute(EVENT_ID_ATTR, String.valueOf(entry.getValue()));
            element.addContent(event);
        }
        return element;
    }

    public void setAllowed(boolean allowed) {
        ConsentOptionsProvider options = UsageStatisticsPersistenceComponent.getConsentOptionsProvider();
        if (options != null) {
            if (options.isEAP()) {
                this.isAllowedForEAP = allowed;
            } else {
                options.setSendingUsageStatsAllowed(allowed);
            }
        }
    }

    public boolean isAllowed() {
        return AndroidStudioAnalytics.getInstance().isAllowed();
    }

    public void setShowNotification(boolean showNotification) {
        this.isShowNotification = showNotification;
    }

    public boolean isShowNotification() {
        return this.isShowNotification && !ApplicationManager.getApplication().isInternal();
    }

    @Nullable
    public static ConsentOptionsProvider getConsentOptionsProvider() {
        return (ConsentOptionsProvider)ServiceManager.getService(ConsentOptionsProvider.class);
    }

    public long getEventId(@NotNull String recorderId) {
        Long eventId = this.myRecorderToSystemEventIds.get(recorderId);
        return eventId != null ? eventId : 0L;
    }

    public void setEventId(@NotNull String recorderId, long eventId) {
        this.myRecorderToSystemEventIds.put(recorderId, eventId);
    }
}

