/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.whitelist;

import com.intellij.internal.statistic.eventLog.EventLogConnectionSettings;
import com.intellij.internal.statistic.eventLog.EventLogUploadSettingsService;
import com.intellij.internal.statistic.eventLog.whitelist.EventLogMetadataLoader;
import com.intellij.internal.statistic.service.fus.EventLogMetadataLoadException;
import com.intellij.internal.statistic.service.fus.StatisticsWhitelistLoader;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class EventLogServerWhitelistLoader
implements EventLogMetadataLoader {
    @NotNull
    private final EventLogUploadSettingsService mySettingsService;

    public EventLogServerWhitelistLoader(@NotNull String recorderId) {
        this.mySettingsService = StatisticsUploadAssistant.createExternalSettings(recorderId, false, TimeUnit.HOURS.toMillis(1L));
    }

    @Override
    public long getLastModifiedOnServer() {
        EventLogConnectionSettings settings = this.mySettingsService.getApplicationInfo().getConnectionSettings();
        return StatisticsWhitelistLoader.lastModifiedWhitelist((String)this.mySettingsService.getWhiteListProductUrl(), (EventLogConnectionSettings)settings);
    }

    @Override
    @NotNull
    public String loadMetadataFromServer() throws EventLogMetadataLoadException {
        EventLogConnectionSettings settings = this.mySettingsService.getApplicationInfo().getConnectionSettings();
        return StatisticsWhitelistLoader.loadWhiteListFromServer((String)this.mySettingsService.getWhiteListProductUrl(), (EventLogConnectionSettings)settings);
    }
}

