/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.whitelist;

import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupRules;
import com.intellij.internal.statistic.eventLog.whitelist.WhitelistGroupRulesStorage;
import com.intellij.internal.statistic.eventLog.whitelist.WhitelistTestGroupStorage;
import com.intellij.internal.statistic.eventLog.whitelist.WhitelistTestRulesStorageHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeWhitelistStorage
implements WhitelistGroupRulesStorage,
WhitelistTestRulesStorageHolder {
    @NotNull
    private final WhitelistGroupRulesStorage myWhitelistStorage;
    @NotNull
    private final WhitelistTestGroupStorage myWhitelistTestGroupStorage;

    CompositeWhitelistStorage(@NotNull WhitelistGroupRulesStorage whitelistStorage, @NotNull WhitelistTestGroupStorage testWhitelistStorage) {
        this.myWhitelistStorage = whitelistStorage;
        this.myWhitelistTestGroupStorage = testWhitelistStorage;
    }

    @Override
    @Nullable
    public EventGroupRules getGroupRules(@NotNull String groupId) {
        EventGroupRules testGroupRules = this.myWhitelistTestGroupStorage.getGroupRules(groupId);
        if (testGroupRules != null) {
            return testGroupRules;
        }
        return this.myWhitelistStorage.getGroupRules(groupId);
    }

    @Override
    public boolean isUnreachableWhitelist() {
        return this.myWhitelistStorage.isUnreachableWhitelist() && this.myWhitelistTestGroupStorage.isUnreachableWhitelist();
    }

    @Override
    public void update() {
        this.myWhitelistStorage.update();
        this.myWhitelistTestGroupStorage.update();
    }

    @Override
    public void reload() {
        this.myWhitelistStorage.reload();
        this.myWhitelistTestGroupStorage.reload();
    }

    @Override
    @NotNull
    public WhitelistTestGroupStorage getTestGroupStorage() {
        return this.myWhitelistTestGroupStorage;
    }
}

