/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.whitelist;

import com.intellij.internal.statistic.eventLog.EventLogBuild;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupRules;
import com.intellij.internal.statistic.eventLog.whitelist.WhitelistGroupRulesStorage;
import com.intellij.internal.statistic.service.fus.FUStatisticsWhiteListGroupsService;
import com.intellij.internal.statistic.service.fus.StatisticsWhitelistGroupConditions;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseWhitelistStorage
implements WhitelistGroupRulesStorage {
    @NotNull
    protected final AtomicBoolean isWhiteListInitialized = new AtomicBoolean(false);

    protected BaseWhitelistStorage() {
    }

    @Override
    public boolean isUnreachableWhitelist() {
        return !this.isWhiteListInitialized.get();
    }

    @NotNull
    protected Map<String, EventGroupRules> createValidators(@Nullable EventLogBuild build2, @NotNull FUStatisticsWhiteListGroupsService.WLGroups groups) {
        return groups.groups.stream().filter(group -> StatisticsWhitelistGroupConditions.create((FUStatisticsWhiteListGroupsService.WLGroup)group).accepts(build2)).collect(Collectors.toMap(group -> group.id, group -> BaseWhitelistStorage.createRules(group, groups.rules)));
    }

    @NotNull
    protected static EventGroupRules createRules(@NotNull FUStatisticsWhiteListGroupsService.WLGroup group, @Nullable FUStatisticsWhiteListGroupsService.WLRule globalRules) {
        return globalRules != null ? EventGroupRules.create(group, globalRules.enums, globalRules.regexps) : EventGroupRules.create(group, null, null);
    }
}

