/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.impl;

import com.intellij.internal.statistic.eventLog.StatisticsEventEscaper;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRegexpAwareRule;
import com.intellij.internal.statistic.eventLog.validator.rules.PerformanceCareRule;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegexpValidationRule
extends PerformanceCareRule
implements FUSRegexpAwareRule {
    private final NullableLazyValue<Pattern> myPattern;
    @Nullable
    private final String myRegexp;
    private static final List<String> ESCAPE_FROM = Arrays.asList("\\", "[", "]", "{", "}", "(", ")", "-", "^", "*", "+", "?", ".", "|", "$");
    private static final List<String> ESCAPE_TO = ContainerUtil.map(ESCAPE_FROM, s -> "\\" + s);

    public RegexpValidationRule(final @Nullable String regexp) {
        this.myPattern = regexp == null ? null : new NullableLazyValue<Pattern>(){

            @Nullable
            protected Pattern compute() {
                try {
                    return Pattern.compile(regexp);
                }
                catch (Exception ignored) {
                    return null;
                }
            }
        };
        this.myRegexp = regexp;
    }

    @Override
    @NotNull
    public ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
        Pattern pattern = (Pattern)this.myPattern.getValue();
        if (pattern == null) {
            return ValidationResultType.INCORRECT_RULE;
        }
        return pattern.matcher(StatisticsEventEscaper.escape((String)data)).matches() ? ValidationResultType.ACCEPTED : ValidationResultType.REJECTED;
    }

    @Override
    @NotNull
    public String asRegexp() {
        return this.myRegexp != null ? this.myRegexp : "<invalid>";
    }

    public String toString() {
        return "RegexpValidationRule: myRegexp=" + this.asRegexp();
    }

    public static String escapeText(@NotNull String text) {
        return StringUtil.replace((String)text, ESCAPE_FROM, ESCAPE_TO);
    }
}

