/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.fus;

import com.intellij.concurrency.JobScheduler;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.collectors.fus.os.OsVersionUsageCollector;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.fus.FeatureUsageLogger;
import com.intellij.internal.statistic.eventLog.fus.FeatureUsageStateEventTracker;
import com.intellij.internal.statistic.service.fus.collectors.FUStateUsagesLogger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.util.lang.JavaVersion;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u000bH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/internal/statistic/eventLog/fus/SystemStateMonitor;", "Lcom/intellij/internal/statistic/eventLog/fus/FeatureUsageStateEventTracker;", "()V", "INITIAL_DELAY", "", "JAVA_GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getJAVA_GROUP$annotations", "OS_GROUP", "PERIOD_DELAY", "getJavaVendor", "", "getOSName", "initialize", "", "newDataWithOsVersion", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "reportNow", "intellij.platform.statistics"})
public final class SystemStateMonitor
implements FeatureUsageStateEventTracker {
    private final EventLogGroup OS_GROUP = new EventLogGroup("system.os", 3);
    private final EventLogGroup JAVA_GROUP = new EventLogGroup("system.java", 1);
    private final int INITIAL_DELAY;
    private final int PERIOD_DELAY;

    @Deprecated(message="This group will be removed in 2019.3 because the same information is recorded in SystemRuntimeCollector")
    private static /* synthetic */ void getJAVA_GROUP$annotations() {
    }

    @Override
    public void initialize() {
        if (!FeatureUsageLogger.INSTANCE.isEnabled()) {
            return;
        }
        JobScheduler.getScheduler().scheduleWithFixedDelay(new Runnable(this){
            final /* synthetic */ SystemStateMonitor this$0;

            public final void run() {
                this.this$0.reportNow();
            }
            {
                this.this$0 = systemStateMonitor;
            }
        }, this.INITIAL_DELAY, this.PERIOD_DELAY, TimeUnit.MINUTES);
    }

    @Override
    public void reportNow() {
        FeatureUsageData data = new FeatureUsageData().addVersion(new Version(1, JavaVersion.current().feature, 0));
        FUStateUsagesLogger.logStateEvent(this.JAVA_GROUP, this.getJavaVendor(), data);
        List osEvents = new ArrayList();
        FeatureUsageData dataOS = this.newDataWithOsVersion();
        osEvents.add(MetricEventFactoryKt.newMetric(this.getOSName(), dataOS));
        osEvents.add(MetricEventFactoryKt.newMetric("os.name", dataOS.copy().addData("name", this.getOSName())));
        ZoneOffset currentZoneOffset = OffsetDateTime.now().getOffset();
        FeatureUsageData currentZoneOffsetFeatureUsageData = new FeatureUsageData().addData("value", currentZoneOffset.toString());
        osEvents.add(MetricEventFactoryKt.newMetric("os.timezone", currentZoneOffsetFeatureUsageData));
        FUStateUsagesLogger.logStateEvents(this.OS_GROUP, osEvents);
    }

    private final FeatureUsageData newDataWithOsVersion() {
        FeatureUsageData osData = new FeatureUsageData();
        if (SystemInfo.isLinux) {
            OsVersionUsageCollector.LinuxRelease linuxRelease = OsVersionUsageCollector.getLinuxRelease();
            osData.addData("release", linuxRelease.getRelease());
            osData.addVersionByString(linuxRelease.getVersion());
        } else {
            osData.addVersion(OsVersionUsageCollector.parse(SystemInfo.OS_VERSION));
        }
        return osData;
    }

    private final String getOSName() {
        return SystemInfo.isLinux ? "Linux" : (SystemInfo.isMac ? "Mac" : (SystemInfo.isWindows ? "Windows" : (SystemInfo.isFreeBSD ? "FreeBSD" : (SystemInfo.isSolaris ? "Solaris" : "Other"))));
    }

    private final String getJavaVendor() {
        return SystemInfo.isJetBrainsJvm ? "JetBrains" : (SystemInfo.isAppleJvm ? "Apple" : (SystemInfo.isOracleJvm ? "Oracle" : (SystemInfo.isSunJvm ? "Sun" : (SystemInfo.isIbmJvm ? "IBM" : (SystemInfo.isAzulJvm ? "Azul" : "Other")))));
    }

    public SystemStateMonitor() {
        this.PERIOD_DELAY = 1440;
    }
}

