/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.DefaultEventLogFilesProvider;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogFile;
import com.intellij.internal.statistic.eventLog.EventLogFilesProvider;
import com.intellij.internal.statistic.eventLog.LogEvent;
import com.intellij.internal.statistic.eventLog.LogEventSerializer;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogFileAppender;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u000eH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogFileWriter;", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogWriter;", "recorderId", "", "maxFileSize", "isEap", "", "prefix", "(Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;)V", "eventLogger", "Lorg/apache/log4j/Logger;", "fileAppender", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogFileAppender;", "cleanup", "", "getActiveFile", "Lcom/intellij/internal/statistic/eventLog/EventLogFile;", "getEventLogDir", "Ljava/nio/file/Path;", "getLogFilesProvider", "Lcom/intellij/internal/statistic/eventLog/EventLogFilesProvider;", "log", "logEvent", "Lcom/intellij/internal/statistic/eventLog/LogEvent;", "rollOver", "intellij.platform.statistics"})
public final class StatisticsEventLogFileWriter
implements StatisticsEventLogWriter {
    private StatisticsEventLogFileAppender fileAppender;
    private final Logger eventLogger;
    private final String recorderId;
    private final String maxFileSize;

    private final Path getEventLogDir() {
        return EventLogConfiguration.INSTANCE.getEventLogDataPath().resolve("logs").resolve(this.recorderId);
    }

    @Override
    public void log(@NotNull LogEvent logEvent) {
        this.eventLogger.info((Object)LogEventSerializer.INSTANCE.toString(logEvent));
    }

    @Override
    @Nullable
    public EventLogFile getActiveFile() {
        Object object = this.fileAppender;
        if (object == null || (object = object.getActiveLogName()) == null) {
            return null;
        }
        Object activeLog = object;
        return new EventLogFile(new File(new File(this.getEventLogDir().toUri()), (String)activeLog));
    }

    @Override
    @NotNull
    public EventLogFilesProvider getLogFilesProvider() {
        return (EventLogFilesProvider)new DefaultEventLogFilesProvider(this.getEventLogDir(), (Function0)new Function0<String>(this){
            final /* synthetic */ StatisticsEventLogFileWriter this$0;

            @Nullable
            public final String invoke() {
                StatisticsEventLogFileAppender statisticsEventLogFileAppender = StatisticsEventLogFileWriter.access$getFileAppender$p(this.this$0);
                return statisticsEventLogFileAppender != null ? statisticsEventLogFileAppender.getActiveLogName() : null;
            }
            {
                this.this$0 = statisticsEventLogFileWriter;
                super(0);
            }
        });
    }

    @Override
    public void cleanup() {
        block0: {
            StatisticsEventLogFileAppender statisticsEventLogFileAppender = this.fileAppender;
            if (statisticsEventLogFileAppender == null) break block0;
            statisticsEventLogFileAppender.cleanUp();
        }
    }

    @Override
    public void rollOver() {
        block0: {
            StatisticsEventLogFileAppender statisticsEventLogFileAppender = this.fileAppender;
            if (statisticsEventLogFileAppender == null) break block0;
            statisticsEventLogFileAppender.rollOver();
        }
    }

    public StatisticsEventLogFileWriter(@NotNull String recorderId, @NotNull String maxFileSize, boolean isEap, @NotNull String prefix) {
        this.recorderId = recorderId;
        this.maxFileSize = maxFileSize;
        this.eventLogger = Logger.getLogger((String)("event.logger." + this.recorderId));
        this.eventLogger.setLevel(Level.INFO);
        this.eventLogger.setAdditivity(false);
        PatternLayout pattern = new PatternLayout("%m\n");
        try {
            Path dir = this.getEventLogDir();
            StatisticsEventLogFileAppender statisticsEventLogFileAppender = this.fileAppender = StatisticsEventLogFileAppender.create((Layout)pattern, dir, prefix, isEap);
            if (statisticsEventLogFileAppender != null) {
                StatisticsEventLogFileAppender statisticsEventLogFileAppender2 = statisticsEventLogFileAppender;
                boolean bl = false;
                boolean bl2 = false;
                StatisticsEventLogFileAppender appender = statisticsEventLogFileAppender2;
                boolean bl3 = false;
                appender.setMaxFileSize(this.maxFileSize);
                this.eventLogger.addAppender((Appender)appender);
            }
        }
        catch (IOException e) {
            System.err.println("Unable to initialize logging for feature usage: " + e.getLocalizedMessage());
        }
    }

    public static final /* synthetic */ StatisticsEventLogFileAppender access$getFileAppender$p(StatisticsEventLogFileWriter $this) {
        return $this.fileAppender;
    }

    public static final /* synthetic */ void access$setFileAppender$p(StatisticsEventLogFileWriter $this, StatisticsEventLogFileAppender statisticsEventLogFileAppender) {
        $this.fileAppender = statisticsEventLogFileAppender;
    }
}

