/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.EventLogBuildType;
import com.intellij.internal.statistic.eventLog.EventLogFile;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Supplier;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.CountingQuietWriter;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggingEvent;
import org.jetbrains.annotations.NotNull;

public class StatisticsEventLogFileAppender
extends FileAppender {
    protected long maxFileAge = 604800000L;
    protected long maxFileSize = 0xA00000L;
    private long nextRollover = 0L;
    protected long oldestExistingFile = -1L;
    private final String mySuffix;
    private final EventLogBuildType myBuildType;
    private final Path myLogDirectory;
    private final Supplier<List<File>> myFilesProducer;

    public StatisticsEventLogFileAppender(@NotNull Path path, @NotNull List<File> files) {
        this.mySuffix = "";
        this.myBuildType = EventLogBuildType.EAP;
        this.myLogDirectory = path;
        this.myFilesProducer = () -> files;
    }

    public StatisticsEventLogFileAppender(@NotNull Layout layout, @NotNull Path dir, @NotNull String suffix, @NotNull EventLogBuildType buildType, @NotNull String filename) throws IOException {
        super(layout, filename);
        this.mySuffix = suffix;
        this.myBuildType = buildType;
        this.myLogDirectory = dir;
        this.myFilesProducer = () -> {
            Object[] files = dir.toFile().listFiles();
            return files == null || files.length == 0 ? ContainerUtil.emptyList() : ContainerUtil.newArrayList((Object[])files);
        };
        this.cleanUpOldFiles();
    }

    public static StatisticsEventLogFileAppender create(@NotNull Layout layout, @NotNull Path dir, @NotNull String suffix, boolean isEap) throws IOException {
        EventLogBuildType buildType = isEap ? EventLogBuildType.EAP : EventLogBuildType.RELEASE;
        EventLogFile logFile = EventLogFile.create((Path)dir, (EventLogBuildType)buildType, (String)suffix);
        return new StatisticsEventLogFileAppender(layout, dir, suffix, buildType, logFile.getFile().getPath());
    }

    @NotNull
    public String getActiveLogName() {
        return StringUtil.isNotEmpty((String)this.fileName) ? PathUtil.getFileName((String)this.fileName) : "";
    }

    public void setMaxFileAge(long maxAge) {
        this.maxFileAge = maxAge;
    }

    public void setMaxFileSize(String value) {
        this.maxFileSize = OptionConverter.toFileSize((String)value, (long)(this.maxFileSize + 1L));
    }

    @NotNull
    protected CountingQuietWriter getQuietWriter() {
        return (CountingQuietWriter)this.qw;
    }

    protected void setQWForFiles(Writer writer) {
        this.qw = new CountingQuietWriter(writer, this.errorHandler);
    }

    public synchronized void setFile(String fileName, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        super.setFile(fileName, append, bufferedIO, bufferSize);
        if (append && this.qw instanceof CountingQuietWriter) {
            File f = new File(fileName);
            this.getQuietWriter().setCount(f.length());
        }
    }

    protected void subAppend(LoggingEvent event) {
        long size;
        super.subAppend(event);
        if (this.fileName != null && this.qw != null && (size = this.getQuietWriter().getCount()) >= this.maxFileSize && size >= this.nextRollover) {
            this.rollOver();
            this.cleanUpOldFiles();
        }
    }

    public void rollOver() {
        this.nextRollover = this.getQuietWriter().getCount() + this.maxFileSize;
        try {
            EventLogFile logFile = EventLogFile.create((Path)this.myLogDirectory, (EventLogBuildType)this.myBuildType, (String)this.mySuffix);
            this.setFile(logFile.getFile().getPath(), false, this.bufferedIO, this.bufferSize);
            this.nextRollover = 0L;
        }
        catch (InterruptedIOException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LogLog.error((String)("setFile(" + this.fileName + ", false) call failed."), (Throwable)e);
        }
    }

    protected void cleanUpOldFiles() {
        long oldestAcceptable = System.currentTimeMillis() - this.maxFileAge;
        if (this.oldestExistingFile != -1L && oldestAcceptable < this.oldestExistingFile) {
            return;
        }
        this.cleanUpOldFiles(oldestAcceptable);
    }

    protected void cleanUpOldFiles(long oldestAcceptable) {
        List<File> logs = this.myFilesProducer.get();
        if (logs == null || logs.isEmpty()) {
            return;
        }
        String activeLog = this.getActiveLogName();
        long oldestFile = -1L;
        for (File file : logs) {
            if (StringUtil.equals((CharSequence)file.getName(), (CharSequence)activeLog)) continue;
            long lastModified = file.lastModified();
            if (lastModified < oldestAcceptable) {
                if (file.delete()) continue;
                LogLog.error((String)("Failed deleting old file " + file));
                continue;
            }
            if (lastModified >= oldestFile && oldestFile != -1L) continue;
            oldestFile = lastModified;
        }
        this.oldestExistingFile = oldestFile;
    }

    public void cleanUp() {
        List<File> logs = this.myFilesProducer.get();
        if (logs == null || logs.isEmpty()) {
            return;
        }
        for (File file : logs) {
            if (file.delete()) continue;
            LogLog.error((String)("Failed deleting old file " + file));
        }
        this.rollOver();
    }
}

