/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus;

import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.PluginType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassNameRuleValidator
extends CustomValidationRule {
    @Override
    public boolean acceptRuleId(@Nullable String ruleId) {
        return "dialog_class".equals(ruleId) || "quick_fix_class_name".equals(ruleId) || "class_name".equals(ruleId);
    }

    @Override
    @NotNull
    protected ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
        if (ClassNameRuleValidator.isThirdPartyValue(data)) {
            return ValidationResultType.ACCEPTED;
        }
        PluginInfo info = PluginInfoDetectorKt.getPluginInfo(data);
        context.setPluginInfo(info);
        if (info.getType() == PluginType.UNKNOWN) {
            return ValidationResultType.REJECTED;
        }
        return info.isSafeToReport() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
    }
}

