/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.EditorTextProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.debugger.KotlinEditorTextProvider;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgumentName;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.scopes.receivers.Qualifier;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/KotlinEditorTextProvider;", "Lcom/intellij/debugger/impl/EditorTextProvider;", "()V", "findExpression", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/openapi/util/TextRange;", "elementAtCaret", "allowMethodCalls", "", "getEditorText", "Lcom/intellij/debugger/engine/evaluation/TextWithImports;", "Companion", "kotlin.jvm-debugger.util"})
public final class KotlinEditorTextProvider
implements EditorTextProvider {
    private static final Class<? extends KtElementImplStub<? extends StubElement<? extends KtElementImplStub<?>>>>[] NOT_ACCEPTED_AS_CONTEXT_TYPES;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public TextWithImports getEditorText(@NotNull PsiElement elementAtCaret) {
        Intrinsics.checkNotNullParameter((Object)elementAtCaret, (String)"elementAtCaret");
        KtExpression ktExpression = Companion.findExpressionInner(elementAtCaret, true);
        if (ktExpression == null) {
            return null;
        }
        KtExpression expression = ktExpression;
        String expressionText2 = (String)Companion.getElementInfo(expression, getEditorText.expressionText.1.INSTANCE);
        return (TextWithImports)new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, expressionText2, "", (FileType)KotlinFileType.INSTANCE);
    }

    @Nullable
    public Pair<PsiElement, TextRange> findExpression(@NotNull PsiElement elementAtCaret, boolean allowMethodCalls) {
        Intrinsics.checkNotNullParameter((Object)elementAtCaret, (String)"elementAtCaret");
        KtExpression ktExpression = Companion.findExpressionInner(elementAtCaret, allowMethodCalls);
        if (ktExpression == null) {
            return null;
        }
        KtExpression expression = ktExpression;
        TextRange expressionRange2 = (TextRange)Companion.getElementInfo(expression, findExpression.expressionRange.1.INSTANCE);
        return new Pair((Object)expression, (Object)expressionRange2);
    }

    static {
        Companion = new Companion(null);
        NOT_ACCEPTED_AS_CONTEXT_TYPES = new Class[]{KtUserType.class, KtImportDirective.class, KtPackageDirective.class, KtValueArgumentName.class};
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ-\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u0002H\u00110\u0014\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rR^\u0010\u0003\u001aP\u0012L\u0012J\u0012F\b\u0001\u0012B\u0012>\b\u0001\u0012:\u0012\u0016\b\u0001\u0012\u0012\u0012\u0002\b\u0003 \b*\b\u0012\u0002\b\u0003\u0018\u00010\u00060\u0006 \b*\u001c\u0012\u0016\b\u0001\u0012\u0012\u0012\u0002\b\u0003 \b*\b\u0012\u0002\b\u0003\u0018\u00010\u00060\u0006\u0018\u00010\u00070\u00070\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/KotlinEditorTextProvider$Companion;", "", "()V", "NOT_ACCEPTED_AS_CONTEXT_TYPES", "", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/psi/KtElementImplStub;", "Lcom/intellij/psi/stubs/StubElement;", "kotlin.jvm.PlatformType", "[Ljava/lang/Class;", "findExpressionInner", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "Lcom/intellij/psi/PsiElement;", "allowMethodCalls", "", "getElementInfo", "T", "expr", "f", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "isAcceptedAsCodeFragmentContext", "kotlin.jvm-debugger.util"})
    public static final class Companion {
        public final <T> T getElementInfo(@NotNull KtExpression expr, @NotNull Function1<? super PsiElement, ? extends T> f) {
            PsiElement nameIdentifier;
            Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
            Intrinsics.checkNotNullParameter(f, (String)"f");
            Object expressionText2 = f.invoke((Object)expr);
            if (expr instanceof KtProperty && (nameIdentifier = ((KtProperty)expr).getNameIdentifier()) != null) {
                expressionText2 = f.invoke((Object)nameIdentifier);
            }
            return (T)expressionText2;
        }

        @Nullable
        public final KtExpression findExpressionInner(@NotNull PsiElement element, boolean allowMethodCalls) {
            BindingContext context;
            Qualifier qualifier;
            KtElement newExpression;
            KtElement ktElement;
            block6: {
                block7: {
                    PsiElement nameIdentifier;
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    if (!this.isAcceptedAsCodeFragmentContext(element)) {
                        return null;
                    }
                    KtElement ktElement2 = (KtElement)PsiTreeUtil.getParentOfType((PsiElement)element, KtElement.class);
                    if (ktElement2 == null) {
                        return null;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)ktElement2, (String)"PsiTreeUtil.getParentOfT\u2026lass.java) ?: return null");
                    ktElement = ktElement2;
                    if (ktElement instanceof KtProperty && Intrinsics.areEqual((Object)(nameIdentifier = ((KtProperty)ktElement).getNameIdentifier()), (Object)element)) {
                        return (KtExpression)ktElement;
                    }
                    findExpressionInner.1 $fun$qualifiedParentOrSelf$1 = findExpressionInner.1.INSTANCE;
                    PsiElement parent = ktElement.getParent();
                    PsiElement psiElement = parent;
                    KtElement ktElement3 = psiElement instanceof KtThisExpression ? (KtElement)parent : (psiElement instanceof KtSuperExpression ? (KtElement)$fun$qualifiedParentOrSelf$1.invoke((KtExpression)parent, false) : (psiElement instanceof KtArrayAccessExpression ? (Intrinsics.areEqual((Object)((KtArrayAccessExpression)parent).getArrayExpression(), (Object)ktElement) ? ktElement : (KtElement)findExpressionInner.1.invoke$default($fun$qualifiedParentOrSelf$1, (KtExpression)parent, false, 1, null)) : (psiElement instanceof KtReferenceExpression ? (KtElement)findExpressionInner.1.invoke$default($fun$qualifiedParentOrSelf$1, (KtExpression)parent, false, 1, null) : (psiElement instanceof KtQualifiedExpression ? (KtElement)(Intrinsics.areEqual((Object)((KtQualifiedExpression)parent).getReceiverExpression(), (Object)ktElement) ^ true ? (KtQualifiedExpression)parent : null) : (psiElement instanceof KtOperationExpression ? (KtElement)(Intrinsics.areEqual((Object)((KtOperationExpression)parent).getOperationReference(), (Object)ktElement) ? (KtOperationExpression)parent : null) : (newExpression = null))))));
                    if (allowMethodCalls || newExpression == null) break block6;
                    findExpressionInner.2 $fun$isCall$2 = findExpressionInner.2.INSTANCE;
                    if ($fun$isCall$2.invoke((PsiElement)newExpression)) break block7;
                    if (!(newExpression instanceof KtQualifiedExpression)) break block6;
                    KtExpression ktExpression = ((KtQualifiedExpression)newExpression).getSelectorExpression();
                    Intrinsics.checkNotNull((Object)ktExpression);
                    if (!$fun$isCall$2.invoke((PsiElement)ktExpression)) break block6;
                }
                return null;
            }
            return newExpression instanceof KtExpression ? (KtExpression)newExpression : (ktElement instanceof KtSimpleNameExpression ? (KtExpression)((qualifier = (Qualifier)(context = ResolutionUtils.analyze$default((KtElement)ktElement, null, (int)1, null)).get((ReadOnlySlice)BindingContext.QUALIFIER, (Object)ktElement)) != null && !DescriptorUtils.isObject((DeclarationDescriptor)qualifier.getDescriptor()) ? null : (KtSimpleNameExpression)ktElement) : null);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isAcceptedAsCodeFragmentContext(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Class<?> clazz = element.getClass();
            if (clazz == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<*>");
            }
            if (ArraysKt.contains((Object[])NOT_ACCEPTED_AS_CONTEXT_TYPES, clazz)) return false;
            Class[] classArray = NOT_ACCEPTED_AS_CONTEXT_TYPES;
            if (PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])Arrays.copyOf(classArray, classArray.length)) != null) return false;
            return true;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

