/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.samples;

import com.google.common.collect.Lists;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.templates.github.DownloadUtil;
import com.intellij.platform.templates.github.Outcome;
import com.intellij.platform.templates.github.ZipUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GithubRepoContents {
    private static final long CACHE_TIMEOUT_MS = 3600000L;
    private File rootFolder;
    private List<File> sampleRoots;
    private String errorMessage;
    private boolean cancelled = false;

    @NotNull
    public static GithubRepoContents download(@NotNull String url, @Nullable String branch, @Nullable File cacheDirectory) {
        URL parsedUrl;
        GithubRepoContents returnValue = new GithubRepoContents();
        if (cacheDirectory == null) {
            cacheDirectory = new File(FileUtil.getTempDirectory(), "github_cache");
        }
        if (branch == null || branch.trim().isEmpty()) {
            branch = "HEAD";
        }
        try {
            parsedUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            returnValue.errorMessage = "Malformed URL";
            return returnValue;
        }
        String repositoryName = "Github" + parsedUrl.getPath().replace('/', '-');
        final File outputFile = new File(cacheDirectory, repositoryName + ".zip");
        final String finalUrl = url + "/zipball/" + branch;
        File unzippedDir = new File(cacheDirectory, repositoryName);
        if (!unzippedDir.exists() || unzippedDir.lastModified() == 0L || System.currentTimeMillis() - unzippedDir.lastModified() > 3600000L) {
            FileUtil.delete((File)unzippedDir);
            try {
                Outcome outcome = DownloadUtil.provideDataWithProgressSynchronously(null, (String)"Downloading project from GitHub", (String)"Downloading zip archive${content-length} ...", (Callable)new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                        DownloadUtil.downloadAtomically((ProgressIndicator)progress, (String)finalUrl, (File)outputFile);
                        return outputFile;
                    }
                }, null);
                Exception e = outcome.getException();
                if (e != null) {
                    throw e;
                }
                if (outcome.isCancelled()) {
                    returnValue.cancelled = true;
                    return returnValue;
                }
                ZipUtil.unzip((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator(), (File)unzippedDir, (File)outputFile, null, null, (boolean)true);
            }
            catch (Exception e) {
                returnValue.errorMessage = "Could not download specified project from Github. Check the URL and branchname.\n\n" + e.getMessage();
                return returnValue;
            }
            outputFile.delete();
        }
        returnValue.rootFolder = unzippedDir;
        returnValue.sampleRoots = GithubRepoContents.findSamplesInDirectory(unzippedDir, true);
        return returnValue;
    }

    @NotNull
    private static List<File> findSamplesInDirectory(@NotNull File directory, boolean recursive) {
        File[] files;
        ArrayList samples = Lists.newArrayList();
        if (new File(directory, "build.gradle").exists() || new File(directory, "settings.gradle").exists() || new File(directory, "build.gradle.kts").exists() || new File(directory, "settings.gradle.kts").exists()) {
            samples.add(directory);
        }
        if (recursive && (files = directory.listFiles()) != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                samples.addAll(GithubRepoContents.findSamplesInDirectory(file, true));
            }
        }
        return samples;
    }

    private GithubRepoContents() {
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    public List<File> getSampleRoots() {
        return this.sampleRoots;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

