/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.appengine.gradle.notification;

import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.gct.studio.appengine.gradle.facet.AppEngineConfigurationProperties;
import com.google.gct.studio.appengine.gradle.facet.AppEngineGradleFacet;
import com.google.gct.studio.appengine.gradle.facet.AppEngineGradleFacetConfiguration;
import com.google.gct.studio.util.GctStudioBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import java.io.File;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppEngineStatusNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Logger LOG = Logger.getInstance(AppEngineStatusNotificationProvider.class);
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"appengine.sdk.status");
    @NotNull
    private final Project myProject;

    public AppEngineStatusNotificationProvider(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        AppEngineConfigurationProperties state;
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)this.myProject);
        if (module == null) {
            return null;
        }
        AppEngineGradleFacet facet = AppEngineGradleFacet.getInstance(module);
        if (facet != null && (state = ((AppEngineGradleFacetConfiguration)facet.getConfiguration()).getState()) != null && !new File(state.APPENGINE_SDKROOT).exists()) {
            return new DownloadSdkNotification(module);
        }
        return null;
    }

    private class DownloadSdkNotification
    extends EditorNotificationPanel {
        DownloadSdkNotification(Module module) {
            this.setText(GctStudioBundle.message("appengine.sdk.invalid", module.getName()));
            this.createActionLabel(GctStudioBundle.message("appengine.sdk.gradle.install", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    GradleBuildInvoker.getInstance((Project)AppEngineStatusNotificationProvider.this.myProject).executeTasks(Collections.singletonList("appengineDownloadSdk"));
                }
            });
            final VirtualFile buildFile = GradleUtil.getGradleBuildFile((Module)module);
            if (buildFile != null && buildFile.exists()) {
                this.createActionLabel(GctStudioBundle.message("appengine.sdk.open.gradle.build", new Object[0]), new Runnable(){

                    @Override
                    public void run() {
                        FileEditorManager.getInstance((Project)AppEngineStatusNotificationProvider.this.myProject).openFile(buildFile, true);
                    }
                });
            }
        }
    }
}

