/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.shellcheck.intention;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.sh.ShBundle;
import com.intellij.sh.statistics.ShFeatureUsagesCollector;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SuppressInspectionIntention
implements IntentionAction {
    @NonNls
    private static final String FEATURE_ACTION_ID = "SuppressInspectionUsed";
    private final String myInspectionCode;
    private final String myMessage;
    private final int myOffset;

    public SuppressInspectionIntention(String message, String inspectionCode, int offset) {
        this.myInspectionCode = inspectionCode;
        this.myMessage = message;
        this.myOffset = offset;
    }

    @NotNull
    public String getText() {
        return ShBundle.message("sh.suppress.inspection", this.myMessage);
    }

    @NotNull
    public String getFamilyName() {
        return ShBundle.message("sh.shell.script", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        Document document = editor.getDocument();
        int lineStartOffset = DocumentUtil.getLineStartOffset((int)this.myOffset, (Document)document);
        CharSequence indent = DocumentUtil.getIndent((Document)document, (int)lineStartOffset);
        document.insertString(lineStartOffset, (CharSequence)(indent + "# shellcheck disable=" + this.myInspectionCode + "\n"));
        ShFeatureUsagesCollector.logFeatureUsage(FEATURE_ACTION_ID);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

