/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.IndentInfo;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProvider;
import com.intellij.sh.ShFileType;
import com.intellij.sh.ShLanguage;
import com.intellij.sh.ShTypes;
import com.intellij.sh.formatter.ShSemanticEditorPosition;
import com.intellij.sh.lexer.ShTokenTypes;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShLineIndentProvider
implements LineIndentProvider {
    @Nullable
    public String getLineIndent(@NotNull Project project, @NotNull Editor editor, @Nullable Language language, int offset) {
        ShSemanticEditorPosition position;
        if (offset > 0 && ((position = ShLineIndentProvider.getPosition(editor, offset - 1)).isAt(ShTypes.LINEFEED) || position.isAt(ShTokenTypes.WHITESPACE))) {
            ShLineIndentProvider.moveAtEndOfPreviousLine(position);
            if (position.isAtAnyOf(ShTypes.DO, ShTypes.LEFT_CURLY, ShTypes.ELSE, ShTypes.THEN)) {
                return ShLineIndentProvider.getIndentString(editor, position.getStartOffset(), true);
            }
            if (position.isAt(ShTypes.CASE_END)) {
                return ShLineIndentProvider.getIndentString(editor, position.getStartOffset(), false);
            }
            if (ShLineIndentProvider.isInCasePattern(editor, position)) {
                return ShLineIndentProvider.getIndentString(editor, position.getStartOffset(), true);
            }
        }
        return null;
    }

    public boolean isSuitableFor(@Nullable Language language) {
        return language instanceof ShLanguage;
    }

    private static boolean isInCasePattern(@NotNull Editor editor, ShSemanticEditorPosition position) {
        CharSequence docChars = editor.getDocument().getCharsSequence();
        int lineStart = CharArrayUtil.shiftBackwardUntil((CharSequence)docChars, (int)position.getStartOffset(), (String)"\n") + 1;
        if (lineStart >= 0) {
            ShSemanticEditorPosition possiblePatternPosition = ShLineIndentProvider.getPosition(editor, lineStart);
            possiblePatternPosition.moveAfterOptionalMix(ShTokenTypes.WHITESPACE);
            possiblePatternPosition.moveAfterOptionalMix(ShTypes.WORD);
            possiblePatternPosition.moveAfterOptionalMix(ShTokenTypes.WHITESPACE);
            return possiblePatternPosition.isAt(ShTypes.RIGHT_PAREN);
        }
        return false;
    }

    private static void moveAtEndOfPreviousLine(ShSemanticEditorPosition position) {
        position.moveBeforeOptionalMix(ShTokenTypes.WHITESPACE);
        if (position.isAt(ShTypes.LINEFEED)) {
            position.moveBefore();
            position.moveBeforeOptionalMix(ShTokenTypes.WHITESPACE);
        }
    }

    @NotNull
    private static String getIndentString(@NotNull Editor editor, int offset, boolean shouldExpand) {
        int indentEnd;
        int diff;
        int indentStart;
        CodeStyleSettings settings = CodeStyle.getSettings((Editor)editor);
        CommonCodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptions((FileType)ShFileType.INSTANCE);
        CharSequence docChars = editor.getDocument().getCharsSequence();
        String baseIndent = "";
        if (offset > 0 && (indentStart = CharArrayUtil.shiftBackwardUntil((CharSequence)docChars, (int)offset, (String)"\n") + 1) >= 0 && (diff = (indentEnd = CharArrayUtil.shiftForward((CharSequence)docChars, (int)indentStart, (String)" \t")) - indentStart) > 0) {
            if (shouldExpand) {
                baseIndent = docChars.subSequence(indentStart, indentEnd).toString();
            } else if (diff >= indentOptions.INDENT_SIZE) {
                baseIndent = docChars.subSequence(indentStart, indentEnd - indentOptions.INDENT_SIZE).toString();
            }
        }
        if (shouldExpand) {
            baseIndent = baseIndent + new IndentInfo(0, indentOptions.INDENT_SIZE, 0).generateNewWhiteSpace(indentOptions);
        }
        return baseIndent;
    }

    private static ShSemanticEditorPosition getPosition(@NotNull Editor editor, int offset) {
        return ShSemanticEditorPosition.createEditorPosition((EditorEx)editor, offset);
    }
}

