/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.sh.codeInsight.ShFunctionReference;
import com.intellij.sh.psi.ShLiteral;
import com.intellij.sh.psi.ShString;
import com.intellij.sh.psi.ShVariable;
import com.intellij.sh.run.ShRunConfiguration;
import com.intellij.sh.run.ShRunConfigurationProfileState;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ShSupport {
    public static ShSupport getInstance() {
        return (ShSupport)ServiceManager.getService(ShSupport.class);
    }

    public boolean isExternalFormatterEnabled();

    public boolean isRenameEnabled();

    @NotNull
    public RunProfileState createRunProfileState(@NotNull Executor var1, @NotNull ExecutionEnvironment var2, @NotNull ShRunConfiguration var3);

    public PsiReference @NotNull [] getVariableReferences(@NotNull ShVariable var1);

    public PsiReference @NotNull [] getLiteralReferences(@NotNull ShLiteral var1);

    @Nullable
    public String getName(@NotNull ShLiteral var1);

    @Nullable
    public PsiElement getNameIdentifier(@NotNull ShLiteral var1);

    public static class Impl
    implements ShSupport {
        @Override
        public boolean isExternalFormatterEnabled() {
            return true;
        }

        @Override
        public boolean isRenameEnabled() {
            return true;
        }

        @Override
        @NotNull
        public RunProfileState createRunProfileState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment, @NotNull ShRunConfiguration configuration) {
            return new ShRunConfigurationProfileState(environment.getProject(), configuration);
        }

        @Override
        public PsiReference @NotNull [] getVariableReferences(@NotNull ShVariable v) {
            return PsiReference.EMPTY_ARRAY;
        }

        @Override
        public PsiReference @NotNull [] getLiteralReferences(@NotNull ShLiteral o) {
            return o instanceof ShString || o.getWord() != null ? (PsiReference[])ArrayUtil.prepend((Object)((Object)new ShFunctionReference(o)), (Object[])ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)o)) : PsiReference.EMPTY_ARRAY;
        }

        @Override
        @Nullable
        public String getName(@NotNull ShLiteral l) {
            return null;
        }

        @Override
        @Nullable
        public PsiElement getNameIdentifier(@NotNull ShLiteral l) {
            return null;
        }
    }
}

