/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java;

import com.intellij.util.lang.JavaVersion;
import org.jetbrains.annotations.NotNull;

public enum LanguageLevel {
    JDK_1_3(3),
    JDK_1_4(4),
    JDK_1_5(5),
    JDK_1_6(6),
    JDK_1_7(7),
    JDK_1_8(8),
    JDK_1_9(9),
    JDK_10(10),
    JDK_11(11),
    JDK_12(12),
    JDK_13(13),
    JDK_14(14),
    JDK_14_PREVIEW(14),
    JDK_15(15),
    JDK_15_PREVIEW(15),
    JDK_X(16);

    public static final LanguageLevel HIGHEST;
    private final JavaVersion myVersion;

    private LanguageLevel(int major) {
        this.myVersion = JavaVersion.compose((int)major);
    }

    @NotNull
    public JavaVersion toJavaVersion() {
        return this.myVersion;
    }

    public boolean isPreview() {
        return this.name().endsWith("_PREVIEW");
    }

    static {
        HIGHEST = JDK_14;
    }
}

