/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java;

import com.intellij.openapi.util.Bitness;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.lang.JavaVersion;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.service.JpsServiceManager;

public abstract class JdkVersionDetector {
    public static JdkVersionDetector getInstance() {
        return JpsServiceManager.getInstance().getService(JdkVersionDetector.class);
    }

    @Nullable
    public abstract JdkVersionInfo detectJdkVersionInfo(@NotNull String var1);

    @Nullable
    public abstract JdkVersionInfo detectJdkVersionInfo(@NotNull String var1, @NotNull ExecutorService var2);

    @NotNull
    public static String formatVersionString(@NotNull JavaVersion version) {
        return "java version \"" + version + '\"';
    }

    public static boolean isVersionString(@NotNull String string) {
        return string.length() >= 16 && string.startsWith("java version \"") && StringUtil.endsWithChar((CharSequence)string, (char)'\"');
    }

    public static final class JdkVersionInfo {
        public final JavaVersion version;
        public final Bitness bitness;

        public JdkVersionInfo(@NotNull JavaVersion version, @NotNull Bitness bitness) {
            this.version = version;
            this.bitness = bitness;
        }

        public String toString() {
            return this.version + " " + this.bitness;
        }
    }
}

