/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.history.ShortVcsRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.util.Function;
import com.intellij.util.ThrowableConvertor;
import com.intellij.vcsUtil.VcsRunnable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public class VcsUtil {
    protected static final char[] ourCharsToBeChopped = new char[]{'/', '\\'};
    private static final Logger LOG = Logger.getInstance(VcsUtil.class);
    public static final String MAX_VCS_LOADED_SIZE_KB = "idea.max.vcs.loaded.size.kb";
    private static final int ourMaxLoadedFileSize = VcsUtil.computeLoadedFileSize();
    private static final int MAX_COMMIT_MESSAGE_LENGTH = 50000;
    private static final int MAX_COMMIT_MESSAGE_LINES = 3000;
    private static final String ANNO_ASPECT = "show.vcs.annotation.aspect.";

    public static int getMaxVcsLoadedFileSize() {
        return ourMaxLoadedFileSize;
    }

    private static int computeLoadedFileSize() {
        long result = PersistentFSConstants.FILE_LENGTH_TO_CACHE_THRESHOLD;
        try {
            String userLimitKb = System.getProperty(MAX_VCS_LOADED_SIZE_KB);
            if (userLimitKb != null) {
                result = (long)Integer.parseInt(userLimitKb) * 1024L;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return (int)Math.min(result, Integer.MAX_VALUE);
    }

    @Deprecated
    public static void markFileAsDirty(Project project, VirtualFile file) {
        VcsDirtyScopeManager.getInstance(project).fileDirty(file);
    }

    @Deprecated
    public static void markFileAsDirty(Project project, FilePath path2) {
        VcsDirtyScopeManager.getInstance(project).fileDirty(path2);
    }

    public static void markFileAsDirty(Project project, String path2) {
        FilePath filePath2 = VcsContextFactory.SERVICE.getInstance().createFilePathOn(new File(path2));
        VcsDirtyScopeManager.getInstance(project).fileDirty(filePath2);
    }

    @Deprecated
    public static void refreshFiles(Project project, HashSet<? extends FilePath> paths) {
        for (FilePath filePath2 : paths) {
            VirtualFile vFile = filePath2.getVirtualFile();
            if (vFile == null) continue;
            if (vFile.isDirectory()) {
                VcsUtil.markFileAsDirty(project, vFile);
                continue;
            }
            vFile.refresh(true, vFile.isDirectory());
        }
    }

    public static boolean isFileUnderVcs(Project project, String file) {
        return VcsUtil.getVcsFor(project, VcsUtil.getFilePath(file)) != null;
    }

    public static boolean isFileUnderVcs(Project project, FilePath file) {
        return VcsUtil.getVcsFor(project, file) != null;
    }

    public static boolean isFileForVcs(@NotNull VirtualFile file, @NotNull Project project, @Nullable AbstractVcs host) {
        return VcsUtil.getVcsFor(project, file) == host;
    }

    public static boolean isFileForVcs(@NotNull FilePath path2, @NotNull Project project, @Nullable AbstractVcs host) {
        return VcsUtil.getVcsFor(project, path2) == host;
    }

    public static boolean isFileForVcs(String path2, Project project, AbstractVcs host) {
        return VcsUtil.getVcsFor(project, VcsUtil.getFilePath(path2)) == host;
    }

    @Nullable
    public static AbstractVcs getVcsFor(@NotNull Project project, FilePath filePath2) {
        return (AbstractVcs)VcsUtil.computeValue(project, manager -> manager.getVcsFor(filePath2));
    }

    @Nullable
    public static AbstractVcs getVcsFor(@NotNull Project project, @NotNull VirtualFile file) {
        return (AbstractVcs)VcsUtil.computeValue(project, manager -> manager.getVcsFor(file));
    }

    @Nullable
    public static AbstractVcs findVcsByKey(@NotNull Project project, @NotNull VcsKey key) {
        return ProjectLevelVcsManager.getInstance(project).findVcsByName(key.getName());
    }

    @Nullable
    public static AbstractVcs findVcs(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        VcsKey key = e.getData(VcsDataKeys.VCS);
        if (key == null) {
            return null;
        }
        return VcsUtil.findVcsByKey(project, key);
    }

    @Nullable
    public static VirtualFile getVcsRootFor(@NotNull Project project, FilePath filePath2) {
        return (VirtualFile)VcsUtil.computeValue(project, manager -> manager.getVcsRootFor(filePath2));
    }

    @Nullable
    public static VirtualFile getVcsRootFor(@NotNull Project project, @Nullable VirtualFile file) {
        return (VirtualFile)VcsUtil.computeValue(project, manager -> manager.getVcsRootFor(file));
    }

    @Nullable
    private static <T> T computeValue(@NotNull Project project, @NotNull Function<? super ProjectLevelVcsManager, ? extends T> provider) {
        return ReadAction.compute(() -> {
            Object result = null;
            if (!project.isDisposed()) {
                ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance(project);
                result = manager != null ? provider.fun((Object)manager) : null;
            }
            return result;
        });
    }

    @Nullable
    public static VirtualFile getVirtualFile(@NotNull String path2) {
        return (VirtualFile)ReadAction.compute(() -> LocalFileSystem.getInstance().findFileByPath(path2.replace(File.separatorChar, '/')));
    }

    @Nullable
    public static VirtualFile getVirtualFile(@NotNull File file) {
        return (VirtualFile)ReadAction.compute(() -> LocalFileSystem.getInstance().findFileByIoFile(file));
    }

    @Nullable
    public static VirtualFile getVirtualFileWithRefresh(File file) {
        if (file == null) {
            return null;
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile result = lfs.findFileByIoFile(file);
        if (result == null) {
            result = lfs.refreshAndFindFileByIoFile(file);
        }
        return result;
    }

    public static String getFileContent(@NotNull String path2) {
        return (String)ReadAction.compute(() -> {
            VirtualFile vFile = VcsUtil.getVirtualFile(path2);
            assert (vFile != null);
            return FileDocumentManager.getInstance().getDocument(vFile).getText();
        });
    }

    public static byte @Nullable [] getFileByteContent(@NotNull File file) {
        try {
            return FileUtil.loadFileBytes((File)file);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    @NotNull
    public static FilePath getFilePath(@NotNull String path2) {
        return VcsUtil.getFilePath(new File(path2));
    }

    @NotNull
    public static FilePath getFilePath(@NotNull VirtualFile file) {
        return VcsContextFactory.SERVICE.getInstance().createFilePathOn(file);
    }

    @NotNull
    public static FilePath getFilePath(@NotNull File file) {
        return VcsContextFactory.SERVICE.getInstance().createFilePathOn(file);
    }

    @NotNull
    public static FilePath getFilePath(@NotNull String path2, boolean isDirectory) {
        return VcsContextFactory.SERVICE.getInstance().createFilePath(path2, isDirectory);
    }

    @NotNull
    public static FilePath getFilePathOnNonLocal(@NotNull String path2, boolean isDirectory) {
        return VcsContextFactory.SERVICE.getInstance().createFilePathOnNonLocal(path2, isDirectory);
    }

    @NotNull
    public static FilePath getFilePath(@NotNull File file, boolean isDirectory) {
        return VcsContextFactory.SERVICE.getInstance().createFilePathOn(file, isDirectory);
    }

    @Deprecated
    @NotNull
    public static FilePath getFilePathForDeletedFile(@NotNull String path2, boolean isDirectory) {
        return VcsContextFactory.SERVICE.getInstance().createFilePathOn(new File(path2), isDirectory);
    }

    @NotNull
    public static FilePath getFilePath(@NotNull VirtualFile parent, @NotNull String name) {
        return VcsContextFactory.SERVICE.getInstance().createFilePathOn(parent, name);
    }

    @NotNull
    public static FilePath getFilePath(@NotNull VirtualFile parent, @NotNull String fileName, boolean isDirectory) {
        return VcsContextFactory.SERVICE.getInstance().createFilePath(parent, fileName, isDirectory);
    }

    @Deprecated
    public static void showStatusMessage(@NotNull Project project, @Nullable String message) {
        SwingUtilities.invokeLater(() -> {
            if (project.isOpen()) {
                StatusBar.Info.set(message, project);
            }
        });
    }

    public static boolean isRenameChange(Change change) {
        boolean isRenamed = false;
        ContentRevision before = change.getBeforeRevision();
        ContentRevision after = change.getAfterRevision();
        if (before != null && after != null) {
            String newFile;
            String prevFile = VcsUtil.getCanonicalLocalPath(before.getFile().getPath());
            isRenamed = !prevFile.equals(newFile = VcsUtil.getCanonicalLocalPath(after.getFile().getPath()));
        }
        return isRenamed;
    }

    public static boolean isChangeForNew(Change change) {
        return change.getBeforeRevision() == null && change.getAfterRevision() != null;
    }

    public static boolean isChangeForDeleted(Change change) {
        return change.getBeforeRevision() != null && change.getAfterRevision() == null;
    }

    public static boolean isChangeForFolder(Change change) {
        ContentRevision revB = change.getBeforeRevision();
        ContentRevision revA = change.getAfterRevision();
        return revA != null && revA.getFile().isDirectory() || revB != null && revB.getFile().isDirectory();
    }

    public static FilePath[] sortPathsFromOutermost(FilePath[] files) {
        return VcsUtil.sortPaths(files, 1);
    }

    private static FilePath[] sortPaths(FilePath[] files, int sign) {
        Arrays.sort(files, (file1, file2) -> sign * file1.getPath().compareTo(file2.getPath()));
        return files;
    }

    @Nullable
    public static VirtualFile getOneVirtualFile(@NotNull AnActionEvent e) {
        VirtualFile[] files = VcsUtil.getVirtualFiles(e);
        return files.length != 1 ? null : files[0];
    }

    public static VirtualFile @NotNull [] getVirtualFiles(@NotNull AnActionEvent e) {
        VirtualFile[] files = e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        return files == null ? VirtualFile.EMPTY_ARRAY : files;
    }

    @Deprecated
    public static boolean runVcsProcessWithProgress(@NotNull VcsRunnable runnable, @NotNull String progressTitle, boolean canBeCanceled, @Nullable Project project) throws VcsException {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            Ref ex = new Ref();
            boolean result = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                try {
                    runnable.run();
                }
                catch (VcsException e) {
                    ex.set((Object)e);
                }
            }, progressTitle, canBeCanceled, project);
            if (!ex.isNull()) {
                throw (VcsException)ex.get();
            }
            return result;
        }
        runnable.run();
        return true;
    }

    public static <T> T computeWithModalProgress(@Nullable Project project, @NotNull @Nls String title, boolean canBeCancelled, final @NotNull ThrowableConvertor<? super ProgressIndicator, T, ? extends VcsException> computable) throws VcsException {
        return ProgressManager.getInstance().run(new Task.WithResult<T, VcsException>(project, title, canBeCancelled){

            @Override
            protected T compute(@NotNull ProgressIndicator indicator) throws VcsException {
                return computable.convert((Object)indicator);
            }
        });
    }

    @Deprecated
    @Nullable
    public static VirtualFile waitForTheFile(@NotNull String path2) {
        return LocalFileSystem.getInstance().refreshAndFindFileByPath(path2);
    }

    public static String getCanonicalLocalPath(String localPath) {
        if ((localPath = VcsUtil.chopTrailingChars(localPath.trim().replace('\\', '/'), ourCharsToBeChopped)).length() == 2 && localPath.charAt(1) == ':') {
            localPath = localPath + '/';
        }
        return localPath;
    }

    public static String getCanonicalPath(String path2) {
        String canonPath;
        try {
            canonPath = new File(path2).getCanonicalPath();
        }
        catch (IOException e) {
            canonPath = path2;
        }
        return canonPath;
    }

    public static String getCanonicalPath(File file) {
        String canonPath;
        try {
            canonPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            canonPath = file.getAbsolutePath();
        }
        return canonPath;
    }

    public static String chopTrailingChars(String source, char[] chars) {
        boolean atLeastOneCharWasChopped;
        StringBuilder sb = new StringBuilder(source);
        do {
            atLeastOneCharWasChopped = false;
            for (int i = 0; i < chars.length && sb.length() > 0; ++i) {
                if (sb.charAt(sb.length() - 1) != chars[i]) continue;
                sb.deleteCharAt(sb.length() - 1);
                atLeastOneCharWasChopped = true;
            }
        } while (atLeastOneCharWasChopped);
        return sb.toString();
    }

    public static String getShortRevisionString(@NotNull VcsRevisionNumber revision) {
        return revision instanceof ShortVcsRevisionNumber ? ((ShortVcsRevisionNumber)revision).toShortString() : revision.asString();
    }

    public static VirtualFile[] paths2VFiles(String[] paths) {
        VirtualFile[] files = new VirtualFile[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            files[i] = VcsUtil.getVirtualFile(paths[i]);
        }
        return files;
    }

    public static boolean isAspectAvailableByDefault(String id) {
        return VcsUtil.isAspectAvailableByDefault(id, true);
    }

    public static boolean isAspectAvailableByDefault(@Nullable String id, boolean defaultValue) {
        if (id == null) {
            return false;
        }
        return PropertiesComponent.getInstance().getBoolean(ANNO_ASPECT + id, defaultValue);
    }

    public static void setAspectAvailability(String aspectID, boolean showByDefault) {
        PropertiesComponent.getInstance().setValue(ANNO_ASPECT + aspectID, String.valueOf(showByDefault));
    }

    public static boolean isPathRemote(String path2) {
        int idx = path2.indexOf("://");
        if (idx == -1) {
            int idx2 = path2.indexOf(":\\\\");
            if (idx2 == -1) {
                return false;
            }
            return idx2 > 0;
        }
        return idx > 0;
    }

    public static String getPathForProgressPresentation(@NotNull File file) {
        return file.getName() + " (" + FileUtil.getLocationRelativeToUserHome((String)file.getParent()) + ")";
    }

    @NotNull
    public static <T> Map<VcsRoot, List<T>> groupByRoots(@NotNull Project project, @NotNull Collection<? extends T> items, @NotNull Function<? super T, ? extends FilePath> filePathMapper) {
        return VcsUtil.groupByRoots(project, items, false, filePathMapper);
    }

    @NotNull
    public static <T> Map<VcsRoot, List<T>> groupByRoots(@NotNull Project project, @NotNull Collection<? extends T> items, boolean putNonVcs, @NotNull Function<? super T, ? extends FilePath> filePathMapper) {
        ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance(project);
        HashMap<VcsRoot, List<T>> map = new HashMap<VcsRoot, List<T>>();
        for (T item : items) {
            VcsRoot vcsRoot = manager.getVcsRootObjectFor((FilePath)filePathMapper.fun(item));
            if (vcsRoot == null && !putNonVcs) continue;
            List list = map.computeIfAbsent(vcsRoot, key -> new ArrayList());
            list.add(item);
        }
        return map;
    }

    @NotNull
    public static List<VcsDirectoryMapping> addMapping(@NotNull List<? extends VcsDirectoryMapping> existingMappings, @NotNull String path2, @NotNull String vcs) {
        ArrayList<VcsDirectoryMapping> mappings = new ArrayList<VcsDirectoryMapping>(existingMappings);
        Iterator iterator = mappings.iterator();
        while (iterator.hasNext()) {
            VcsDirectoryMapping mapping = (VcsDirectoryMapping)iterator.next();
            if (mapping.isDefaultMapping() && mapping.isNoneMapping()) {
                LOG.debug("Removing <Project> -> <None> mapping");
                iterator.remove();
                continue;
            }
            if (!FileUtil.pathsEqual((String)mapping.getDirectory(), (String)path2)) continue;
            if (!StringUtil.isEmptyOrSpaces((String)mapping.getVcs())) {
                LOG.warn("Substituting existing mapping [" + path2 + "] -> [" + mapping.getVcs() + "] with [" + vcs + "]");
            } else {
                LOG.debug("Removing [" + path2 + "] -> <None> mapping");
            }
            iterator.remove();
        }
        mappings.add(new VcsDirectoryMapping(path2, vcs));
        return mappings;
    }

    @NotNull
    public static FilePath getLastCommitPath(@NotNull Project project, @NotNull FilePath path2) {
        if (project.isDefault()) {
            return path2;
        }
        Change change = ChangeListManager.getInstance(project).getChange(path2);
        if (change == null || change.getType() != Change.Type.MOVED || change.getBeforeRevision() == null) {
            return path2;
        }
        return change.getBeforeRevision().getFile();
    }

    @NotNull
    public static Set<String> getVcsIgnoreFileNames(@NotNull Project project) {
        return IgnoredFileContentProvider.IGNORE_FILE_CONTENT_PROVIDER.extensions((AreaInstance)project).map(IgnoredFileContentProvider::getFileName).collect(Collectors.toSet());
    }

    @NotNull
    public static String trimCommitMessageToSaneSize(@NotNull String message) {
        int nthLine = VcsUtil.nthIndexOf(message, '\n', 3000);
        if (nthLine != -1 && nthLine < 50000) {
            return VcsUtil.trimCommitMessageAt(message, nthLine);
        }
        if (message.length() > 50050) {
            return VcsUtil.trimCommitMessageAt(message, 50000);
        }
        return message;
    }

    private static String trimCommitMessageAt(@NotNull String message, int index) {
        return String.format("%s\n\n... Commit message is too long and was truncated by %s ...", message.substring(0, index), ApplicationNamesInfo.getInstance().getProductName());
    }

    private static int nthIndexOf(@NotNull String text, char c, int n) {
        assert (n > 0);
        int length = text.length();
        int count = 0;
        for (int i = 0; i < length; ++i) {
            if (text.charAt(i) != c || ++count != n) continue;
            return i;
        }
        return -1;
    }
}

