/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log;

import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface VcsLogDateFilter
extends VcsLogDetailsFilter {
    @Nullable
    public Date getAfter();

    @Nullable
    public Date getBefore();

    @NotNull
    default public VcsLogFilterCollection.FilterKey<VcsLogDateFilter> getKey() {
        return VcsLogFilterCollection.DATE_FILTER;
    }

    @Override
    @NotNull
    default public String getDisplayText() {
        if (this.getBefore() != null && this.getAfter() != null) {
            return DateFormatUtil.formatBetweenDates((long)this.getAfter().getTime(), (long)this.getBefore().getTime());
        }
        if (this.getAfter() != null) {
            return VcsLogBundle.message("vcs.log.filter.date.display.name.after", DateFormatUtil.formatDate((Date)this.getAfter()));
        }
        if (this.getBefore() != null) {
            return VcsLogBundle.message("vcs.log.filter.date.display.name.before", DateFormatUtil.formatDate((Date)this.getBefore()));
        }
        return "";
    }

    @NotNull
    default public String getDisplayTextWithPrefix() {
        if (this.getBefore() != null && this.getAfter() != null) {
            String betweenDates = DateFormatUtil.formatBetweenDates((long)this.getAfter().getTime(), (long)this.getBefore().getTime());
            return VcsLogBundle.message("vcs.log.filter.date.presentation.with.prefix.made", betweenDates);
        }
        if (this.getAfter() != null) {
            return VcsLogBundle.message("vcs.log.filter.date.presentation.with.prefix.made.after", DateFormatUtil.formatDate((Date)this.getAfter()));
        }
        if (this.getBefore() != null) {
            return VcsLogBundle.message("vcs.log.filter.date.presentation.with.prefix.made.before", DateFormatUtil.formatDate((Date)this.getBefore()));
        }
        return "";
    }
}

