/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.MessageBusOwner;
import com.intellij.util.messages.MessageHandler;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.CompositeMessageBus;
import com.intellij.util.messages.impl.JobQueue;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageBusConnectionImpl;
import com.intellij.util.messages.impl.MessageDeliveryListener;
import com.intellij.util.messages.impl.SimpleMessageBusConnectionImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class MessageBusImpl
implements MessageBus {
    protected static final Logger LOG = Logger.getInstance(MessageBusImpl.class);
    private static final int DISPOSE_IN_PROGRESS = 1;
    private static final int DISPOSED_STATE = 2;
    private static final Object NA = new Object();
    protected final ThreadLocal<JobQueue> myMessageQueue = ThreadLocal.withInitial(JobQueue::new);
    protected final int[] myOrder;
    protected final ConcurrentMap<Topic<?>, Object> publisherCache = new ConcurrentHashMap();
    protected final Collection<MessageHandlerHolder> mySubscribers = new ConcurrentLinkedQueue<MessageHandlerHolder>();
    protected final Map<Topic<?>, List<Object>> subscriberCache = new ConcurrentHashMap();
    @Nullable
    protected final CompositeMessageBus myParentBus;
    protected final RootBus myRootBus;
    protected final MessageBusOwner owner;
    private int disposeState;
    private Disposable myConnectionDisposable = Disposer.newDisposable();
    protected MessageDeliveryListener messageDeliveryListener;

    public MessageBusImpl(@NotNull MessageBusOwner owner, @NotNull CompositeMessageBus parentBus) {
        this.owner = owner;
        this.myParentBus = parentBus;
        this.myRootBus = parentBus.myRootBus;
        MessageBusImpl p = this;
        while ((p = p.myParentBus) != null) {
            p.subscriberCache.clear();
        }
        this.myOrder = parentBus.addChild(this);
    }

    MessageBusImpl(@NotNull MessageBusOwner owner) {
        this.owner = owner;
        this.myOrder = ArrayUtil.EMPTY_INT_ARRAY;
        this.myRootBus = (RootBus)this;
        this.myParentBus = null;
    }

    public final MessageBus getParent() {
        return this.myParentBus;
    }

    public final String toString() {
        return "MessageBus(owner=" + this.owner + ", disposeState= " + this.disposeState + ")";
    }

    @NotNull
    public final MessageBusConnection connect() {
        return this.connect(this.myConnectionDisposable);
    }

    @NotNull
    public final MessageBusConnectionImpl connect(@NotNull Disposable parentDisposable) {
        this.checkNotDisposed();
        MessageBusConnectionImpl connection = new MessageBusConnectionImpl(this);
        this.mySubscribers.add(connection);
        Disposer.register((Disposable)parentDisposable, (Disposable)connection);
        return connection;
    }

    @NotNull
    public final SimpleMessageBusConnection simpleConnect() {
        this.checkNotDisposed();
        SimpleMessageBusConnectionImpl connection = new SimpleMessageBusConnectionImpl(this);
        this.mySubscribers.add(connection);
        return connection;
    }

    @NotNull
    public final <L> L syncPublisher(@NotNull Topic<L> topic) {
        this.checkNotDisposed();
        return (L)this.publisherCache.computeIfAbsent(topic, this::createPublisherInvocationHandler);
    }

    @NotNull
    private Object createPublisherInvocationHandler(@NotNull Topic<?> topic) {
        Class listenerClass = topic.getListenerClass();
        return Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, (InvocationHandler)this.createPublisher(topic, topic.getBroadcastDirection()));
    }

    @NotNull
    protected MessagePublisher createPublisher(@NotNull Topic<?> topic, Topic.BroadcastDirection direction) {
        if (direction == Topic.BroadcastDirection.TO_PARENT) {
            return new ToParentMessagePublisher(topic, this);
        }
        if (direction == Topic.BroadcastDirection.TO_DIRECT_CHILDREN) {
            throw new IllegalArgumentException("Broadcast direction TO_DIRECT_CHILDREN is allowed only for app level message bus. Please publish to app level message bus or change topic broadcast direction to NONE or TO_PARENT");
        }
        LOG.warn("Broadcast direction TO_CHILDREN  is not allowed for module level message bus. Please change to NONE or TO_PARENT");
        return new MessagePublisher(topic, this);
    }

    protected static List<Throwable> executeOrAddToQueue(@NotNull Topic<?> topic, @NotNull Method method, Object[] args, @NotNull List<Object> handlers, @Nullable JobQueue jobQueue, @Nullable MessageDeliveryListener messageDeliveryListener, @Nullable List<Throwable> exceptions) {
        if (jobQueue == null) {
            for (Object handler : handlers) {
                exceptions = MessageBusImpl.invokeListener(method, args, handler, topic, messageDeliveryListener, exceptions);
            }
        } else {
            jobQueue.queue.offerLast(new Message(topic, method, args, handlers));
        }
        return exceptions;
    }

    public final void disposeConnectionChildren() {
        this.disposeState = 1;
        Disposer.disposeChildren((Disposable)this.myConnectionDisposable);
    }

    public final void disposeConnection() {
        Disposer.dispose((Disposable)this.myConnectionDisposable);
        this.myConnectionDisposable = null;
    }

    public void dispose() {
        if (this.disposeState == 2) {
            LOG.error("Already disposed: " + this);
        }
        this.disposeState = 2;
        this.disposeChildren();
        if (this.myConnectionDisposable != null) {
            Disposer.dispose((Disposable)this.myConnectionDisposable);
        }
        JobQueue jobs = this.myMessageQueue.get();
        this.myMessageQueue.remove();
        if (!jobs.queue.isEmpty()) {
            LOG.error("Not delivered events in the queue: " + jobs);
        }
        if (this.myParentBus == null) {
            this.myRootBus.myWaitingBuses.remove();
        } else {
            this.myParentBus.onChildBusDisposed(this);
        }
    }

    protected void disposeChildren() {
    }

    public final boolean isDisposed() {
        return this.disposeState == 2 || this.owner.isDisposed();
    }

    public final boolean hasUndeliveredEvents(@NotNull Topic<?> topic) {
        if (this.isDisposed()) {
            return false;
        }
        Set waitingBuses = this.myRootBus.myWaitingBuses.get();
        if (waitingBuses == null || waitingBuses.isEmpty()) {
            return false;
        }
        for (MessageBusImpl bus : waitingBuses) {
            JobQueue jobQueue = bus.myMessageQueue.get();
            Message current = jobQueue.current;
            if (current != null && current.topic == topic) {
                return true;
            }
            for (Message message : jobQueue.queue) {
                if (message.topic != topic) continue;
                return true;
            }
        }
        return false;
    }

    private void checkNotDisposed() {
        if (this.isDisposed()) {
            LOG.error("Already disposed: " + this);
        }
    }

    protected void doComputeSubscribers(@NotNull Topic<?> topic, @NotNull List<Object> result, boolean subscribeLazyListeners) {
        for (MessageHandlerHolder subscriber : this.mySubscribers) {
            subscriber.collectHandlers(topic, result);
        }
    }

    @NotNull
    protected List<Object> computeSubscribers(@NotNull Topic<?> topic) {
        ArrayList<Object> result = new ArrayList<Object>();
        this.doComputeSubscribers(topic, result, true);
        return result.isEmpty() ? Collections.emptyList() : result;
    }

    private void jobRemoved(@NotNull JobQueue jobQueue) {
        if (jobQueue.current == null && jobQueue.queue.isEmpty()) {
            this.myRootBus.myWaitingBuses.get().remove(this);
        }
    }

    private static void pumpMessages(@NotNull Set<MessageBusImpl> waitingBuses) {
        ArrayList<MessageBusImpl> liveBuses = new ArrayList<MessageBusImpl>(waitingBuses.size());
        for (MessageBusImpl bus : waitingBuses) {
            if (bus.isDisposed()) {
                waitingBuses.remove(bus);
                LOG.error("Accessing disposed message bus " + bus);
                continue;
            }
            liveBuses.add(bus);
        }
        if (!liveBuses.isEmpty()) {
            MessageBusImpl.pumpWaitingBuses(liveBuses);
        }
    }

    private static void pumpWaitingBuses(@NotNull List<MessageBusImpl> buses) {
        List<Throwable> exceptions = null;
        for (MessageBusImpl bus : buses) {
            if (bus.isDisposed()) continue;
            JobQueue jobQueue = bus.myMessageQueue.get();
            Message job = jobQueue.current;
            if (job != null) {
                exceptions = bus.deliverMessage(job, jobQueue, bus.messageDeliveryListener, exceptions);
            }
            while ((job = jobQueue.queue.pollFirst()) != null) {
                exceptions = bus.deliverMessage(job, jobQueue, bus.messageDeliveryListener, exceptions);
            }
        }
        if (exceptions != null) {
            EventDispatcher.throwExceptions(exceptions);
        }
    }

    @Nullable
    private List<Throwable> deliverMessage(@NotNull Message job, @NotNull JobQueue jobQueue, @Nullable MessageDeliveryListener messageDeliveryListener, @Nullable List<Throwable> exceptions) {
        jobQueue.current = job;
        List<Object> handlers = job.handlers;
        int index = job.currentHandlerIndex;
        int size = handlers.size();
        int lastIndex = size - 1;
        while (index < size) {
            if (index == lastIndex) {
                jobQueue.current = null;
                this.jobRemoved(jobQueue);
            }
            ++job.currentHandlerIndex;
            exceptions = MessageBusImpl.invokeListener(job.listenerMethod, job.args, handlers.get(index), job.topic, messageDeliveryListener, exceptions);
            if (++index == job.currentHandlerIndex) continue;
            return exceptions;
        }
        return exceptions;
    }

    protected boolean hasChildren() {
        return false;
    }

    final void notifyOnSubscription(@NotNull Topic<?> topic) {
        this.subscriberCache.remove(topic);
        if (topic.getBroadcastDirection() != Topic.BroadcastDirection.TO_CHILDREN) {
            return;
        }
        MessageBusImpl parentBus = this;
        while ((parentBus = parentBus.myParentBus) != null) {
            parentBus.subscriberCache.remove(topic);
        }
        if (this.hasChildren()) {
            this.notifyOnSubscriptionToTopicToChildren(topic);
        }
    }

    protected void notifyOnSubscriptionToTopicToChildren(@NotNull Topic<?> topic) {
    }

    protected void removeChildConnectionsRecursively(@NotNull Topic<?> topic, @Nullable Object handlers) {
    }

    protected void clearSubscriberCacheRecursively(@Nullable Map<Topic<?>, Object> handlers, @Nullable Topic<?> topic) {
        MessageBusImpl.clearSubscriberCache(this, handlers, topic);
    }

    protected static boolean clearSubscriberCache(@NotNull MessageBusImpl bus, @Nullable Map<Topic<?>, Object> handlers, @Nullable Topic<?> singleTopic) {
        if (handlers == null) {
            if (singleTopic == null) {
                bus.subscriberCache.clear();
                return true;
            }
            return bus.subscriberCache.remove(singleTopic) != null;
        }
        ToChildrenTopicSubscriberCleaner cleaner = new ToChildrenTopicSubscriberCleaner(bus);
        handlers.forEach(cleaner);
        return cleaner.removed;
    }

    protected void removeEmptyConnectionsRecursively() {
        this.mySubscribers.removeIf(MessageHandlerHolder::isDisposed);
    }

    boolean notifyConnectionTerminated(Object[] topicAndHandlerPairs) {
        if (this.disposeState != 0) {
            return false;
        }
        this.myRootBus.scheduleEmptyConnectionRemoving();
        return MessageBusImpl.clearSubscriberCacheOnConnectionTerminated(topicAndHandlerPairs, this);
    }

    private static boolean clearSubscriberCacheOnConnectionTerminated(Object[] topicAndHandlerPairs, @NotNull MessageBusImpl bus) {
        boolean isChildClearingNeeded = false;
        for (int i = 0; i < topicAndHandlerPairs.length; i += 2) {
            Topic.BroadcastDirection direction;
            Topic topic = (Topic)topicAndHandlerPairs[i];
            if (bus.subscriberCache.remove(topic) != null) {
                bus.removeDisposedHandlers(topic, topicAndHandlerPairs[i + 1]);
            }
            if ((direction = topic.getBroadcastDirection()) != Topic.BroadcastDirection.TO_CHILDREN) continue;
            MessageBusImpl parentBus = bus;
            while ((parentBus = parentBus.myParentBus) != null) {
                if (parentBus.subscriberCache.remove(topic) == null) continue;
                parentBus.removeDisposedHandlers(topic, topicAndHandlerPairs[i + 1]);
            }
            if (!bus.hasChildren()) continue;
            isChildClearingNeeded = true;
        }
        return isChildClearingNeeded;
    }

    protected void clearSubscriberCache(Object[] topicAndHandlerPairs) {
        for (int i = 0; i < topicAndHandlerPairs.length; i += 2) {
            this.subscriberCache.remove(topicAndHandlerPairs[i]);
        }
    }

    final void deliverImmediately(@NotNull MessageBusConnectionImpl connection) {
        if (this.disposeState == 2) {
            LOG.error("Already disposed: " + this);
        }
        if (this.owner.isDisposed()) {
            return;
        }
        JobQueue jobQueue = this.myMessageQueue.get();
        Deque<Message> jobs = jobQueue.queue;
        if (jobs.isEmpty()) {
            return;
        }
        List newJobs = null;
        Iterator<Message> jobIterator = jobs.iterator();
        while (jobIterator.hasNext()) {
            Message filteredJob;
            Message job = jobIterator.next();
            List connectionHandlers = null;
            Iterator<Object> handlerIterator = job.handlers.iterator();
            while (handlerIterator.hasNext()) {
                Object handler = handlerIterator.next();
                if (!connection.isMyHandler(job.topic, handler)) continue;
                handlerIterator.remove();
                if (connectionHandlers == null) {
                    connectionHandlers = new SmartList();
                }
                connectionHandlers.add(handler);
            }
            if (connectionHandlers == null) continue;
            if (job.handlers.isEmpty()) {
                jobIterator.remove();
                filteredJob = job;
                job.handlers.addAll(connectionHandlers);
            } else {
                filteredJob = new Message(job.topic, job.listenerMethod, job.args, connectionHandlers);
            }
            if (newJobs == null) {
                newJobs = new SmartList();
            }
            newJobs.add(filteredJob);
        }
        if (newJobs == null) {
            return;
        }
        for (int i = newJobs.size() - 1; i >= 0; --i) {
            jobs.addFirst((Message)newJobs.get(i));
        }
        List<Throwable> exceptions = null;
        for (Message job : newJobs) {
            jobs.removeFirstOccurrence(job);
            exceptions = this.deliverMessage(job, jobQueue, this.messageDeliveryListener, exceptions);
        }
        if (exceptions != null) {
            EventDispatcher.throwExceptions(exceptions);
        }
    }

    public final void setMessageDeliveryListener(@Nullable MessageDeliveryListener listener2) {
        if (this.messageDeliveryListener != null && listener2 != null) {
            throw new IllegalStateException("Already set: " + this.messageDeliveryListener);
        }
        this.messageDeliveryListener = listener2;
    }

    @Nullable
    private static List<Throwable> invokeListener(@NotNull Method method, Object[] args, @NotNull Object handler, @NotNull Topic<?> topic, @Nullable MessageDeliveryListener messageDeliveryListener, @Nullable List<Throwable> exceptions) {
        try {
            if (handler instanceof MessageHandler) {
                ((MessageHandler)handler).handle(method, args);
            } else if (messageDeliveryListener == null) {
                method.invoke(handler, args);
            } else {
                long startTime = System.nanoTime();
                method.invoke(handler, args);
                messageDeliveryListener.messageDelivered(topic, method.getName(), handler, System.nanoTime() - startTime);
            }
        }
        catch (Throwable e) {
            exceptions = EventDispatcher.handleException((Throwable)e, exceptions);
        }
        return exceptions;
    }

    protected void disconnectPluginConnections(@NotNull Predicate<Class<?>> predicate) {
        for (MessageHandlerHolder holder : this.mySubscribers) {
            holder.disconnectIfNeeded(predicate);
        }
    }

    private void removeDisposedHandlers(@NotNull Topic<?> topic, @NotNull Object handler) {
        JobQueue jobQueue = this.myMessageQueue.get();
        if (!jobQueue.queue.isEmpty() && jobQueue.queue.removeIf(job -> job.topic == topic && job.handlers.removeIf(it -> it == handler) && job.handlers.isEmpty())) {
            this.jobRemoved(jobQueue);
        }
    }

    static final class RootBus
    extends CompositeMessageBus {
        private final AtomicReference<CompletableFuture<?>> compactionFutureRef = new AtomicReference();
        private final AtomicInteger emptyConnectionCounter = new AtomicInteger();
        final ThreadLocal<SortedSet<MessageBusImpl>> myWaitingBuses = ThreadLocal.withInitial(() -> new TreeSet((bus1, bus2) -> ArrayUtil.lexicographicCompare((int[])bus1.myOrder, (int[])bus2.myOrder)));

        RootBus(@NotNull MessageBusOwner owner) {
            super(owner);
        }

        void scheduleEmptyConnectionRemoving() {
            CompletableFuture<Void> future;
            int counter = this.emptyConnectionCounter.incrementAndGet();
            if (counter < 128 || !this.emptyConnectionCounter.compareAndSet(counter, 0)) {
                return;
            }
            CompletableFuture<?> oldFuture = this.compactionFutureRef.get();
            if (oldFuture == null && !this.compactionFutureRef.compareAndSet(null, future = CompletableFuture.runAsync(() -> {
                this.removeEmptyConnectionsRecursively();
                this.compactionFutureRef.set(null);
            }, AppExecutorUtil.getAppExecutorService()))) {
                future.cancel(false);
            }
        }

        void _removeEmptyConnectionsRecursively() {
            this.removeEmptyConnectionsRecursively();
        }

        @Override
        public void dispose() {
            CompletableFuture compactionFuture = this.compactionFutureRef.getAndSet(null);
            if (compactionFuture != null) {
                compactionFuture.cancel(false);
            }
            super.dispose();
        }
    }

    private static final class ToChildrenTopicSubscriberCleaner
    implements BiConsumer<Topic<?>, Object> {
        private final MessageBusImpl bus;
        boolean removed;

        ToChildrenTopicSubscriberCleaner(@NotNull MessageBusImpl bus) {
            this.bus = bus;
        }

        @Override
        public void accept(Topic<?> topic, Object __) {
            Topic.BroadcastDirection direction = topic.getBroadcastDirection();
            if (direction == Topic.BroadcastDirection.TO_CHILDREN && this.bus.subscriberCache.remove(topic) != null) {
                this.removed = true;
            }
        }
    }

    protected static final class ToParentMessagePublisher
    extends MessagePublisher
    implements InvocationHandler {
        ToParentMessagePublisher(@NotNull Topic<?> topic, @NotNull MessageBusImpl bus) {
            super(topic, bus);
        }

        @Override
        protected boolean publish(@NotNull Method method, Object[] args, @Nullable JobQueue jobQueue) {
            List<Throwable> exceptions = null;
            MessageBusImpl parentBus = this.bus;
            boolean hasHandlers = false;
            do {
                List handlers;
                if ((handlers = parentBus.subscriberCache.computeIfAbsent(this.topic, parentBus::computeSubscribers)).isEmpty()) continue;
                hasHandlers = true;
                exceptions = MessageBusImpl.executeOrAddToQueue(this.topic, method, args, handlers, jobQueue, this.bus.messageDeliveryListener, exceptions);
            } while ((parentBus = parentBus.myParentBus) != null);
            if (exceptions != null) {
                EventDispatcher.throwExceptions(exceptions);
            }
            return hasHandlers;
        }
    }

    protected static class MessagePublisher
    implements InvocationHandler {
        @NotNull
        protected final Topic<?> topic;
        @NotNull
        protected final MessageBusImpl bus;

        MessagePublisher(@NotNull Topic<?> topic, @NotNull MessageBusImpl bus) {
            this.topic = topic;
            this.bus = bus;
        }

        @Override
        public final Object invoke(Object proxy, Method method, Object[] args) {
            JobQueue jobQueue;
            Set busQueue;
            if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
                return EventDispatcher.handleObjectMethod((Object)proxy, (Object[])args, (String)method.getName());
            }
            this.bus.checkNotDisposed();
            boolean isImmediateDelivery = this.topic.isImmediateDelivery();
            if (isImmediateDelivery) {
                busQueue = null;
                jobQueue = null;
            } else {
                busQueue = this.bus.myRootBus.myWaitingBuses.get();
                jobQueue = this.bus.myMessageQueue.get();
                MessageBusImpl.pumpMessages(busQueue);
            }
            if (this.publish(method, args, jobQueue) && !isImmediateDelivery) {
                busQueue.add(this.bus);
                MessageBusImpl.pumpMessages(busQueue);
            }
            return NA;
        }

        protected boolean publish(@NotNull Method method, Object[] args, @Nullable JobQueue jobQueue) {
            List handlers = this.bus.subscriberCache.computeIfAbsent(this.topic, this.bus::computeSubscribers);
            if (handlers.isEmpty()) {
                return false;
            }
            List<Throwable> exceptions = MessageBusImpl.executeOrAddToQueue(this.topic, method, args, handlers, jobQueue, this.bus.messageDeliveryListener, null);
            if (exceptions != null) {
                EventDispatcher.throwExceptions(exceptions);
            }
            return true;
        }
    }

    static interface MessageHandlerHolder {
        public void collectHandlers(@NotNull Topic<?> var1, @NotNull List<Object> var2);

        public void disconnectIfNeeded(@NotNull Predicate<Class<?>> var1);

        public boolean isDisposed();
    }
}

